/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.config.ItemCheatingMode;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_746;

public class FavoritesListWidget
extends WidgetWithBounds {
    protected double target;
    protected double scroll;
    protected long start;
    protected long duration;
    protected int blockedCount;
    List<EntryStack> favorites = null;
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryListEntry> entries = Collections.emptyList();
    private boolean draggingScrollBar = false;

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / 18.0f)), 1);
        if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
            return new Rectangle(bounds.getCenterX() - width * 9 + 3, bounds.y, width * 18, bounds.height);
        }
        return new Rectangle(bounds.getCenterX() - width * 9 - 3, bounds.y, width * 18, bounds.height);
    }

    protected final int getMaxScrollPosition() {
        return class_3532.method_15386((float)((float)(this.favorites.size() + this.blockedCount) / ((float)this.innerBounds.width / 18.0f))) * 18;
    }

    protected final int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - this.innerBounds.height);
    }

    protected final double clamp(double v) {
        return this.clamp(v, 200.0);
    }

    protected final double clamp(double v, double clampExtension) {
        return class_3532.method_15350((double)v, (double)(-clampExtension), (double)((double)this.getMaxScroll() + clampExtension));
    }

    protected final void offset(double value, boolean animated) {
        this.scrollTo(this.target + value, animated);
    }

    protected final void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    protected final void scrollTo(double value, boolean animated, long duration) {
        this.target = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scroll = this.target;
        }
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.bounds.contains(double_1, double_2)) {
            this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(int mouseX, int mouseY, float delta) {
        int nextIndex;
        for (EntryListEntry entry : this.entries) {
            entry.clearStacks();
        }
        ScissorsHandler.INSTANCE.scissor(this.bounds);
        int skip = Math.max(0, class_3532.method_15357((double)(this.scroll / 18.0)));
        this.blockedCount = 0;
        block1: for (int i = nextIndex = skip * this.innerBounds.width / 18; i < this.favorites.size(); ++i) {
            EntryStack stack = this.favorites.get(i);
            while (true) {
                EntryListEntry entry = this.entries.get(nextIndex);
                entry.getBounds().y = (int)((double)entry.backupY - this.scroll);
                if (entry.getBounds().y > this.bounds.getMaxY()) break block1;
                if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                    entry.entry(stack);
                    entry.render(mouseX, mouseY, delta);
                    ++nextIndex;
                    continue block1;
                }
                ++this.blockedCount;
                ++nextIndex;
            }
        }
        this.updatePosition(delta);
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.renderScrollbar();
    }

    private int getScrollbarMinX() {
        if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
            return this.bounds.x + 1;
        }
        return this.bounds.getMaxX() - 7;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        int actualHeight;
        float height;
        if (int_1 == 0 && this.draggingScrollBar && (height = (float)this.getMaxScrollPosition()) > (float)(actualHeight = this.innerBounds.height) && mouseY >= (double)this.innerBounds.y && mouseY <= (double)this.innerBounds.getMaxY()) {
            double double_5 = Math.max(1, this.getMaxScroll());
            int int_2 = this.innerBounds.height;
            int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
            double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
            float to = class_3532.method_15363((float)((float)(this.scroll + double_4 * double_6)), (float)0.0f, (float)(height - (float)this.innerBounds.height));
            if (ConfigObject.getInstance().doesSnapToRows()) {
                double nearestRow = (double)Math.round((double)to / 18.0) * 18.0;
                this.scrollTo(nearestRow, false);
            } else {
                this.scrollTo(to, false);
            }
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    private void renderScrollbar() {
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int height = this.innerBounds.height * this.innerBounds.height / this.getMaxScrollPosition();
            height = class_3532.method_15340((int)height, (int)32, (int)(this.innerBounds.height - 8));
            height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)maxScroll ? (int)this.scroll - maxScroll : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.scroll * (this.innerBounds.height - height) / maxScroll + this.innerBounds.y, this.innerBounds.y), this.innerBounds.getMaxY() - height);
            int scrollbarPositionMinX = this.getScrollbarMinX();
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse());
            float bottomC = (hovered ? 0.67f : 0.5f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
            float topC = (hovered ? 0.87f : 0.67f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.shadeModel((int)7425);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height), 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            tessellator.method_1350();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            tessellator.method_1350();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }
    }

    private void updatePosition(float delta) {
        this.target = this.clamp(this.target);
        if (this.target < 0.0) {
            this.target -= this.target * (1.0 - ClothConfigInitializer.getBounceBackMultiplier()) * (double)delta / 3.0;
        } else if (this.target > (double)this.getMaxScroll()) {
            this.target = (this.target - (double)this.getMaxScroll()) * (1.0 - (1.0 - ClothConfigInitializer.getBounceBackMultiplier()) * (double)delta / 3.0) + (double)this.getMaxScroll();
        } else if (ConfigObject.getInstance().doesSnapToRows()) {
            double nearestRow = (double)Math.round(this.target / 18.0) * 18.0;
            this.target = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.target, (double)nearestRow, (double)0.001f) ? (this.target += (nearestRow - this.target) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scroll = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scroll, (double)this.target, (double)0.001f) ? (double)((float)DynamicNewSmoothScrollingEntryListWidget.Interpolation.expoEase((double)this.scroll, (double)this.target, (double)Math.min((double)(System.currentTimeMillis() - this.start) / (double)this.duration, 1.0))) : this.target;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.fromMouse())) {
            for (Widget widget : this.children()) {
                if (!widget.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateFavoritesBounds(DisplayHelper.DisplayBoundsHandler boundsHandler, @Nullable String searchTerm) {
        this.bounds = boundsHandler.getFavoritesListArea(!ConfigObject.getInstance().isLeftHandSidePanel() ? boundsHandler.getLeftBounds(class_310.method_1551().field_1755) : boundsHandler.getRightBounds(class_310.method_1551().field_1755));
    }

    public void updateSearch(EntryListWidget listWidget, String searchTerm) {
        if (ConfigObject.getInstance().isFavoritesEnabled() && ConfigObject.getInstance().doDisplayFavoritesOnTheLeft()) {
            LinkedList list = Lists.newLinkedList();
            boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
            List<EntryStack> workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
            for (EntryStack stack : ConfigManager.getInstance().getFavorites()) {
                if (!listWidget.canLastSearchTermsBeAppliedTo(stack) || workingItems != null && CollectionUtils.findFirstOrNullEquals(workingItems, stack) == null) continue;
                list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, EntryListWidget.RENDER_ENCHANTMENT_GLINT));
            }
            ItemListOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
            if (ordering == ItemListOrdering.name) {
                list.sort(EntryListWidget.ENTRY_NAME_COMPARER);
            }
            if (ordering == ItemListOrdering.item_groups) {
                list.sort(EntryListWidget.ENTRY_GROUP_COMPARER);
            }
            if (!ConfigObject.getInstance().isItemListAscending()) {
                Collections.reverse(list);
            }
            this.favorites = list;
        } else {
            this.favorites = Collections.emptyList();
        }
    }

    public void updateEntriesPosition() {
        this.innerBounds = FavoritesListWidget.updateInnerBounds(this.bounds);
        int width = this.innerBounds.width / 18;
        int pageHeight = this.innerBounds.height / 18;
        int slotsToPrepare = this.favorites.size() * 3;
        int currentX = 0;
        int currentY = 0;
        LinkedList entries = Lists.newLinkedList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * 18 + this.innerBounds.x;
            int yPos = currentY * 18 + this.innerBounds.y;
            entries.add((EntryListEntry)new EntryListEntry(xPos, yPos).noBackground());
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
    }

    public List<? extends Widget> children() {
        return this.entries;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        double scrollbarPositionMinX;
        int actualHeight;
        double height = this.getMaxScroll();
        if (height > (double)(actualHeight = this.bounds.height) && double_2 >= (double)this.bounds.y && double_2 <= (double)this.bounds.getMaxY() && double_1 >= (scrollbarPositionMinX = (double)this.getScrollbarMinX()) - 1.0 & double_1 <= scrollbarPositionMinX + 8.0) {
            this.draggingScrollBar = true;
            return true;
        }
        this.draggingScrollBar = false;
        if (this.containsMouse(double_1, double_2)) {
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
            for (Widget widget : this.children()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    private class EntryListEntry
    extends EntryWidget {
        private int backupY;

        private EntryListEntry(int x, int y) {
            super(x, y);
            this.backupY = y;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FavoritesListWidget.this.bounds.contains(mouseX, mouseY);
        }

        @Override
        protected void drawHighlighted(int mouseX, int mouseY, float delta) {
            if (this.getCurrentEntry().getType() != EntryStack.Type.EMPTY) {
                super.drawHighlighted(mouseX, mouseY, delta);
            }
        }

        private String getLocalizedName(class_3675.class_306 value) {
            String string_1 = value.method_1441();
            int int_1 = value.method_1444();
            String string_2 = null;
            switch (value.method_1442()) {
                case field_1668: {
                    string_2 = class_3675.method_15988((int)int_1);
                    break;
                }
                case field_1671: {
                    string_2 = class_3675.method_15982((int)int_1);
                    break;
                }
                case field_1672: {
                    String string_3 = class_1074.method_4662((String)string_1, (Object[])new Object[0]);
                    string_2 = Objects.equals(string_3, string_1) ? class_1074.method_4662((String)class_3675.class_307.field_1672.method_15989(), (Object[])new Object[]{int_1 + 1}) : string_3;
                }
            }
            return string_2 == null ? class_1074.method_4662((String)string_1, (Object[])new Object[0]) : string_2;
        }

        @Override
        protected void queueTooltip(int mouseX, int mouseY, float delta) {
            QueuedTooltip tooltip;
            if ((!ClientHelper.getInstance().isCheating() || this.minecraft.field_1724.field_7514.method_7399().method_7960()) && (tooltip = this.getCurrentTooltip(mouseX, mouseY)) != null) {
                if (ConfigObject.getInstance().doDisplayFavoritesTooltip()) {
                    String name = this.getLocalizedName(ConfigObject.getInstance().getFavoriteKeybind());
                    tooltip.getText().addAll(Arrays.asList(class_1074.method_4662((String)"text.rei.remove_favorites_tooltip", (Object[])new Object[]{name}).split("\n")));
                }
                ScreenHelper.getLastOverlay().addTooltip(tooltip);
            }
        }

        @Override
        public boolean keyPressed(int int_1, int int_2, int int_3) {
            if (this.interactable && ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(PointHelper.fromMouse()) && !this.getCurrentEntry().isEmpty()) {
                class_3675.class_306 keyCode = ConfigObject.getInstance().getFavoriteKeybind();
                if (int_1 == class_3675.field_16237.method_1444()) {
                    if (keyCode.method_1442() == class_3675.class_307.field_1671 && keyCode.method_1444() == int_2) {
                        ConfigManager.getInstance().getFavorites().remove(this.getCurrentEntry());
                        ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                        ConfigManager.getInstance().saveConfig();
                        this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        return true;
                    }
                } else if (keyCode.method_1442() == class_3675.class_307.field_1668 && keyCode.method_1444() == int_1) {
                    ConfigManager.getInstance().getFavorites().remove(this.getCurrentEntry());
                    ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                    ConfigManager.getInstance().saveConfig();
                    this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                    return true;
                }
            }
            return super.keyPressed(int_1, int_2, int_3);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.interactable) {
                return super.mouseClicked(mouseX, mouseY, button);
            }
            if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating()) {
                EntryStack entry = this.getCurrentEntry().copy();
                if (entry.getType() == EntryStack.Type.ITEM) {
                    if (ConfigObject.getInstance().getItemCheatingMode() == ItemCheatingMode.REI_LIKE) {
                        entry.setAmount(button != 1 ? 1 : entry.getItemStack().method_7914());
                    } else if (ConfigObject.getInstance().getItemCheatingMode() == ItemCheatingMode.JEI_LIKE) {
                        entry.setAmount(button != 0 ? 1 : entry.getItemStack().method_7914());
                    } else {
                        entry.setAmount(1);
                    }
                }
                ClientHelper.getInstance().tryCheatingEntry(entry);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }
}

