/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.*;
import me.shedaniel.rei.gui.PreRecipeViewingScreen;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.zeroeightsix.fiber.exception.FiberException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.FabricKeyBinding;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.impl.client.keybinding.KeyBindingRegistryImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_481;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ClientHelperImpl implements ClientHelper, ClientModInitializer {
    
    public static ClientHelperImpl instance;
    private final class_2960 recipeKeybind = new class_2960("roughlyenoughitems", "recipe_keybind");
    private final class_2960 usageKeybind = new class_2960("roughlyenoughitems", "usage_keybind");
    private final class_2960 hideKeybind = new class_2960("roughlyenoughitems", "hide_keybind");
    private final class_2960 previousPageKeybind = new class_2960("roughlyenoughitems", "previous_page");
    private final class_2960 nextPageKeybind = new class_2960("roughlyenoughitems", "next_page");
    private final class_2960 focusSearchFieldKeybind = new class_2960("roughlyenoughitems", "focus_search");
    private final class_2960 copyRecipeIdentifierKeybind = new class_2960("roughlyenoughitems", "copy_recipe_id");
    private final Map<String, String> modNameCache = Maps.newHashMap();
    public FabricKeyBinding recipe, usage, hide, previousPage, nextPage, focusSearchField, copyRecipeIdentifier;
    
    @Override
    public String getFormattedModFromItem(class_1792 item) {
        String mod = getModFromItem(item);
        if (mod.isEmpty())
            return "";
        return class_124.field_1078.toString() + class_124.field_1056.toString() + mod;
    }
    
    @Override
    public String getFormattedModFromIdentifier(class_2960 identifier) {
        String mod = getModFromIdentifier(identifier);
        if (mod.isEmpty())
            return "";
        return class_124.field_1078.toString() + class_124.field_1056.toString() + mod;
    }
    
    @Override
    public FabricKeyBinding getRecipeKeyBinding() {
        return recipe;
    }
    
    @Override
    public FabricKeyBinding getUsageKeyBinding() {
        return usage;
    }
    
    @Override
    public FabricKeyBinding getHideKeyBinding() {
        return hide;
    }
    
    @Override
    public FabricKeyBinding getPreviousPageKeyBinding() {
        return previousPage;
    }
    
    @Override
    public FabricKeyBinding getNextPageKeyBinding() {
        return nextPage;
    }
    
    @Override
    public FabricKeyBinding getFocusSearchFieldKeyBinding() {
        return focusSearchField;
    }
    
    @Override
    public FabricKeyBinding getCopyRecipeIdentifierKeyBinding() {
        return copyRecipeIdentifier;
    }
    
    @Override
    public String getModFromItem(class_1792 item) {
        if (item.equals(class_1802.field_8162))
            return "";
        return getModFromIdentifier(class_2378.field_11142.method_10221(item));
    }
    
    @Override
    public String getModFromIdentifier(class_2960 identifier) {
        if (identifier == null)
            return "";
        Optional<String> any = Optional.ofNullable(modNameCache.getOrDefault(identifier.method_12836(), null));
        if (any.isPresent())
            return any.get();
        String modid = identifier.method_12836();
        String s = FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modid);
        modNameCache.put(modid, s);
        return s;
    }
    
    @Override
    public boolean isCheating() {
        return RoughlyEnoughItemsCore.getConfigManager().getConfig().isCheating();
    }
    
    @Override
    public void setCheating(boolean cheating) {
        RoughlyEnoughItemsCore.getConfigManager().getConfig().setCheating(cheating);
        try {
            RoughlyEnoughItemsCore.getConfigManager().saveConfig();
        } catch (IOException | FiberException e) {
            e.printStackTrace();
        }
    }
    
    @Override
    public void sendDeletePacket() {
        if (ScreenHelper.getLastContainerScreen() instanceof class_481) {
            class_310.method_1551().field_1724.field_7514.method_7396(class_1799.field_8037);
            return;
        }
        ClientSidePacketRegistry.INSTANCE.sendToServer(RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET, new class_2540(Unpooled.buffer()));
    }
    
    @Override
    public boolean tryCheatingEntry(EntryStack entry) {
        if (entry.getType() != EntryStack.Type.ITEM)
            return false;
        class_1799 cheatedStack = entry.getItemStack().method_7972();
        if (RoughlyEnoughItemsCore.canUsePackets()) {
            try {
                ClientSidePacketRegistry.INSTANCE.sendToServer(RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET, new class_2540(Unpooled.buffer()).method_10793(cheatedStack));
                return true;
            } catch (Exception e) {
                return false;
            }
        } else {
            class_2960 identifier = entry.getIdentifier().orElse(null);
            if (identifier == null)
                return false;
            String tagMessage = cheatedStack.method_7972().method_7969() != null && !cheatedStack.method_7972().method_7969().isEmpty() ? cheatedStack.method_7972().method_7969().method_10714() : "";
            String og = cheatedStack.method_7947() == 1 ? RoughlyEnoughItemsCore.getConfigManager().getConfig().getGiveCommand().replaceAll(" \\{count}", "") : RoughlyEnoughItemsCore.getConfigManager().getConfig().getGiveCommand();
            String madeUpCommand = og.replaceAll("\\{player_name}", class_310.method_1551().field_1724.method_5820()).replaceAll("\\{item_name}", identifier.method_12832()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", tagMessage).replaceAll("\\{count}", String.valueOf(cheatedStack.method_7947()));
            if (madeUpCommand.length() > 256) {
                madeUpCommand = og.replaceAll("\\{player_name}", class_310.method_1551().field_1724.method_5820()).replaceAll("\\{item_name}", identifier.method_12832()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", "").replaceAll("\\{count}", String.valueOf(cheatedStack.method_7947()));
                class_310.method_1551().field_1724.method_7353(new class_2588("text.rei.too_long_nbt"), false);
            }
            class_310.method_1551().field_1724.method_3142(madeUpCommand);
            return true;
        }
    }
    
    @Override
    public boolean executeRecipeKeyBind(EntryStack stack) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = RecipeHelper.getInstance().getRecipesFor(stack);
        if (map.keySet().size() > 0)
            openRecipeViewingScreen(map);
        return map.keySet().size() > 0;
    }
    
    @Override
    public boolean executeUsageKeyBind(EntryStack stack) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = RecipeHelper.getInstance().getUsagesFor(stack);
        if (map.keySet().size() > 0)
            openRecipeViewingScreen(map);
        return map.keySet().size() > 0;
    }
    
    @Override
    public List<class_1799> getInventoryItemsTypes() {
        List<class_2371<class_1799>> field_7543 = ImmutableList.of(class_310.method_1551().field_1724.field_7514.field_7547, class_310.method_1551().field_1724.field_7514.field_7548, class_310.method_1551().field_1724.field_7514.field_7544);
        List<class_1799> inventoryStacks = new ArrayList<>();
        field_7543.forEach(itemStacks -> itemStacks.forEach(itemStack -> {
            if (!itemStack.method_7960())
                inventoryStacks.add(itemStack);
        }));
        return inventoryStacks;
    }
    
    @Override
    public boolean executeViewAllRecipesKeyBind() {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = RecipeHelper.getInstance().getAllRecipes();
        if (map.keySet().size() > 0)
            openRecipeViewingScreen(map);
        return map.keySet().size() > 0;
    }
    
    @Override
    public boolean executeViewAllRecipesFromCategory(class_2960 category) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = Maps.newLinkedHashMap();
        Optional<RecipeCategory> any = RecipeHelper.getInstance().getAllCategories().stream().filter(c -> c.getIdentifier().equals(category)).findAny();
        if (!any.isPresent())
            return false;
        RecipeCategory<?> recipeCategory = any.get();
        map.put(recipeCategory, RecipeHelper.getInstance().getAllRecipesFromCategory(recipeCategory));
        if (map.keySet().size() > 0)
            openRecipeViewingScreen(map);
        return map.keySet().size() > 0;
    }
    
    @Override
    public boolean executeViewAllRecipesFromCategories(List<class_2960> categories) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = Maps.newLinkedHashMap();
        for (class_2960 category : categories) {
            Optional<RecipeCategory> any = RecipeHelper.getInstance().getAllCategories().stream().filter(c -> c.getIdentifier().equals(category)).findAny();
            if (!any.isPresent())
                continue;
            RecipeCategory<?> recipeCategory = any.get();
            map.put(recipeCategory, RecipeHelper.getInstance().getAllRecipesFromCategory(recipeCategory));
        }
        if (map.keySet().size() > 0)
            openRecipeViewingScreen(map);
        return map.keySet().size() > 0;
    }
    
    @Override
    public void openRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> map) {
        class_437 screen = null;
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().getRecipeScreenType() == RecipeScreenType.VILLAGER)
            screen = new VillagerRecipeViewingScreen(map);
        else if (RoughlyEnoughItemsCore.getConfigManager().getConfig().getRecipeScreenType() == RecipeScreenType.UNSET)
            screen = new PreRecipeViewingScreen(map);
        else
            screen = new RecipeViewingScreen(map);
        ScreenHelper.storeRecipeScreen(class_310.method_1551().field_1755);
        class_310.method_1551().method_1507(screen);
    }
    
    @Override
    public void onInitializeClient() {
        ClientHelperImpl.instance = (ClientHelperImpl) this;
        registerFabricKeyBinds();
        modNameCache.put("minecraft", "Minecraft");
        modNameCache.put("c", "Common");
    }
    
    @Override
    public void registerFabricKeyBinds() {
        String category = "key.rei.category";
        KeyBindingRegistryImpl.INSTANCE.addCategory(category);
        KeyBindingRegistryImpl.INSTANCE.register(recipe = FabricKeyBinding.Builder.create(recipeKeybind, class_3675.class_307.field_1668, 82, category).build());
        KeyBindingRegistryImpl.INSTANCE.register(usage = FabricKeyBinding.Builder.create(usageKeybind, class_3675.class_307.field_1668, 85, category).build());
        KeyBindingRegistryImpl.INSTANCE.register(hide = FabricKeyBinding.Builder.create(hideKeybind, class_3675.class_307.field_1668, 79, category).build());
        KeyBindingRegistryImpl.INSTANCE.register(previousPage = FabricKeyBinding.Builder.create(previousPageKeybind, class_3675.class_307.field_1668, -1, category).build());
        KeyBindingRegistryImpl.INSTANCE.register(nextPage = FabricKeyBinding.Builder.create(nextPageKeybind, class_3675.class_307.field_1668, -1, category).build());
        KeyBindingRegistryImpl.INSTANCE.register(focusSearchField = FabricKeyBinding.Builder.create(focusSearchFieldKeybind, class_3675.class_307.field_1668, -1, category).build());
        KeyBindingRegistryImpl.INSTANCE.register(copyRecipeIdentifier = FabricKeyBinding.Builder.create(copyRecipeIdentifierKeybind, class_3675.class_307.field_1668, -1, category).build());
    }
    
}
