/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.brewing;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultBrewingDisplay implements RecipeDisplay {
    
    private EntryStack input, output;
    private List<EntryStack> reactant;
    
    public DefaultBrewingDisplay(class_1799 input, class_1856 reactant, class_1799 output) {
        this.input = EntryStack.create(input).setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, stack -> Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662("category.rei.brewing.input")));
        this.reactant = new ArrayList<>();
        for (class_1799 stack : reactant.method_8105()) {
            EntryStack entryStack = EntryStack.create(stack);
            entryStack.setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662("category.rei.brewing.reactant")));
            this.reactant.add(entryStack);
        }
        this.output = EntryStack.create(output).setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, stack -> Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662("category.rei.brewing.result")));
    }
    
    @Override
    public List<List<EntryStack>> getInputEntries() {
        return Lists.newArrayList(Collections.singletonList(input), reactant);
    }
    
    @Override
    public List<EntryStack> getOutputEntries() {
        return Collections.singletonList(output);
    }
    
    @Override
    public class_2960 getRecipeCategory() {
        return DefaultPlugin.BREWING;
    }
    
    public List<EntryStack> getOutput(int slot) {
        List<EntryStack> stack = new ArrayList<>();
        for (int i = 0; i < slot * 2; i++)
            stack.add(EntryStack.empty());
        for (int i = 0; i < 6 - slot * 2; i++)
            stack.addAll(getOutputEntries());
        return stack;
    }
    
    @Override
    public List<List<EntryStack>> getRequiredEntries() {
        return getInputEntries();
    }
}
