/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.composting;

import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import java.util.*;
import java.util.stream.Collectors;

public class DefaultCompostingDisplay implements RecipeDisplay {
    
    private List<EntryStack> order, allItems;
    private Map<class_1935, Float> inputMap;
    private List<EntryStack> output;
    private int page;
    
    public DefaultCompostingDisplay(int page, List<class_1935> order, Map<class_1935, Float> inputMap, List<class_1935> allItems, class_1799[] output) {
        this.page = page;
        this.order = order.stream().map(EntryStack::create).collect(Collectors.toList());
        this.inputMap = inputMap;
        this.output = Arrays.asList(output).stream().map(EntryStack::create).collect(Collectors.toList());
        this.allItems = allItems.stream().map(EntryStack::create).collect(Collectors.toList());
    }
    
    public int getPage() {
        return page;
    }
    
    @Override
    public List<List<EntryStack>> getInputEntries() {
        List<List<EntryStack>> lists = new ArrayList<>();
        for (EntryStack allItem : allItems) {
            lists.add(Collections.singletonList(allItem));
        }
        return lists;
    }
    
    public Map<class_1935, Float> getInputMap() {
        return inputMap;
    }
    
    @Override
    public List<EntryStack> getOutputEntries() {
        return output;
    }
    
    @Override
    public class_2960 getRecipeCategory() {
        return DefaultPlugin.COMPOSTING;
    }
    
    @Override
    public List<List<EntryStack>> getRequiredEntries() {
        return Collections.singletonList(allItems);
    }
    
    public List<EntryStack> getItemsByOrder() {
        return order;
    }
    
}
