/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.widget.AutoCraftingButtonWidget;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.CategoryBaseWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.RecipeChoosePageWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class RecipeViewingScreen
extends class_437 {
    public static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final int TABS_PER_PAGE = 5;
    private final List<Widget> preWidgets = Lists.newArrayList();
    private final List<Widget> widgets = Lists.newArrayList();
    private final List<TabWidget> tabs;
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoriesMap;
    private final List<RecipeCategory<?>> categories;
    public int guiWidth;
    public int guiHeight;
    public int page;
    public int categoryPages = 0;
    public int largestWidth;
    public int largestHeight;
    public boolean choosePageActivated;
    public RecipeChoosePageWidget recipeChoosePageWidget;
    private Rectangle bounds;
    private RecipeCategory<RecipeDisplay> selectedCategory;
    private ButtonWidget recipeBack;
    private ButtonWidget recipeNext;
    private ButtonWidget categoryBack;
    private ButtonWidget categoryNext;

    public RecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> categoriesMap) {
        super((class_2561)new class_2585(""));
        class_1041 window = class_310.method_1551().method_22683();
        this.bounds = new Rectangle(window.method_4486() / 2 - this.guiWidth / 2, window.method_4502() / 2 - this.guiHeight / 2, 176, 186);
        this.categoriesMap = categoriesMap;
        this.categories = Lists.newArrayList();
        RecipeHelper.getInstance().getAllCategories().forEach(category -> {
            if (categoriesMap.containsKey(category)) {
                this.categories.add((RecipeCategory<?>)category);
            }
        });
        this.selectedCategory = this.categories.get(0);
        this.tabs = new ArrayList<TabWidget>();
        this.choosePageActivated = false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 256 && this.choosePageActivated) {
            this.choosePageActivated = false;
            this.init();
            return true;
        }
        if ((int_1 == 256 || this.minecraft.field_1690.field_1822.method_1417(int_1, int_2)) && this.shouldCloseOnEsc()) {
            class_310.method_1551().method_1507(ScreenHelper.getLastContainerScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (int_1 == 258) {
            boolean boolean_1;
            boolean bl = boolean_1 = !RecipeViewingScreen.hasShiftDown();
            if (!this.changeFocus(boolean_1)) {
                this.changeFocus(boolean_1);
            }
            return true;
        }
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.keyPressed(int_1, int_2, int_3);
        }
        if (ClientHelper.getInstance().getNextPageKeyBinding().method_1417(int_1, int_2)) {
            if (this.recipeNext.enabled) {
                this.recipeNext.onPressed();
            }
            return this.recipeNext.enabled;
        }
        if (ClientHelper.getInstance().getPreviousPageKeyBinding().method_1417(int_1, int_2)) {
            if (this.recipeBack.enabled) {
                this.recipeBack.onPressed();
            }
            return this.recipeBack.enabled;
        }
        for (class_364 element : this.children()) {
            if (!element.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        if (int_1 == 259) {
            if (ScreenHelper.hasLastRecipeScreen()) {
                this.minecraft.method_1507(ScreenHelper.getLastRecipeScreen());
            } else {
                this.minecraft.method_1507(ScreenHelper.getLastContainerScreen());
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        this.children.clear();
        this.tabs.clear();
        this.preWidgets.clear();
        this.widgets.clear();
        this.largestWidth = this.width - 100;
        this.largestHeight = this.height - 40;
        int maxWidthDisplay = CollectionUtils.mapAndMax(this.getCurrentDisplayed(), display -> this.selectedCategory.getDisplayWidth((RecipeDisplay)display), Comparator.naturalOrder()).orElse(150);
        this.guiWidth = class_3532.method_15340((int)(maxWidthDisplay + 30), (int)0, (int)this.largestWidth);
        this.guiHeight = class_3532.method_15357((double)class_3532.method_15350((double)(((double)this.selectedCategory.getDisplayHeight() + 7.0) * ((double)this.getRecipesPerPage() + 1.0) + 40.0), (double)186.0, (double)this.largestHeight));
        this.bounds = new Rectangle(this.width / 2 - this.guiWidth / 2, this.height / 2 - this.guiHeight / 2, this.guiWidth, this.guiHeight);
        this.page = class_3532.method_15340((int)this.page, (int)0, (int)(this.getTotalPages(this.selectedCategory) - 1));
        ButtonWidget w = new ButtonWidget(this.bounds.x + 2, this.bounds.y - 16, 10, 10, (class_2561)new class_2588("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                --RecipeViewingScreen.this.categoryPages;
                if (RecipeViewingScreen.this.categoryPages < 0) {
                    RecipeViewingScreen.this.categoryPages = class_3532.method_15386((float)((float)RecipeViewingScreen.this.categories.size() / 5.0f)) - 1;
                }
                RecipeViewingScreen.this.init();
            }
        };
        this.widgets.add(w);
        ButtonWidget w2 = new ButtonWidget(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10, (class_2561)new class_2588("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                ++RecipeViewingScreen.this.categoryPages;
                if (RecipeViewingScreen.this.categoryPages > class_3532.method_15386((float)((float)RecipeViewingScreen.this.categories.size() / 5.0f)) - 1) {
                    RecipeViewingScreen.this.categoryPages = 0;
                }
                RecipeViewingScreen.this.init();
            }
        };
        this.widgets.add(w2);
        w2.enabled = this.categories.size() > 5;
        w.enabled = w2.enabled;
        this.categoryBack = new ButtonWidget(this.bounds.getX() + 5, this.bounds.getY() + 5, 12, 12, (class_2561)new class_2588("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                int currentCategoryIndex = RecipeViewingScreen.this.categories.indexOf(RecipeViewingScreen.this.selectedCategory);
                if (--currentCategoryIndex < 0) {
                    currentCategoryIndex = RecipeViewingScreen.this.categories.size() - 1;
                }
                RecipeViewingScreen.this.selectedCategory = (RecipeCategory)RecipeViewingScreen.this.categories.get(currentCategoryIndex);
                RecipeViewingScreen.this.categoryPages = class_3532.method_15357((double)((double)currentCategoryIndex / 5.0));
                RecipeViewingScreen.this.page = 0;
                RecipeViewingScreen.this.init();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.previous_category", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.categoryBack);
        this.widgets.add(new ClickableLabelWidget(this.bounds.getCenterX(), this.bounds.getY() + 7, ""){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                this.text = RecipeViewingScreen.this.selectedCategory.getCategoryName();
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.view_all_categories", (Object[])new Object[0]));
            }

            @Override
            public void onLabelClicked() {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                ClientHelper.getInstance().executeViewAllRecipesKeyBind();
            }
        });
        this.categoryNext = new ButtonWidget(this.bounds.getMaxX() - 17, this.bounds.getY() + 5, 12, 12, (class_2561)new class_2588("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                int currentCategoryIndex = RecipeViewingScreen.this.categories.indexOf(RecipeViewingScreen.this.selectedCategory);
                if (++currentCategoryIndex >= RecipeViewingScreen.this.categories.size()) {
                    currentCategoryIndex = 0;
                }
                RecipeViewingScreen.this.selectedCategory = (RecipeCategory)RecipeViewingScreen.this.categories.get(currentCategoryIndex);
                RecipeViewingScreen.this.categoryPages = class_3532.method_15357((double)((double)currentCategoryIndex / 5.0));
                RecipeViewingScreen.this.page = 0;
                RecipeViewingScreen.this.init();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.next_category", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.categoryNext);
        this.categoryBack.enabled = this.categories.size() > 1;
        this.categoryNext.enabled = this.categories.size() > 1;
        this.recipeBack = new ButtonWidget(this.bounds.getX() + 5, this.bounds.getY() + 21, 12, 12, (class_2561)new class_2588("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                --RecipeViewingScreen.this.page;
                if (RecipeViewingScreen.this.page < 0) {
                    RecipeViewingScreen.this.page = RecipeViewingScreen.this.getTotalPages(RecipeViewingScreen.this.selectedCategory) - 1;
                }
                RecipeViewingScreen.this.init();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.previous_page", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.recipeBack);
        this.widgets.add(new ClickableLabelWidget(this.bounds.getCenterX(), this.bounds.getY() + 23, "", this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPageByHeight()){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                this.text = String.format("%d/%d", RecipeViewingScreen.this.page + 1, RecipeViewingScreen.this.getTotalPages(RecipeViewingScreen.this.selectedCategory));
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.choose_page", (Object[])new Object[0]));
            }

            @Override
            public void onLabelClicked() {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                RecipeViewingScreen.this.choosePageActivated = true;
                RecipeViewingScreen.this.init();
            }
        });
        this.recipeNext = new ButtonWidget(this.bounds.getMaxX() - 17, this.bounds.getY() + 21, 12, 12, (class_2561)new class_2588("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                ++RecipeViewingScreen.this.page;
                if (RecipeViewingScreen.this.page >= RecipeViewingScreen.this.getTotalPages(RecipeViewingScreen.this.selectedCategory)) {
                    RecipeViewingScreen.this.page = 0;
                }
                RecipeViewingScreen.this.init();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.next_page", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.recipeNext);
        this.recipeNext.enabled = this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPageByHeight();
        this.recipeBack.enabled = this.recipeNext.enabled;
        for (int i = 0; i < 5; ++i) {
            int j = i + this.categoryPages * 5;
            if (this.categories.size() <= j) continue;
            TabWidget tab = new TabWidget(i, new Rectangle(this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.categoryPages * 5, 5) * 14 + i * 28, this.bounds.y - 28, 28, 28)){

                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.getBounds().contains(mouseX, mouseY)) {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        if (this.getId() + RecipeViewingScreen.this.categoryPages * 5 == RecipeViewingScreen.this.categories.indexOf(RecipeViewingScreen.this.selectedCategory)) {
                            return false;
                        }
                        RecipeViewingScreen.this.selectedCategory = (RecipeCategory)RecipeViewingScreen.this.categories.get(this.getId() + RecipeViewingScreen.this.categoryPages * 5);
                        RecipeViewingScreen.this.page = 0;
                        RecipeViewingScreen.this.init();
                        return true;
                    }
                    return false;
                }
            };
            this.tabs.add(tab);
            tab.setRenderer(this.categories.get(j), this.categories.get(j).getLogo(), this.categories.get(j).getCategoryName(), tab.getId() + this.categoryPages * 5 == this.categories.indexOf(this.selectedCategory));
        }
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getAutoCraftButtonArea(this.selectedCategory);
        int recipeHeight = this.selectedCategory.getDisplayHeight();
        List<RecipeDisplay> currentDisplayed = this.getCurrentDisplayed();
        for (int i = 0; i < currentDisplayed.size(); ++i) {
            int finalI = i;
            Supplier<RecipeDisplay> displaySupplier = () -> (RecipeDisplay)currentDisplayed.get(finalI);
            int displayWidth = this.selectedCategory.getDisplayWidth(displaySupplier.get());
            Rectangle displayBounds = new Rectangle(this.getBounds().getCenterX() - displayWidth / 2, this.getBounds().y + 40 + recipeHeight * i + 7 * i, displayWidth, recipeHeight);
            List<Widget> setupDisplay = this.selectedCategory.setupDisplay(displaySupplier, displayBounds);
            this.widgets.addAll(setupDisplay);
            if (!supplier.isPresent() || supplier.get().get(displayBounds) == null) continue;
            this.widgets.add(new AutoCraftingButtonWidget(displayBounds, supplier.get().get(displayBounds), supplier.get().getButtonText(), displaySupplier, setupDisplay, this.selectedCategory));
        }
        this.recipeChoosePageWidget = this.choosePageActivated ? new RecipeChoosePageWidget(this, this.page, this.getTotalPages(this.selectedCategory)) : null;
        List<List<EntryStack>> workingStations = RoughlyEnoughItemsCore.getRecipeHelper().getWorkingStations(this.selectedCategory.getIdentifier());
        if (!workingStations.isEmpty()) {
            int hh = class_3532.method_15375((float)((float)(this.bounds.height - 16) / 18.0f));
            int actualHeight = Math.min(hh, workingStations.size());
            int innerWidth = class_3532.method_15386((float)((float)workingStations.size() / (float)hh));
            int xx = this.bounds.x - (10 + innerWidth * 18) + 6;
            int yy = this.bounds.y + 16;
            this.preWidgets.add(new CategoryBaseWidget(new Rectangle(xx - 6, yy - 6, 15 + innerWidth * 18, 11 + actualHeight * 18)));
            int index = 0;
            List<String> list = Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662((String)"text.rei.working_station", (Object[])new Object[0]));
            xx += (innerWidth - 1) * 18;
            for (List<EntryStack> workingStation : workingStations) {
                this.preWidgets.add(EntryWidget.create(xx, yy).entries(CollectionUtils.map(workingStation, stack -> stack.copy().setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> list))));
                yy += 18;
                if (++index < hh) continue;
                index = 0;
                yy = this.bounds.y + 16;
                xx -= 18;
            }
        }
        this.children.addAll(this.tabs);
        this.children.add(ScreenHelper.getLastOverlay(true, false));
        this.children.addAll(this.widgets);
        this.children.addAll(this.preWidgets);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public List<RecipeDisplay> getCurrentDisplayed() {
        ArrayList list = Lists.newArrayList();
        int recipesPerPage = this.getRecipesPerPage();
        for (int i = 0; i <= recipesPerPage; ++i) {
            if (this.page * (recipesPerPage + 1) + i >= this.categoriesMap.get(this.selectedCategory).size()) continue;
            list.add(this.categoriesMap.get(this.selectedCategory).get(this.page * (recipesPerPage + 1) + i));
        }
        return list;
    }

    public RecipeCategory<?> getSelectedCategory() {
        return this.selectedCategory;
    }

    public int getPage() {
        return this.page;
    }

    public int getCategoryPage() {
        return this.categoryPages;
    }

    private int getRecipesPerPage() {
        if (this.selectedCategory.getFixedRecipesPerPage() > 0) {
            return this.selectedCategory.getFixedRecipesPerPage() - 1;
        }
        int height = this.selectedCategory.getDisplayHeight();
        return class_3532.method_15340((int)(class_3532.method_15357((double)(((double)this.largestHeight - 40.0) / ((double)height + 7.0))) - 1), (int)0, (int)Math.min(RoughlyEnoughItemsCore.getConfigManager().getConfig().getMaxRecipePerPage() - 1, this.selectedCategory.getMaximumRecipePerPage() - 1));
    }

    private int getRecipesPerPageByHeight() {
        int height = this.selectedCategory.getDisplayHeight();
        return class_3532.method_15340((int)class_3532.method_15357((double)(((double)this.guiHeight - 40.0) / ((double)height + 7.0))), (int)0, (int)Math.min(RoughlyEnoughItemsCore.getConfigManager().getConfig().getMaxRecipePerPage() - 1, this.selectedCategory.getMaximumRecipePerPage() - 1));
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        this.preWidgets.forEach(widget -> {
            class_308.method_1450();
            widget.render(mouseX, mouseY, delta);
        });
        if (this.selectedCategory != null) {
            this.selectedCategory.drawCategoryBackground(this.bounds, mouseX, mouseY, delta);
        } else {
            new CategoryBaseWidget(this.bounds).render();
            if (ScreenHelper.isDarkModeEnabled()) {
                RecipeViewingScreen.fill((int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-12566464);
                RecipeViewingScreen.fill((int)(this.bounds.x + 17), (int)(this.bounds.y + 21), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 33), (int)-12566464);
            } else {
                RecipeViewingScreen.fill((int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-6381922);
                RecipeViewingScreen.fill((int)(this.bounds.x + 17), (int)(this.bounds.y + 21), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 33), (int)-6381922);
            }
        }
        for (TabWidget tab : this.tabs) {
            if (tab.isSelected()) continue;
            tab.render(mouseX, mouseY, delta);
        }
        class_308.method_1450();
        super.render(mouseX, mouseY, delta);
        this.widgets.forEach(widget -> {
            class_308.method_1450();
            widget.render(mouseX, mouseY, delta);
        });
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_308.method_1450();
        for (TabWidget tab : this.tabs) {
            if (!tab.isSelected()) continue;
            tab.render(mouseX, mouseY, delta);
        }
        class_308.method_1450();
        ScreenHelper.getLastOverlay().render(mouseX, mouseY, delta);
        ScreenHelper.getLastOverlay().lateRender(mouseX, mouseY, delta);
        if (this.choosePageActivated) {
            this.setBlitOffset(500);
            this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
            this.setBlitOffset(0);
            this.recipeChoosePageWidget.render(mouseX, mouseY, delta);
        }
    }

    public int getTotalPages(RecipeCategory category) {
        return class_3532.method_15384((double)((double)this.categoriesMap.get(category).size() / (double)(this.getRecipesPerPage() + 1)));
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean charTyped(char char_1, int int_1) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.charTyped(char_1, int_1);
        }
        for (class_364 listener : this.children()) {
            if (!listener.charTyped(char_1, int_1)) continue;
            return true;
        }
        return super.charTyped(char_1, int_1);
    }

    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.mouseDragged(double_1, double_2, int_1, double_3, double_4);
        }
        return super.mouseDragged(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean mouseReleased(double double_1, double double_2, int int_1) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.mouseReleased(double_1, double_2, int_1);
        }
        return super.mouseReleased(double_1, double_2, int_1);
    }

    public boolean mouseScrolled(double i, double j, double amount) {
        for (class_364 listener : this.children()) {
            if (!listener.mouseScrolled(i, j, amount)) continue;
            return true;
        }
        if (this.getBounds().contains(PointHelper.fromMouse())) {
            if (amount > 0.0 && this.recipeBack.enabled) {
                this.recipeBack.onPressed();
            } else if (amount < 0.0 && this.recipeNext.enabled) {
                this.recipeNext.onPressed();
            }
        }
        if (new Rectangle(this.bounds.x, this.bounds.y - 28, this.bounds.width, 28).contains(PointHelper.fromMouse())) {
            if (amount > 0.0 && this.categoryBack.enabled) {
                this.categoryBack.onPressed();
            } else if (amount < 0.0 && this.categoryNext.enabled) {
                this.categoryNext.onPressed();
            }
        }
        return super.mouseScrolled(i, j, amount);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.choosePageActivated) {
            if (this.recipeChoosePageWidget.containsMouse(double_1, double_2)) {
                return this.recipeChoosePageWidget.mouseClicked(double_1, double_2, int_1);
            }
            this.choosePageActivated = false;
            this.init();
            return false;
        }
        for (class_364 entry : this.children()) {
            if (!entry.mouseClicked(double_1, double_2, int_1)) continue;
            this.setFocused(entry);
            if (int_1 == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public class_364 getFocused() {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget;
        }
        return super.getFocused();
    }
}

