/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.TransferRecipeCategory;
import me.shedaniel.rei.gui.toast.CopyRecipeIdentifierToast;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_465;

public class AutoCraftingButtonWidget
extends ButtonWidget {
    private final Supplier<RecipeDisplay> displaySupplier;
    private String extraTooltip;
    private List<String> errorTooltip;
    private List<Widget> setupDisplay;
    private class_465<?> containerScreen;
    private boolean visible = false;
    private RecipeCategory<?> category;
    private Rectangle displayBounds;

    public AutoCraftingButtonWidget(Rectangle displayBounds, Rectangle rectangle, String text, Supplier<RecipeDisplay> displaySupplier, List<Widget> setupDisplay, RecipeCategory<?> recipeCategory) {
        super(rectangle, text);
        this.displayBounds = displayBounds;
        this.displaySupplier = () -> (RecipeDisplay)displaySupplier.get();
        Optional<class_2960> recipe = displaySupplier.get().getRecipeLocation();
        this.extraTooltip = recipe.isPresent() ? class_1074.method_4662((String)"text.rei.recipe_id", (Object[])new Object[]{class_124.field_1080.toString(), recipe.get().toString()}) : "";
        this.containerScreen = ScreenHelper.getLastContainerScreen();
        this.setupDisplay = setupDisplay;
        this.category = recipeCategory;
    }

    @Override
    public void onPressed() {
        AutoTransferHandler.Context context = AutoTransferHandler.Context.create(true, this.containerScreen, this.displaySupplier.get());
        for (AutoTransferHandler autoTransferHandler : RecipeHelper.getInstance().getSortedAutoCraftingHandler()) {
            try {
                AutoTransferHandler.Result result = autoTransferHandler.handle(context);
                if (!result.isSuccessful()) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.minecraft.method_1507(this.containerScreen);
        ScreenHelper.getLastOverlay().init();
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        this.enabled = false;
        ArrayList error = null;
        int color = 0;
        this.visible = false;
        IntList redSlots = null;
        AutoTransferHandler.Context context = AutoTransferHandler.Context.create(false, this.containerScreen, this.displaySupplier.get());
        for (AutoTransferHandler autoTransferHandler : RecipeHelper.getInstance().getSortedAutoCraftingHandler()) {
            try {
                AutoTransferHandler.Result result = autoTransferHandler.handle(context);
                if (result.isApplicable()) {
                    this.visible = true;
                }
                if (result.isSuccessful()) {
                    this.enabled = true;
                    error = null;
                    color = 0;
                    redSlots = null;
                    break;
                }
                if (!result.isApplicable()) continue;
                if (error == null) {
                    error = Lists.newArrayList();
                }
                error.add(result.getErrorKey());
                color = result.getColor();
                redSlots = result.getIntegers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.visible) {
            this.enabled = false;
            if (error == null) {
                error = Lists.newArrayList();
            } else {
                error.clear();
            }
            error.add("error.rei.no.handlers.applicable");
        }
        if (this.isHovered(mouseX, mouseY) && this.category instanceof TransferRecipeCategory && redSlots != null) {
            ((TransferRecipeCategory)this.category).renderRedSlots(this.setupDisplay, this.displayBounds, this.displaySupplier.get(), redSlots);
        }
        List<Object> list = this.errorTooltip = error == null || error.isEmpty() ? null : Lists.newArrayList();
        if (this.errorTooltip != null) {
            for (String s : error) {
                if (this.errorTooltip.stream().anyMatch(ss -> ss.equalsIgnoreCase(s))) continue;
                this.errorTooltip.add(s);
            }
        }
        int x = this.getBounds().x;
        int y = this.getBounds().y;
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        this.minecraft.method_1531().method_22813(ScreenHelper.isDarkModeEnabled() ? BUTTON_LOCATION_DARK : BUTTON_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textureOffset = this.getTextureId(this.isHovered(mouseX, mouseY));
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        this.blit(x, y, 0, textureOffset * 80, 4, 4);
        this.blit(x + width - 4, y, 252, textureOffset * 80, 4, 4);
        this.blit(x, y + height - 4, 0, textureOffset * 80 + 76, 4, 4);
        this.blit(x + width - 4, y + height - 4, 252, textureOffset * 80 + 76, 4, 4);
        this.blit(x + 4, y, 4, textureOffset * 80, class_3532.method_15386((float)((float)(width - 8) / 2.0f)), 4);
        this.blit(x + 4, y + height - 4, 4, textureOffset * 80 + 76, class_3532.method_15386((float)((float)(width - 8) / 2.0f)), 4);
        this.blit(x + 4 + class_3532.method_15386((float)((float)(width - 8) / 2.0f)), y + height - 4, 252 - class_3532.method_15375((float)((float)(width - 8) / 2.0f)), textureOffset * 80 + 76, class_3532.method_15375((float)((float)(width - 8) / 2.0f)), 4);
        this.blit(x + 4 + class_3532.method_15386((float)((float)(width - 8) / 2.0f)), y, 252 - class_3532.method_15375((float)((float)(width - 8) / 2.0f)), textureOffset * 80, class_3532.method_15375((float)((float)(width - 8) / 2.0f)), 4);
        for (int i = y + 4; i < y + height - 4; i += 76) {
            this.blit(x, i, 0, 4 + textureOffset * 80, class_3532.method_15386((float)((float)width / 2.0f)), class_3532.method_15340((int)(y + height - 4 - i), (int)0, (int)76));
            this.blit(x + class_3532.method_15386((float)((float)width / 2.0f)), i, 256 - class_3532.method_15375((float)((float)width / 2.0f)), 4 + textureOffset * 80, class_3532.method_15375((float)((float)width / 2.0f)), class_3532.method_15340((int)(y + height - 4 - i), (int)0, (int)76));
        }
        int colour = 0xE0E0E0;
        if (!this.visible) {
            colour = 0xA0A0A0;
        } else if (this.enabled && this.isHovered(mouseX, mouseY)) {
            colour = 0xFFFFA0;
        }
        this.fillGradient(x, y, x + width, y + height, color, color);
        this.drawCenteredString(this.font, this.text, x + width / 2, y + (height - 8) / 2, colour);
        if (this.getTooltips().isPresent()) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltips().get().split("\n")));
            } else if (this.focused) {
                ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(new Point(x + width / 2, y + height / 2), this.getTooltips().get().split("\n")));
            }
        }
    }

    @Override
    protected int getTextureId(boolean boolean_1) {
        return !this.visible ? 0 : (boolean_1 && this.enabled ? 2 : 1);
    }

    @Override
    public Optional<String> getTooltips() {
        String str = "";
        if (this.errorTooltip == null) {
            str = str + class_1074.method_4662((String)"text.auto_craft.move_items", (Object[])new Object[0]);
        } else {
            if (this.errorTooltip.size() > 1) {
                str = str + class_124.field_1061.toString() + class_1074.method_4662((String)"error.rei.multi.errors", (Object[])new Object[0]) + "\n";
            }
            str = str + this.errorTooltip.stream().map(s -> class_124.field_1061.toString() + (this.errorTooltip.size() > 1 ? "- " : "") + class_1074.method_4662((String)s, (Object[])new Object[0])).collect(Collectors.joining("\n"));
        }
        if (this.minecraft.field_1690.field_1827) {
            str = str + this.extraTooltip;
        }
        return Optional.of(str);
    }

    @Override
    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.displaySupplier.get().getRecipeLocation().isPresent() && ClientHelper.getInstance().getCopyRecipeIdentifierKeyBinding().method_1417(int_1, int_2) && this.containsMouse(PointHelper.fromMouse())) {
            this.minecraft.field_1774.method_1455(this.displaySupplier.get().getRecipeLocation().get().toString());
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().isToastDisplayedOnCopyIdentifier()) {
                CopyRecipeIdentifierToast.addToast(class_1074.method_4662((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), class_1074.method_4662((String)"msg.rei.recipe_id_details", (Object[])new Object[]{this.displaySupplier.get().getRecipeLocation().get().toString()}));
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }
}

