/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.annotations.Internal;
import net.minecraft.class_1269;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

@Deprecated
@Internal
public class BaseBoundsHandlerImpl implements BaseBoundsHandler {
    
    private static final Comparator<? super Rectangle> RECTANGLE_COMPARER = Comparator.comparingLong(Rectangle::hashCode);
    
    private long lastArea = -1;
    private List<class_3545<class_3545<Class<?>, Float>, Function<Boolean, List<Rectangle>>>> list = Lists.newArrayList();
    
    @Override
    public Class<?> getBaseSupportedClass() {
        return class_437.class;
    }
    
    @Override
    public Rectangle getLeftBounds(class_437 screen) {
        return new Rectangle();
    }
    
    @Override
    public Rectangle getRightBounds(class_437 screen) {
        return new Rectangle();
    }
    
    @Override
    public float getPriority() {
        return -5f;
    }
    
    @Override
    public class_1269 isInZone(boolean isOnRightSide, double mouseX, double mouseY) {
        for (Rectangle zone : getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide, false))
            if (zone.contains(mouseX, mouseY))
                return class_1269.field_5814;
        return class_1269.field_5811;
    }
    
    @Override
    public boolean shouldRecalculateArea(boolean isOnRightSide, Rectangle rectangle) {
        long current = currentHashCode(isOnRightSide);
        if (lastArea == current)
            return false;
        lastArea = current;
        return true;
    }
    
    private long currentHashCode(boolean isOnRightSide) {
        DisplayHelper.DisplayBoundsHandler handler = DisplayHelper.getInstance().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
        return areasHashCode(isOnRightSide ? handler.getRightBounds(class_310.method_1551().field_1755) : handler.getLeftBounds(class_310.method_1551().field_1755), getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide, false));
    }
    
    @Override
    public class_1269 canItemSlotWidgetFit(boolean isOnRightSide, int left, int top, class_437 screen, Rectangle fullBounds) {
        for (Rectangle currentExclusionZone : getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide, false))
            if (left + 18 >= currentExclusionZone.x && top + 18 >= currentExclusionZone.y && left <= currentExclusionZone.x + currentExclusionZone.width && top <= currentExclusionZone.y + currentExclusionZone.height)
                return class_1269.field_5814;
        return class_1269.field_5811;
    }
    
    @Override
    public List<Rectangle> getCurrentExclusionZones(Class<?> currentScreenClass, boolean isOnRightSide, boolean sort) {
        List<Rectangle> rectangles = Lists.newArrayList();
        for (class_3545<class_3545<Class<?>, Float>, Function<Boolean, List<Rectangle>>> pair : list) {
            if (pair.method_15442().method_15442().isAssignableFrom(currentScreenClass))
                rectangles.addAll(pair.method_15441().apply(isOnRightSide));
        }
        if (sort)
            rectangles.sort(RECTANGLE_COMPARER);
        return rectangles;
    }
    
    @Override
    public void registerExclusionZones(Class<?> screenClass, Function<Boolean, List<Rectangle>> supplier) {
        list.add(new class_3545<>(new class_3545<>(screenClass, 0f), supplier));
    }
    
    private long areasHashCode(Rectangle rectangle, List<Rectangle> exclusionZones) {
        int hashCode = 31 + (rectangle == null ? 0 : rectangle.hashCode());
        for (Rectangle e : exclusionZones)
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        // hashCode -= (e == null ? 0 : e.hashCode());
        return hashCode;
    }
    
}
