/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.widget.AutoCraftingButtonWidget;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.CategoryBaseWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.SlotBaseWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class VillagerRecipeViewingScreen
extends class_437 {
    private static final int TABS_PER_PAGE = 8;
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoryMap;
    private final List<RecipeCategory<?>> categories;
    private final List<Widget> widgets = Lists.newArrayList();
    private final List<ButtonWidget> buttonWidgets;
    private final List<RecipeEntry> recipeRenderers;
    private final List<TabWidget> tabs;
    public Rectangle bounds;
    public Rectangle scrollListBounds;
    private int selectedCategoryIndex = 0;
    private int selectedRecipeIndex = 0;
    private double scroll = 0.0;
    private double target;
    private long start;
    private long duration;
    private float scrollBarAlpha = 0.0f;
    private float scrollBarAlphaFuture = 0.0f;
    private long scrollBarAlphaFutureTime = -1L;
    private boolean draggingScrollBar = false;
    private int tabsPage = 0;

    public VillagerRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> map) {
        super((class_2561)new class_2585(""));
        this.categoryMap = Maps.newLinkedHashMap();
        this.categories = Lists.newArrayList();
        this.buttonWidgets = Lists.newArrayList();
        this.tabs = Lists.newArrayList();
        this.recipeRenderers = Lists.newArrayList();
        RecipeHelper.getInstance().getAllCategories().forEach(category -> {
            if (map.containsKey(category)) {
                this.categories.add((RecipeCategory<?>)category);
                this.categoryMap.put((RecipeCategory<?>)category, (List<RecipeDisplay>)map.get(category));
            }
        });
    }

    protected void init() {
        super.init();
        this.draggingScrollBar = false;
        this.children.clear();
        this.widgets.clear();
        this.buttonWidgets.clear();
        this.recipeRenderers.clear();
        this.tabs.clear();
        int largestWidth = this.width - 100;
        int largestHeight = this.height - 40;
        RecipeCategory<?> category = this.categories.get(this.selectedCategoryIndex);
        RecipeDisplay display = this.categoryMap.get(category).get(this.selectedRecipeIndex);
        int guiWidth = class_3532.method_15340((int)(category.getDisplayWidth(display) + 30), (int)0, (int)largestWidth) + 100;
        int guiHeight = class_3532.method_15340((int)(category.getDisplayHeight() + 40), (int)166, (int)largestHeight);
        this.bounds = new Rectangle(this.width / 2 - guiWidth / 2, this.height / 2 - guiHeight / 2, guiWidth, guiHeight);
        List<List<EntryStack>> workingStations = RecipeHelper.getInstance().getWorkingStations(category.getIdentifier());
        if (!workingStations.isEmpty()) {
            int ww = class_3532.method_15375((float)((float)(this.bounds.width - 16) / 18.0f));
            int w = Math.min(ww, workingStations.size());
            int h = class_3532.method_15386((float)((float)workingStations.size() / (float)ww));
            int xx = this.bounds.x + 16;
            int yy = this.bounds.y + this.bounds.height + 5;
            this.widgets.add(new CategoryBaseWidget(new Rectangle(xx - 6, this.bounds.y + this.bounds.height - 5, 11 + w * 18, 15 + h * 18)));
            int index = 0;
            List<String> list = Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662((String)"text.rei.working_station", (Object[])new Object[0]));
            for (List<EntryStack> workingStation : workingStations) {
                this.widgets.add(EntryWidget.create(xx, yy).entries(CollectionUtils.map(workingStation, stack -> stack.copy().setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> list))));
                xx += 18;
                if (++index < ww) continue;
                index = 0;
                xx = this.bounds.x + 16;
                yy += 18;
            }
        }
        this.widgets.add(new CategoryBaseWidget(this.bounds));
        this.scrollListBounds = new Rectangle(this.bounds.x + 4, this.bounds.y + 17, 102, guiHeight - 17 - 7);
        this.widgets.add(new SlotBaseWidget(this.scrollListBounds));
        Rectangle recipeBounds = new Rectangle(this.bounds.x + 100 + (guiWidth - 100) / 2 - category.getDisplayWidth(display) / 2, this.bounds.y + this.bounds.height / 2 - category.getDisplayHeight() / 2, category.getDisplayWidth(display), category.getDisplayHeight());
        List<Widget> setupDisplay = category.setupDisplay(() -> display, recipeBounds);
        this.widgets.addAll(setupDisplay);
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getAutoCraftButtonArea(category);
        if (supplier.isPresent() && supplier.get().get(recipeBounds) != null) {
            this.widgets.add(new AutoCraftingButtonWidget(recipeBounds, supplier.get().get(recipeBounds), supplier.get().getButtonText(), () -> display, setupDisplay, category));
        }
        int index = 0;
        for (RecipeDisplay recipeDisplay : this.categoryMap.get(category)) {
            final int finalIndex = index++;
            RecipeEntry recipeEntry = category.getSimpleRenderer(recipeDisplay);
            this.recipeRenderers.add(recipeEntry);
            this.buttonWidgets.add(new ButtonWidget(new Rectangle(this.bounds.x + 5, 0, recipeEntry.getWidth(), recipeEntry.getHeight()), ""){

                @Override
                public void onPressed() {
                    VillagerRecipeViewingScreen.this.selectedRecipeIndex = finalIndex;
                    VillagerRecipeViewingScreen.this.init();
                }

                @Override
                public boolean isHovered(int mouseX, int mouseY) {
                    return this.isMouseOver(mouseX, mouseY) && VillagerRecipeViewingScreen.this.scrollListBounds.contains(mouseX, mouseY) || this.focused;
                }

                @Override
                protected int getTextureId(boolean boolean_1) {
                    this.enabled = VillagerRecipeViewingScreen.this.selectedRecipeIndex != finalIndex;
                    return super.getTextureId(boolean_1);
                }

                @Override
                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.isMouseOver(mouseX, mouseY) && VillagerRecipeViewingScreen.this.scrollListBounds.contains(mouseX, mouseY) && this.enabled && button == 0) {
                        this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        this.onPressed();
                        return true;
                    }
                    return false;
                }
            });
        }
        for (int i = 0; i < 8; ++i) {
            int j = i + this.tabsPage * 8;
            if (this.categories.size() <= j) continue;
            TabWidget tab = new TabWidget(i, new Rectangle(this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.tabsPage * 8, 8) * 14 + i * 28, this.bounds.y - 28, 28, 28)){

                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.getBounds().contains(mouseX, mouseY)) {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        if (this.getId() + VillagerRecipeViewingScreen.this.tabsPage * 8 == VillagerRecipeViewingScreen.this.selectedCategoryIndex) {
                            return false;
                        }
                        VillagerRecipeViewingScreen.this.selectedCategoryIndex = this.getId() + VillagerRecipeViewingScreen.this.tabsPage * 8;
                        VillagerRecipeViewingScreen.this.scroll = 0.0;
                        VillagerRecipeViewingScreen.this.selectedRecipeIndex = 0;
                        VillagerRecipeViewingScreen.this.init();
                        return true;
                    }
                    return false;
                }
            };
            this.tabs.add(tab);
            tab.setRenderer(this.categories.get(j), this.categories.get(j).getLogo(), this.categories.get(j).getCategoryName(), tab.getId() + this.tabsPage * 8 == this.selectedCategoryIndex);
        }
        ButtonWidget w = new ButtonWidget(new Rectangle(this.bounds.x + 2, this.bounds.y - 16, 10, 10), (class_2561)new class_2588("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                VillagerRecipeViewingScreen.this.tabsPage--;
                if (VillagerRecipeViewingScreen.this.tabsPage < 0) {
                    VillagerRecipeViewingScreen.this.tabsPage = class_3532.method_15386((float)((float)VillagerRecipeViewingScreen.this.categories.size() / 8.0f)) - 1;
                }
                VillagerRecipeViewingScreen.this.init();
            }
        };
        this.widgets.add(w);
        ButtonWidget w2 = new ButtonWidget(new Rectangle(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10), (class_2561)new class_2588("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                VillagerRecipeViewingScreen.this.tabsPage++;
                if (VillagerRecipeViewingScreen.this.tabsPage > class_3532.method_15386((float)((float)VillagerRecipeViewingScreen.this.categories.size() / 8.0f)) - 1) {
                    VillagerRecipeViewingScreen.this.tabsPage = 0;
                }
                VillagerRecipeViewingScreen.this.init();
            }
        };
        this.widgets.add(w2);
        w2.enabled = this.categories.size() > 8;
        w.enabled = w2.enabled;
        this.widgets.add(new ClickableLabelWidget(new Point(this.bounds.x + 4 + this.scrollListBounds.width / 2, this.bounds.y + 6), this.categories.get(this.selectedCategoryIndex).getCategoryName()){

            @Override
            public void onLabelClicked() {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                ClientHelper.getInstance().executeViewAllRecipesKeyBind();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.view_all_categories", (Object[])new Object[0]));
            }
        });
        this.children.addAll(this.buttonWidgets);
        this.widgets.addAll(this.tabs);
        this.children.addAll(this.widgets);
        this.children.add(ScreenHelper.getLastOverlay(true, false));
        ScreenHelper.getLastOverlay().init();
    }

    private final double clamp(double v) {
        return this.clamp(v, 200.0);
    }

    private final double clamp(double v, double clampExtension) {
        return class_3532.method_15350((double)v, (double)(-clampExtension), (double)(this.getMaxScroll() + clampExtension));
    }

    private double getMaxScroll() {
        return Math.max(0.0, this.getMaxScrollPosition() - (double)(this.scrollListBounds.height - 2));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int int_1) {
        double scrollbarPositionMinX;
        int actualHeight;
        double height = this.getMaxScrollPosition();
        if (height > (double)(actualHeight = this.scrollListBounds.height - 2) && this.scrollBarAlpha > 0.0f && mouseY >= (double)(this.scrollListBounds.y + 1) && mouseY <= (double)(this.scrollListBounds.getMaxY() - 1) && mouseX >= (scrollbarPositionMinX = (double)(this.scrollListBounds.getMaxX() - 6)) & mouseX <= scrollbarPositionMinX + 8.0) {
            this.draggingScrollBar = true;
            this.scrollBarAlpha = 1.0f;
            return false;
        }
        this.draggingScrollBar = false;
        return super.mouseClicked(mouseX, mouseY, int_1);
    }

    public boolean charTyped(char char_1, int int_1) {
        for (class_364 listener : this.children()) {
            if (!listener.charTyped(char_1, int_1)) continue;
            return true;
        }
        return super.charTyped(char_1, int_1);
    }

    public void offset(double value, boolean animated) {
        this.scrollTo(this.target + value, animated);
    }

    public void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public void scrollTo(double value, boolean animated, long duration) {
        this.target = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scroll = this.target;
        }
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        double height = CollectionUtils.sumInt(this.buttonWidgets, b -> b.getBounds().getHeight());
        if (this.scrollListBounds.contains(double_1, double_2) && height > (double)(this.scrollListBounds.height - 2)) {
            this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlphaFuture = 1.0f;
            }
            if ((float)(System.currentTimeMillis() - this.scrollBarAlphaFutureTime) > 300.0f) {
                this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            }
            return true;
        }
        for (class_364 listener : this.children()) {
            if (!listener.mouseScrolled(double_1, double_2, double_3)) continue;
            return true;
        }
        if (this.bounds.contains(PointHelper.fromMouse())) {
            if (double_3 < 0.0 && this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.init();
            } else if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.init();
                return true;
            }
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    private double getMaxScrollPosition() {
        return CollectionUtils.sumInt(this.buttonWidgets, b -> b.getBounds().getHeight());
    }

    public void render(int mouseX, int mouseY, float delta) {
        int i;
        if (ConfigManager.getInstance().getConfig().doesVillagerScreenHavePermanentScrollBar()) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 0.0f;
            this.scrollBarAlpha = 1.0f;
        } else if (this.scrollBarAlphaFutureTime > 0L) {
            long l = System.currentTimeMillis() - this.scrollBarAlphaFutureTime;
            if ((float)l > 300.0f) {
                if (this.scrollBarAlphaFutureTime == 0L) {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                    this.scrollBarAlphaFutureTime = -1L;
                } else if ((float)l > 2000.0f && this.scrollBarAlphaFuture == 1.0f) {
                    this.scrollBarAlphaFuture = 0.0f;
                    this.scrollBarAlphaFutureTime = System.currentTimeMillis();
                } else {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                }
            } else if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlpha = Math.min(this.scrollBarAlpha, 1.0f - Math.min(1.0f, (float)l / 300.0f));
            } else if (this.scrollBarAlphaFuture == 1.0f) {
                this.scrollBarAlpha = Math.max(Math.min(1.0f, (float)l / 300.0f), this.scrollBarAlpha);
            }
        }
        this.updatePosition(delta);
        this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        int yOffset = 0;
        this.widgets.forEach(widget -> {
            class_308.method_1450();
            widget.render(mouseX, mouseY, delta);
        });
        class_308.method_1450();
        ScreenHelper.getLastOverlay().render(mouseX, mouseY, delta);
        RenderSystem.pushMatrix();
        ScissorsHandler.INSTANCE.scissor(new Rectangle(0, this.scrollListBounds.y + 1, this.width, this.scrollListBounds.height - 2));
        for (i = 0; i < this.buttonWidgets.size(); ++i) {
            ButtonWidget buttonWidget = this.buttonWidgets.get(i);
            buttonWidget.getBounds().y = this.scrollListBounds.y + 1 + yOffset - (int)this.scroll;
            if (buttonWidget.getBounds().getMaxY() > this.scrollListBounds.getMinY() && buttonWidget.getBounds().getMinY() < this.scrollListBounds.getMaxY()) {
                class_308.method_1450();
                buttonWidget.render(mouseX, mouseY, delta);
            }
            yOffset += buttonWidget.getBounds().height;
        }
        for (i = 0; i < this.buttonWidgets.size(); ++i) {
            if (this.buttonWidgets.get(i).getBounds().getMaxY() <= this.scrollListBounds.getMinY() || this.buttonWidgets.get(i).getBounds().getMinY() >= this.scrollListBounds.getMaxY()) continue;
            class_308.method_1450();
            this.recipeRenderers.get(i).setZ(1);
            this.recipeRenderers.get(i).render(this.buttonWidgets.get(i).getBounds(), mouseX, mouseY, delta);
            ScreenHelper.getLastOverlay().addTooltip(this.recipeRenderers.get(i).getTooltip(mouseX, mouseY));
        }
        double maxScroll = this.getMaxScrollPosition();
        if (maxScroll > (double)(this.scrollListBounds.height - 2)) {
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            int height = (int)((double)((this.scrollListBounds.height - 2) * (this.scrollListBounds.height - 2)) / this.getMaxScrollPosition());
            height = class_3532.method_15340((int)height, (int)32, (int)(this.scrollListBounds.height - 2 - 8));
            height = (int)((double)height - Math.min(this.scroll < 0.0 ? (double)((int)(-this.scroll)) : (this.scroll > this.getMaxScroll() ? (double)((int)this.scroll) - this.getMaxScroll() : 0.0), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = (int)Math.min(Math.max((double)((int)this.scroll * (this.scrollListBounds.height - 2 - height)) / this.getMaxScroll() + (double)this.scrollListBounds.y + 1.0, (double)(this.scrollListBounds.y + 1)), (double)(this.scrollListBounds.getMaxY() - 1 - height));
            int scrollbarPositionMinX = this.scrollListBounds.getMaxX() - 6;
            int scrollbarPositionMaxX = this.scrollListBounds.getMaxX() - 1;
            boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse());
            float bottomC = (hovered ? 0.67f : 0.5f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
            float topC = (hovered ? 0.87f : 0.67f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
            class_308.method_1450();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.shadeModel((int)7425);
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height), 800.0).method_22915(bottomC, bottomC, bottomC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + height), 800.0).method_22915(bottomC, bottomC, bottomC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 800.0).method_22915(bottomC, bottomC, bottomC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 800.0).method_22915(bottomC, bottomC, bottomC, this.scrollBarAlpha).method_1344();
            tessellator.method_1350();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height - 1), 800.0).method_22915(topC, topC, topC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 800.0).method_22915(topC, topC, topC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 800.0).method_22915(topC, topC, topC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 800.0).method_22915(topC, topC, topC, this.scrollBarAlpha).method_1344();
            tessellator.method_1350();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        RenderSystem.popMatrix();
        ScreenHelper.getLastOverlay().lateRender(mouseX, mouseY, delta);
    }

    private void updatePosition(float delta) {
        this.target = this.clamp(this.target);
        if (this.target < 0.0) {
            this.target -= this.target * (1.0 - ClothConfigInitializer.getBounceBackMultiplier()) * (double)delta / 3.0;
        } else if (this.target > this.getMaxScroll()) {
            this.target = (this.target - this.getMaxScroll()) * (1.0 - (1.0 - ClothConfigInitializer.getBounceBackMultiplier()) * (double)delta / 3.0) + this.getMaxScroll();
        }
        this.scroll = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scroll, (double)this.target, (double)0.001f) ? (double)((float)DynamicNewSmoothScrollingEntryListWidget.Interpolation.expoEase((double)this.scroll, (double)this.target, (double)Math.min((double)(System.currentTimeMillis() - this.start) / (double)this.duration, 1.0))) : this.target;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        int actualHeight;
        double height;
        if (int_1 == 0 && this.scrollBarAlpha > 0.0f && this.draggingScrollBar && (height = (double)CollectionUtils.sumInt(this.buttonWidgets, b -> b.getBounds().getHeight())) > (double)(actualHeight = this.scrollListBounds.height - 2) && mouseY >= (double)(this.scrollListBounds.y + 1) && mouseY <= (double)(this.scrollListBounds.getMaxY() - 1)) {
            int int_3 = class_3532.method_15340((int)((int)((double)(actualHeight * actualHeight) / height)), (int)32, (int)(actualHeight - 8));
            double double_6 = Math.max(1.0, Math.max(1.0, height) / (double)(actualHeight - int_3));
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 1.0f;
            this.scroll = this.target = class_3532.method_15350((double)(this.scroll + double_4 * double_6), (double)0.0, (double)(height - (double)this.scrollListBounds.height + 2.0));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if ((int_1 == 256 || this.minecraft.field_1690.field_1822.method_1417(int_1, int_2)) && this.shouldCloseOnEsc()) {
            class_310.method_1551().method_1507(ScreenHelper.getLastContainerScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (int_1 == 258) {
            boolean boolean_1;
            boolean bl = boolean_1 = !VillagerRecipeViewingScreen.hasShiftDown();
            if (!this.changeFocus(boolean_1)) {
                this.changeFocus(boolean_1);
            }
            return true;
        }
        if (ClientHelper.getInstance().getNextPageKeyBinding().method_1417(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.init();
                return true;
            }
            return false;
        }
        if (ClientHelper.getInstance().getPreviousPageKeyBinding().method_1417(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.init();
                return true;
            }
            return false;
        }
        for (class_364 element : this.children()) {
            if (!element.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        if (int_1 == 259) {
            if (ScreenHelper.hasLastRecipeScreen()) {
                this.minecraft.method_1507(ScreenHelper.getLastRecipeScreen());
            } else {
                this.minecraft.method_1507(ScreenHelper.getLastContainerScreen());
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }
}

