/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.entries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;

public class SimpleRecipeEntry
extends RecipeEntry {
    private static final Comparator<EntryStack> ENTRY_COMPARATOR = Comparator.comparingLong(Object::hashCode);
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private List<EntryWidget> inputWidgets;
    private EntryWidget outputWidget;

    protected SimpleRecipeEntry(List<List<EntryStack>> input, List<EntryStack> output) {
        ArrayList newList = Lists.newArrayList();
        List a = input.stream().map(stacks -> new class_3545(stacks, (Object)stacks.stream().map(EntryStack::getAmount).max(Integer::compareTo).orElse(1))).collect(Collectors.toList());
        for (class_3545 pair : a) {
            Optional<class_3545> any = newList.stream().filter(pairr -> SimpleRecipeEntry.equalsList((List)pair.method_15442(), (List)pairr.method_15442())).findAny();
            if (any.isPresent()) {
                ((AtomicInteger)any.get().method_15441()).addAndGet((Integer)pair.method_15441());
                continue;
            }
            newList.add(new class_3545(pair.method_15442(), (Object)new AtomicInteger((Integer)pair.method_15441())));
        }
        ArrayList b = Lists.newArrayList();
        for (class_3545 pair : newList) {
            b.add(((List)pair.method_15442()).stream().map(stack -> {
                EntryStack s = stack.copy();
                s.setAmount(((AtomicInteger)pair.method_15441()).get());
                return s;
            }).collect(Collectors.toList()));
        }
        this.inputWidgets = b.stream().filter(stacks -> !stacks.isEmpty()).map(stacks -> EntryWidget.create(0, 0).entries((Collection<EntryStack>)stacks).noBackground().noHighlight().noTooltips()).collect(Collectors.toList());
        this.outputWidget = EntryWidget.create(0, 0).entries(CollectionUtils.filter(output, stack -> !stack.isEmpty())).noBackground().noHighlight().noTooltips();
    }

    public static RecipeEntry create(Supplier<List<List<EntryStack>>> input, Supplier<List<EntryStack>> output) {
        return SimpleRecipeEntry.create(input.get(), output.get());
    }

    public static RecipeEntry create(List<List<EntryStack>> input, List<EntryStack> output) {
        return new SimpleRecipeEntry(input, output);
    }

    public static boolean equalsList(List<EntryStack> list_1, List<EntryStack> list_2) {
        List stacks_2;
        List stacks_1 = list_1.stream().distinct().sorted(ENTRY_COMPARATOR).collect(Collectors.toList());
        if (stacks_1.equals(stacks_2 = list_2.stream().distinct().sorted(ENTRY_COMPARATOR).collect(Collectors.toList()))) {
            return true;
        }
        if (stacks_1.size() != stacks_2.size()) {
            return false;
        }
        for (int i = 0; i < stacks_1.size(); ++i) {
            if (((EntryStack)stacks_1.get(i)).equalsIgnoreTagsAndAmount((EntryStack)stacks_2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void render(Rectangle bounds, int mouseX, int mouseY, float delta) {
        int xx = bounds.x + 4;
        int yy = bounds.y + 2;
        int j = 0;
        int itemsPerLine = this.getItemsPerLine();
        for (EntryWidget entryWidget : this.inputWidgets) {
            entryWidget.setZ(this.getZ() + 50);
            entryWidget.getBounds().setLocation(xx, yy);
            entryWidget.render(mouseX, mouseY, delta);
            xx += 18;
            if (++j < this.getItemsPerLine() - 2) continue;
            yy += 18;
            xx = bounds.x + 4;
            j = 0;
        }
        xx = bounds.x + 4 + 18 * (this.getItemsPerLine() - 2);
        yy = bounds.y + this.getHeight() / 2 - 8;
        class_308.method_1450();
        class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
        this.blit(xx, yy, 0, 28, 18, 18);
        this.outputWidget.setZ(this.getZ() + 50);
        this.outputWidget.getBounds().setLocation(xx += 18, yy);
        this.outputWidget.render(mouseX, mouseY, delta);
    }

    @Override
    @Nullable
    public QueuedTooltip getTooltip(int mouseX, int mouseY) {
        for (EntryWidget widget : this.inputWidgets) {
            if (!widget.containsMouse(mouseX, mouseY)) continue;
            return widget.getCurrentTooltip(mouseX, mouseY);
        }
        if (this.outputWidget.containsMouse(mouseX, mouseY)) {
            return this.outputWidget.getCurrentTooltip(mouseX, mouseY);
        }
        return null;
    }

    @Override
    public int getHeight() {
        return 4 + this.getItemsHeight() * 18;
    }

    public int getItemsHeight() {
        return class_3532.method_15386((float)((float)this.inputWidgets.size() / (float)(this.getItemsPerLine() - 2)));
    }

    public int getItemsPerLine() {
        return class_3532.method_15375((float)(((float)this.getWidth() - 4.0f) / 18.0f));
    }
}

