/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.config.ItemCheatingMode;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.SearchArgument;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;

public class EntryListWidget
extends Widget {
    private static final Supplier<Boolean> RENDER_EXTRA_CONFIG = () -> ConfigManager.getInstance().getConfig().doesRenderEntryExtraOverlay();
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final Comparator<EntryStack> ASCENDING_COMPARATOR;
    private static List<class_1792> searchBlacklisted;
    private static float scroll;
    private static float target;
    private static long start;
    private static long duration;
    private static float maxScroll;
    private static float scrollBarAlpha;
    private static float scrollBarAlphaFuture;
    private static long scrollBarAlphaFutureTime;
    private static boolean draggingScrollBar;
    private final List<SearchArgument[]> lastSearchArgument;
    private List<EntryStack> currentDisplayed = Lists.newArrayList();
    private List<Slot> widgets;
    private int width = 0;
    private int height = 0;
    private int page;
    private Rectangle rectangle;
    private Rectangle listArea;

    public EntryListWidget(int page) {
        this.page = page;
        this.lastSearchArgument = Lists.newArrayList();
    }

    public static List<String> tryGetItemStackToolTip(class_1799 itemStack, boolean careAboutAdvanced) {
        if (!searchBlacklisted.contains(itemStack.method_7909())) {
            try {
                return CollectionUtils.map(itemStack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 && careAboutAdvanced ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934)), class_2561::method_10863);
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(itemStack.method_7909());
            }
        }
        return Collections.singletonList(EntryListWidget.tryGetItemStackName(itemStack));
    }

    public static String tryGetEntryStackName(EntryStack stack) {
        if (stack.getType() == EntryStack.Type.ITEM) {
            return EntryListWidget.tryGetItemStackName(stack.getItemStack());
        }
        if (stack.getType() == EntryStack.Type.FLUID) {
            return EntryListWidget.tryGetFluidName(stack.getFluid());
        }
        return EMPTY;
    }

    public static String tryGetFluidName(class_3611 fluid) {
        class_2960 id = class_2378.field_11154.method_10221((Object)fluid);
        if (class_1074.method_4663((String)("block." + id.toString().replaceFirst(":", ".")))) {
            return class_1074.method_4662((String)("block." + id.toString().replaceFirst(":", ".")), (Object[])new Object[0]);
        }
        return CollectionUtils.mapAndJoinToString(id.method_12832().split("_"), StringUtils::capitalize, SPACE);
    }

    public static String tryGetItemStackName(class_1799 stack) {
        if (!searchBlacklisted.contains(stack.method_7909())) {
            try {
                return stack.method_7964().method_10863();
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(stack.method_7909());
            }
        }
        try {
            return class_1074.method_4662((String)("item." + class_2378.field_11142.method_10221((Object)stack.method_7909()).toString().replace(":", ".")), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public static boolean filterEntry(EntryStack entry, List<SearchArgument[]> arguments) {
        if (arguments.isEmpty()) {
            return true;
        }
        AtomicReference<String> mod = new AtomicReference<String>();
        AtomicReference<String> tooltips = new AtomicReference<String>();
        AtomicReference<String> name = new AtomicReference<String>();
        for (SearchArgument[] arguments1 : arguments) {
            boolean b = true;
            for (SearchArgument argument : arguments1) {
                if (argument.getArgumentType() == SearchArgument.ArgumentType.ALWAYS) {
                    return true;
                }
                if (argument.getArgumentType() == SearchArgument.ArgumentType.MOD) {
                    EntryListWidget.fillMod(entry, mod);
                    if (mod.get() != null && !mod.get().isEmpty() && argument.getFunction(!argument.isInclude()).apply(mod.get()).booleanValue()) {
                        b = false;
                        break;
                    }
                }
                if (argument.getArgumentType() == SearchArgument.ArgumentType.TOOLTIP) {
                    EntryListWidget.fillTooltip(entry, tooltips);
                    if (tooltips.get() != null && !tooltips.get().isEmpty() && argument.getFunction(!argument.isInclude()).apply(tooltips.get()).booleanValue()) {
                        b = false;
                        break;
                    }
                }
                if (argument.getArgumentType() != SearchArgument.ArgumentType.TEXT) continue;
                EntryListWidget.fillName(entry, name);
                if (name.get() == null || name.get().isEmpty() || !argument.getFunction(!argument.isInclude()).apply(name.get()).booleanValue()) continue;
                b = false;
                break;
            }
            if (!b) continue;
            return true;
        }
        return false;
    }

    private static AtomicReference<String> fillMod(EntryStack entry, AtomicReference<String> mod) {
        if (mod.get() == null) {
            Optional<class_2960> identifier = entry.getIdentifier();
            if (identifier.isPresent()) {
                mod.set(ClientHelper.getInstance().getModFromIdentifier(identifier.get()).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
            } else {
                mod.set(EMPTY);
            }
        }
        return mod;
    }

    private static AtomicReference<String> fillTooltip(EntryStack entry, AtomicReference<String> mod) {
        if (mod.get() == null) {
            if (entry.getType() == EntryStack.Type.ITEM) {
                mod.set(CollectionUtils.joinToString(EntryListWidget.tryGetItemStackToolTip(entry.getItemStack(), false), EMPTY).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
            } else {
                mod.set(EntryListWidget.tryGetEntryStackName(entry).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
            }
        }
        return mod;
    }

    private static AtomicReference<String> fillName(EntryStack entry, AtomicReference<String> mod) {
        if (mod.get() == null) {
            mod.set(EntryListWidget.tryGetEntryStackName(entry).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
        }
        return mod;
    }

    public static float getMaxScroll() {
        ScreenHelper.getLastOverlay();
        return Math.max(maxScroll - (float)ContainerScreenOverlay.getEntryListWidget().rectangle.height, 0.0f);
    }

    public static float getScroll() {
        return scroll;
    }

    public static final float clamp(float v) {
        return EntryListWidget.clamp(v, 300.0f);
    }

    public static final float clamp(float v, float clampExtension) {
        return class_3532.method_15363((float)v, (float)(-clampExtension), (float)(EntryListWidget.getMaxScroll() + clampExtension));
    }

    public static void offset(float value, boolean animated) {
        EntryListWidget.scrollTo(target + value, animated);
    }

    public static void scrollTo(float value, boolean animated) {
        EntryListWidget.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public static void scrollTo(float value, boolean animated, long duration) {
        target = EntryListWidget.clamp(value);
        if (animated) {
            start = System.currentTimeMillis();
            EntryListWidget.duration = duration;
        } else {
            scroll = target;
        }
    }

    private static void updatePosition(float delta) {
        if ((target = EntryListWidget.clamp(target)) < 0.0f) {
            target = (float)((double)target - (double)target * (1.0 - ClothConfigInitializer.getBounceBackMultiplier()) * (double)delta / 3.0);
        } else if (target > EntryListWidget.getMaxScroll()) {
            target = (float)((double)(target - EntryListWidget.getMaxScroll()) * (1.0 - (1.0 - ClothConfigInitializer.getBounceBackMultiplier()) * (double)delta / 3.0) + (double)EntryListWidget.getMaxScroll());
        }
        scroll = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((float)scroll, (float)target, (float)0.001f) ? (float)DynamicNewSmoothScrollingEntryListWidget.Interpolation.expoEase((double)scroll, (double)target, (double)Math.min((double)(System.currentTimeMillis() - start) / (double)duration, 1.0)) : target;
    }

    public int getFullTotalSlotsPerPage() {
        return this.width * this.height;
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (ConfigManager.getInstance().getConfig().isEntryListWidgetScrolled() && this.rectangle.contains(double_1, double_2)) {
            if (scrollBarAlphaFuture == 0.0f) {
                scrollBarAlphaFuture = 1.0f;
            }
            if ((float)(System.currentTimeMillis() - scrollBarAlphaFutureTime) > 300.0f) {
                scrollBarAlphaFutureTime = System.currentTimeMillis();
            }
            EntryListWidget.offset((float)(ClothConfigInitializer.getScrollStep() * -double_3), true);
            return true;
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    public void render(int int_1, int int_2, float float_1) {
        if (ConfigManager.getInstance().getConfig().doesVillagerScreenHavePermanentScrollBar()) {
            scrollBarAlphaFutureTime = System.currentTimeMillis();
            scrollBarAlphaFuture = 0.0f;
            scrollBarAlpha = 1.0f;
        } else if (scrollBarAlphaFutureTime > 0L) {
            long l = System.currentTimeMillis() - scrollBarAlphaFutureTime;
            if ((float)l > 300.0f) {
                if (scrollBarAlphaFutureTime == 0L) {
                    scrollBarAlpha = scrollBarAlphaFuture;
                    scrollBarAlphaFutureTime = -1L;
                } else if ((float)l > 2000.0f && scrollBarAlphaFuture == 1.0f) {
                    scrollBarAlphaFuture = 0.0f;
                    scrollBarAlphaFutureTime = System.currentTimeMillis();
                } else {
                    scrollBarAlpha = scrollBarAlphaFuture;
                }
            } else if (scrollBarAlphaFuture == 0.0f) {
                scrollBarAlpha = Math.min(scrollBarAlpha, 1.0f - Math.min(1.0f, (float)l / 300.0f));
            } else if (scrollBarAlphaFuture == 1.0f) {
                scrollBarAlpha = Math.max(Math.min(1.0f, (float)l / 300.0f), scrollBarAlpha);
            }
        }
        class_308.method_1450();
        RenderSystem.pushMatrix();
        boolean widgetScrolled = ConfigManager.getInstance().getConfig().isEntryListWidgetScrolled();
        if (!widgetScrolled) {
            scroll = 0.0f;
        } else {
            EntryListWidget.updatePosition(float_1);
            this.page = 0;
            ScreenHelper.getLastOverlay();
            ContainerScreenOverlay.setPage(0);
            ScissorsHandler.INSTANCE.scissor(this.rectangle);
        }
        this.widgets.forEach(widget -> {
            if (widgetScrolled) {
                widget.getBounds().y = (int)((float)((Slot)widget).backupY - scroll);
                if (widget.getBounds().y <= this.rectangle.y + this.rectangle.height && widget.getBounds().getMaxY() >= this.rectangle.y) {
                    widget.render(int_1, int_2, float_1);
                }
            } else {
                widget.render(int_1, int_2, float_1);
            }
        });
        if (widgetScrolled) {
            double height = EntryListWidget.getMaxScroll();
            if (height > (double)this.rectangle.height) {
                class_289 tessellator = class_289.method_1348();
                class_287 buffer = tessellator.method_1349();
                double maxScroll = height;
                int scrollBarHeight = class_3532.method_15357((double)((double)(this.rectangle.height * this.rectangle.height) / maxScroll));
                scrollBarHeight = class_3532.method_15340((int)scrollBarHeight, (int)32, (int)(this.rectangle.height - 8));
                scrollBarHeight = (int)((double)scrollBarHeight - Math.min((double)((double)scroll < 0.0 ? (float)((int)(-scroll)) : ((double)scroll > (double)this.getMaxScroll() ? (float)((int)scroll) - this.getMaxScroll() : 0.0f)), (double)scrollBarHeight * 0.75));
                int minY = (int)Math.min(Math.max((double)((int)this.getScroll() * (this.rectangle.height - scrollBarHeight)) / maxScroll + (double)this.rectangle.y, (double)this.rectangle.y), (double)(this.rectangle.getMaxY() - scrollBarHeight));
                int scrollbarPositionMinX = this.rectangle.getMaxX() - 5;
                int scrollbarPositionMaxX = this.rectangle.getMaxX();
                boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, scrollBarHeight).contains(PointHelper.fromMouse());
                float bottomC = (hovered ? 0.67f : 0.5f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
                float topC = (hovered ? 0.87f : 0.67f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
                class_308.method_1450();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.disableAlphaTest();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                RenderSystem.shadeModel((int)7425);
                buffer.method_1328(7, class_290.field_1576);
                buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + scrollBarHeight), 800.0).method_22915(bottomC, bottomC, bottomC, scrollBarAlpha).method_1344();
                buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + scrollBarHeight), 800.0).method_22915(bottomC, bottomC, bottomC, scrollBarAlpha).method_1344();
                buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 800.0).method_22915(bottomC, bottomC, bottomC, scrollBarAlpha).method_1344();
                buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 800.0).method_22915(bottomC, bottomC, bottomC, scrollBarAlpha).method_1344();
                tessellator.method_1350();
                buffer.method_1328(7, class_290.field_1576);
                buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + scrollBarHeight - 1), 800.0).method_22915(topC, topC, topC, scrollBarAlpha).method_1344();
                buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + scrollBarHeight - 1), 800.0).method_22915(topC, topC, topC, scrollBarAlpha).method_1344();
                buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 800.0).method_22915(topC, topC, topC, scrollBarAlpha).method_1344();
                buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 800.0).method_22915(topC, topC, topC, scrollBarAlpha).method_1344();
                tessellator.method_1350();
                RenderSystem.shadeModel((int)7424);
                RenderSystem.disableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
        }
        RenderSystem.popMatrix();
        class_746 player = this.minecraft.field_1724;
        if (this.rectangle.contains(PointHelper.fromMouse()) && ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(class_1074.method_4662((String)"text.rei.delete_items", (Object[])new Object[0])));
        }
    }

    public void updateList(DisplayHelper.DisplayBoundsHandler<?> boundsHandler, Rectangle rectangle, int page, String searchTerm, boolean processSearchTerm) {
        this.rectangle = rectangle;
        this.page = page;
        this.widgets = Lists.newCopyOnWriteArrayList();
        this.calculateListSize(rectangle);
        if (this.currentDisplayed.isEmpty() || processSearchTerm) {
            this.currentDisplayed = this.processSearchTerm(searchTerm, EntryRegistry.getInstance().getStacksList(), CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create));
        }
        int startX = rectangle.getCenterX() - this.width * 9;
        int startY = rectangle.getCenterY() - this.height * 9;
        this.listArea = new Rectangle(startX, startY, this.width * 18, this.height * 18);
        int fitSlotsPerPage = this.getTotalFitSlotsPerPage(startX, startY, this.listArea);
        int j = page * fitSlotsPerPage;
        if (ConfigManager.getInstance().getConfig().isEntryListWidgetScrolled()) {
            this.height = Integer.MAX_VALUE;
            j = 0;
        }
        float maxScroll = 0.0f;
        for (int yy = 0; yy < this.height; ++yy) {
            for (int xx = 0; xx < this.width; ++xx) {
                int x = startX + xx * 18;
                int y = startY + yy * 18;
                if (!this.canBeFit(x, y, this.listArea)) continue;
                if (++j > this.currentDisplayed.size()) break;
                EntryStack stack = this.currentDisplayed.get(j - 1).copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_OVERLAY, RENDER_EXTRA_CONFIG);
                maxScroll = y + 18;
                this.widgets.add((Slot)new Slot(xx, yy, x, y).entry(stack).noBackground());
            }
            if (j > this.currentDisplayed.size()) break;
        }
        EntryListWidget.maxScroll = Math.max(maxScroll - 18.0f, 0.0f);
    }

    public int getTotalPage() {
        if (ConfigManager.getInstance().getConfig().isEntryListWidgetScrolled()) {
            return 1;
        }
        int fitSlotsPerPage = this.getTotalFitSlotsPerPage(this.listArea.x, this.listArea.y, this.listArea);
        if (fitSlotsPerPage > 0) {
            return class_3532.method_15386((float)(this.getCurrentDisplayed().size() / fitSlotsPerPage));
        }
        return 0;
    }

    public int getTotalFitSlotsPerPage(int startX, int startY, Rectangle listArea) {
        int slots = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.canBeFit(startX + x * 18, startY + y * 18, listArea)) continue;
                ++slots;
            }
        }
        return slots;
    }

    public boolean canBeFit(int left, int top, Rectangle listArea) {
        for (DisplayHelper.DisplayBoundsHandler<?> sortedBoundsHandler : DisplayHelper.getInstance().getSortedBoundsHandlers(this.minecraft.field_1755.getClass())) {
            class_1269 fit = sortedBoundsHandler.canItemSlotWidgetFit(!ConfigManager.getInstance().getConfig().isLeftHandSidePanel(), left, top, this.minecraft.field_1755, listArea);
            if (fit == class_1269.field_5811) continue;
            return fit == class_1269.field_5812;
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        int actualHeight;
        float height;
        if (int_1 == 0 && scrollBarAlpha > 0.0f && draggingScrollBar && (height = maxScroll) > (float)(actualHeight = this.rectangle.height) && mouseY >= (double)this.rectangle.y && mouseY <= (double)this.rectangle.getMaxY()) {
            double double_5 = Math.max(1.0f, this.getMaxScroll());
            int int_2 = this.rectangle.height;
            int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / maxScroll)), (int)32, (int)(int_2 - 8));
            double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
            scrollBarAlphaFutureTime = System.currentTimeMillis();
            scrollBarAlphaFuture = 1.0f;
            EntryListWidget.scrollTo(class_3532.method_15363((float)((float)((double)scroll + double_4 * double_6)), (float)0.0f, (float)(height - (float)this.rectangle.height)), false);
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.rectangle.contains(PointHelper.fromMouse())) {
            for (Widget widget : this.widgets) {
                if (!widget.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public List getCurrentDisplayed() {
        return this.currentDisplayed;
    }

    private List<EntryStack> processSearchTerm(String searchTerm, List<EntryStack> ol, List<EntryStack> inventoryItems) {
        String[] splitSearchTerm;
        this.lastSearchArgument.clear();
        LinkedList<EntryStack> os = new LinkedList<EntryStack>(ol);
        if (ConfigManager.getInstance().getConfig().getItemListOrdering() != ItemListOrdering.registry) {
            os.sort(ASCENDING_COMPARATOR);
        }
        if (!ConfigManager.getInstance().getConfig().isItemListAscending()) {
            Collections.reverse(os);
        }
        for (String s : splitSearchTerm = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm, (String)"|")) {
            String[] split = StringUtils.split((String)s);
            SearchArgument[] arguments = new SearchArgument[split.length];
            for (int i = 0; i < split.length; ++i) {
                String s1 = split[i];
                arguments[i] = s1.startsWith("@-") || s1.startsWith("-@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(2), false) : (s1.startsWith("@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(1), true) : (s1.startsWith("#-") || s1.startsWith("-#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(2), false) : (s1.startsWith("#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(1), true) : (s1.startsWith("-") ? new SearchArgument(SearchArgument.ArgumentType.TEXT, s1.substring(1), false) : new SearchArgument(SearchArgument.ArgumentType.TEXT, s1, true)))));
            }
            if (arguments.length > 0) {
                this.lastSearchArgument.add(arguments);
                continue;
            }
            this.lastSearchArgument.add(new SearchArgument[]{SearchArgument.ALWAYS});
        }
        List<Object> stacks = Collections.emptyList();
        stacks = this.lastSearchArgument.isEmpty() ? os : CollectionUtils.filter(os, entry -> EntryListWidget.filterEntry(entry, this.lastSearchArgument));
        if (!ConfigManager.getInstance().isCraftableOnlyEnabled() || stacks.isEmpty() || inventoryItems.isEmpty()) {
            return Collections.unmodifiableList(stacks);
        }
        List<EntryStack> workingItems = RecipeHelper.getInstance().findCraftableEntriesByItems(inventoryItems);
        LinkedList newList = Lists.newLinkedList();
        for (EntryStack workingItem : workingItems) {
            EntryStack any = CollectionUtils.findFirstOrNullEquals(stacks, workingItem);
            if (any == null) continue;
            newList.add(any);
        }
        if (newList.isEmpty()) {
            return Collections.unmodifiableList(stacks);
        }
        return Collections.unmodifiableList(newList);
    }

    public List<SearchArgument[]> getLastSearchArgument() {
        return this.lastSearchArgument;
    }

    public void calculateListSize(Rectangle rect) {
        int xOffset = 0;
        int yOffset = 0;
        this.width = 0;
        this.height = 0;
        do {
            xOffset += 18;
            if (this.height == 0) {
                ++this.width;
            }
            if (xOffset + 19 <= rect.width) continue;
            xOffset = 0;
            yOffset += 18;
            ++this.height;
        } while (yOffset + 19 <= rect.height);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        double scrollbarPositionMinX;
        int actualHeight;
        double height = EntryListWidget.getMaxScroll();
        if (height > (double)(actualHeight = this.rectangle.height) && scrollBarAlpha > 0.0f && double_2 >= (double)this.rectangle.y && double_2 <= (double)this.rectangle.getMaxY() && double_1 >= (scrollbarPositionMinX = (double)(this.rectangle.getMaxX() - 6)) - 2.0 & double_1 <= scrollbarPositionMinX + 8.0) {
            draggingScrollBar = true;
            scrollBarAlpha = 1.0f;
            return true;
        }
        draggingScrollBar = false;
        if (this.rectangle.contains(double_1, double_2)) {
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
            for (Widget widget : this.children()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Slot> children() {
        return this.widgets;
    }

    static {
        searchBlacklisted = Lists.newArrayList();
        scrollBarAlpha = 0.0f;
        scrollBarAlphaFuture = 0.0f;
        scrollBarAlphaFutureTime = -1L;
        draggingScrollBar = false;
        ASCENDING_COMPARATOR = (entry, entry1) -> {
            if (ConfigManager.getInstance().getConfig().getItemListOrdering().equals((Object)ItemListOrdering.name)) {
                return EntryListWidget.tryGetEntryStackName(entry).compareToIgnoreCase(EntryListWidget.tryGetEntryStackName(entry1));
            }
            if (ConfigManager.getInstance().getConfig().getItemListOrdering().equals((Object)ItemListOrdering.item_groups) && entry.getType() == EntryStack.Type.ITEM && entry1.getType() == EntryStack.Type.ITEM) {
                class_1799 stack0 = entry.getItemStack();
                class_1799 stack1 = entry1.getItemStack();
                List<class_1761> itemGroups = Arrays.asList(class_1761.field_7921);
                return itemGroups.indexOf(stack0.method_7909().method_7859()) - itemGroups.indexOf(stack1.method_7909().method_7859());
            }
            return 0;
        };
    }

    private class Slot
    extends EntryWidget {
        private final int backupY;
        private int xx;
        private int yy;

        public Slot(int xx, int yy, int x, int y) {
            super(x, y);
            this.xx = xx;
            this.yy = yy;
            this.backupY = y;
        }

        public int getBackupY() {
            return this.backupY;
        }

        public int getXx() {
            return this.xx;
        }

        public int getYy() {
            return this.yy;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && EntryListWidget.this.rectangle.contains(mouseX, mouseY);
        }

        @Override
        protected void queueTooltip(int mouseX, int mouseY, float delta) {
            class_746 player = this.minecraft.field_1724;
            if (!ClientHelper.getInstance().isCheating() || player.field_7514.method_7399().method_7960()) {
                super.queueTooltip(mouseX, mouseY, delta);
            }
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.interactable) {
                return super.mouseClicked(mouseX, mouseY, button);
            }
            if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating()) {
                EntryStack entry = this.getCurrentEntry().copy();
                if (entry.getType() == EntryStack.Type.ITEM) {
                    if (ConfigManager.getInstance().getConfig().getItemCheatingMode() == ItemCheatingMode.REI_LIKE) {
                        entry.setAmount(button != 1 ? 1 : entry.getItemStack().method_7914());
                    } else if (ConfigManager.getInstance().getConfig().getItemCheatingMode() == ItemCheatingMode.JEI_LIKE) {
                        entry.setAmount(button != 0 ? 1 : entry.getItemStack().method_7914());
                    } else {
                        entry.setAmount(1);
                    }
                }
                ClientHelper.getInstance().tryCheatingEntry(entry);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }
}

