/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui.widget;

import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import org.jetbrains.annotations.ApiStatus;

import java.util.Collections;
import java.util.List;

public class RecipeArrowWidget extends WidgetWithBounds {
    
    private int x, y;
    private double time = 250d;
    private boolean animated;
    
    @ApiStatus.Internal
    public RecipeArrowWidget(int x, int y, boolean animated) {
        this.x = x;
        this.y = y;
        this.animated = animated;
    }
    
    public static RecipeArrowWidget create(Point point, boolean animated) {
        return new RecipeArrowWidget(point.x, point.y, animated);
    }
    
    public RecipeArrowWidget time(double time) {
        this.time = time;
        return this;
    }
    
    @Override
    public Rectangle getBounds() {
        return new Rectangle(x, y, 24, 17);
    }
    
    @Override
    public void render(int mouseX, int mouseY, float delta) {
        class_310.method_1551().method_1531().method_22813(DefaultPlugin.getDisplayTexture());
        blit(x, y, 106, 91, 24, 17);
        if (animated) {
            int width = class_3532.method_15384((System.currentTimeMillis() / (time / 24) % 24d) / 1f);
            blit(x, y, 82, 91, width, 17);
        }
    }
    
    @Override
    public List<? extends class_364> children() {
        return Collections.emptyList();
    }
}
