/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import net.minecraft.class_1269;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

@ApiStatus.Internal
public class BaseBoundsHandlerImpl implements BaseBoundsHandler {
    
    private static final Comparator<? super Rectangle> RECTANGLE_COMPARER = Comparator.comparingLong(Rectangle::hashCode);
    
    private long lastArea = -1;
    private List<class_3545<class_3545<Class<?>, Float>, Supplier<List<Rectangle>>>> list = Lists.newArrayList();
    
    @Override
    public Class<?> getBaseSupportedClass() {
        return class_437.class;
    }
    
    @Override
    public Rectangle getLeftBounds(class_437 screen) {
        return new Rectangle();
    }
    
    @Override
    public Rectangle getRightBounds(class_437 screen) {
        return new Rectangle();
    }
    
    @Override
    public float getPriority() {
        return -5f;
    }
    
    @Override
    public class_1269 isInZone(double mouseX, double mouseY) {
        Class<? extends class_437> screenClass = class_310.method_1551().field_1755.getClass();
        for (class_3545<class_3545<Class<?>, Float>, Supplier<List<Rectangle>>> pair : list) {
            if (pair.method_15442().method_15442().isAssignableFrom(screenClass))
                for (Rectangle zone : pair.method_15441().get())
                    if (zone.contains(mouseX, mouseY))
                        return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }
    
    @Override
    public boolean shouldRecalculateArea(boolean isOnRightSide, Rectangle rectangle) {
        long current = currentHashCode(isOnRightSide);
        if (lastArea == current)
            return false;
        lastArea = current;
        return true;
    }
    
    private long currentHashCode(boolean isOnRightSide) {
        DisplayHelper.DisplayBoundsHandler<class_437> handler = (DisplayHelper.DisplayBoundsHandler<class_437>) DisplayHelper.getInstance().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
        return areasHashCode(isOnRightSide ? handler.getRightBounds(class_310.method_1551().field_1755) : handler.getLeftBounds(class_310.method_1551().field_1755), getExclusionZones(class_310.method_1551().field_1755.getClass(), false));
    }
    
    @Override
    public class_1269 canItemSlotWidgetFit(int left, int top, class_437 screen, Rectangle fullBounds) {
        Class<? extends class_437> screenClass = screen.getClass();
        for (class_3545<class_3545<Class<?>, Float>, Supplier<List<Rectangle>>> pair : list) {
            if (pair.method_15442().method_15442().isAssignableFrom(screenClass))
                for (Rectangle zone : pair.method_15441().get()) {
                    if (left + 18 >= zone.x && top + 18 >= zone.y && left <= zone.getMaxX() && top <= zone.getMaxY())
                        return class_1269.field_5814;
                }
        }
        return class_1269.field_5811;
    }
    
    @Override
    public List<Rectangle> getExclusionZones(Class<?> currentScreenClass, boolean sort) {
        List<Rectangle> rectangles = Lists.newArrayList();
        for (class_3545<class_3545<Class<?>, Float>, Supplier<List<Rectangle>>> pair : list) {
            if (pair.method_15442().method_15442().isAssignableFrom(currentScreenClass))
                rectangles.addAll(pair.method_15441().get());
        }
        if (sort)
            rectangles.sort(RECTANGLE_COMPARER);
        return rectangles;
    }
    
    @Override
    public int supplierSize() {
        return list.size();
    }
    
    @Override
    public void registerExclusionZones(Class<?> screenClass, Supplier<List<Rectangle>> supplier) {
        list.add(new class_3545<>(new class_3545<>(screenClass, 0f), supplier));
    }
    
    private long areasHashCode(Rectangle rectangle, List<Rectangle> exclusionZones) {
        int hashCode = 31 + (rectangle == null ? 0 : rectangle.hashCode());
        for (Rectangle e : exclusionZones)
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        return hashCode;
    }
    
}
