/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.cooking;

import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.TransferRecipeDisplay;
import me.shedaniel.rei.server.ContainerInfo;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_2960;
import net.minecraft.class_3866;
import org.jetbrains.annotations.ApiStatus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class DefaultCookingDisplay implements TransferRecipeDisplay {
    private static List<EntryStack> fuel;
    
    static {
        fuel = class_3866.method_11196().keySet().stream().map(class_1792::method_7854).map(EntryStack::create).map(e -> e.setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, stack -> Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662("category.rei.smelting.fuel")))).collect(Collectors.toList());
    }
    
    private class_1874 recipe;
    private List<List<EntryStack>> input;
    private List<EntryStack> output;
    private float xp;
    private double cookTime;
    
    public DefaultCookingDisplay(class_1874 recipe) {
        this.recipe = recipe;
        this.input = recipe.method_8117().stream().map(i -> {
            List<EntryStack> entries = new ArrayList<>();
            for (class_1799 stack : i.method_8105()) {
                entries.add(EntryStack.create(stack));
            }
            return entries;
        }).collect(Collectors.toList());
        this.input.add(fuel);
        this.output = Collections.singletonList(EntryStack.create(recipe.method_8110()));
        this.xp = recipe.method_8171();
        this.cookTime = recipe.method_8167();
    }
    
    @Override
    public Optional<class_2960> getRecipeLocation() {
        return Optional.ofNullable(recipe).map(class_1874::method_8114);
    }
    
    @Override
    public List<List<EntryStack>> getInputEntries() {
        return input;
    }
    
    @Override
    public List<EntryStack> getOutputEntries() {
        return output;
    }
    
    @Override
    public List<List<EntryStack>> getRequiredEntries() {
        return input;
    }
    
    public float getXp() {
        return xp;
    }
    
    public double getCookingTime() {
        return cookTime;
    }
    
    @ApiStatus.Internal
    public Optional<class_1874> getOptionalRecipe() {
        return Optional.ofNullable(recipe);
    }
    
    @Override
    public int getWidth() {
        return 1;
    }
    
    @Override
    public int getHeight() {
        return 1;
    }
    
    @Override
    public List<List<EntryStack>> getOrganisedInputEntries(ContainerInfo<class_1703> containerInfo, class_1703 container) {
        return CollectionUtils.map(recipe.method_8117(), i -> CollectionUtils.map(i.method_8105(), EntryStack::create));
    }
    
}
