/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.crafting;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.TransferRecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import me.shedaniel.rei.server.ContainerInfo;
import net.minecraft.class_1703;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface DefaultCraftingDisplay extends TransferRecipeDisplay {
    
    @Override
    default class_2960 getRecipeCategory() {
        return DefaultPlugin.CRAFTING;
    }
    
    @Override
    default int getWidth() {
        return 2;
    }
    
    @Override
    default int getHeight() {
        return 2;
    }
    
    Optional<class_1860<?>> getOptionalRecipe();
    
    @Override
    default List<List<EntryStack>> getOrganisedInputEntries(ContainerInfo<class_1703> containerInfo, class_1703 container) {
        List<List<EntryStack>> list = Lists.newArrayListWithCapacity(containerInfo.getCraftingWidth(container) * containerInfo.getCraftingHeight(container));
        for (int i = 0; i < containerInfo.getCraftingWidth(container) * containerInfo.getCraftingHeight(container); i++) {
            list.add(Collections.emptyList());
        }
        for (int i = 0; i < getInputEntries().size(); i++) {
            List<EntryStack> stacks = getInputEntries().get(i);
            list.set(DefaultCraftingCategory.getSlotWithSize(this, i, containerInfo.getCraftingWidth(container)), stacks);
        }
        return list;
    }
}
