/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.ObjectHolder;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.EmptyEntryStack;
import me.shedaniel.rei.impl.FluidEntryStack;
import me.shedaniel.rei.impl.ItemEntryStack;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface EntryStack {
    public static EntryStack empty() {
        return EmptyEntryStack.EMPTY;
    }

    public static EntryStack create(class_3611 fluid) {
        return new FluidEntryStack(fluid);
    }

    public static EntryStack create(class_3611 fluid, int amount) {
        return new FluidEntryStack(fluid, amount);
    }

    public static EntryStack create(class_1799 stack) {
        return new ItemEntryStack(stack);
    }

    public static EntryStack create(class_1935 item) {
        return new ItemEntryStack(new class_1799(item));
    }

    @ApiStatus.Internal
    public static EntryStack readFromJson(JsonElement jsonElement) {
        try {
            JsonObject obj = jsonElement.getAsJsonObject();
            switch (obj.getAsJsonPrimitive("type").getAsString()) {
                case "stack": {
                    return EntryStack.create(class_1799.method_7915((class_2487)class_2522.method_10718((String)obj.get("nbt").getAsString())));
                }
                case "fluid": {
                    return EntryStack.create((class_3611)class_2378.field_11154.method_10223(class_2960.method_12829((String)obj.get("id").getAsString())));
                }
                case "empty": {
                    return EntryStack.empty();
                }
            }
            throw new IllegalArgumentException("Invalid Entry Type!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return EntryStack.empty();
        }
    }

    @ApiStatus.Internal
    @Nullable
    default public JsonElement toJson() {
        try {
            switch (this.getType()) {
                case ITEM: {
                    JsonObject obj1 = new JsonObject();
                    obj1.addProperty("type", "stack");
                    obj1.addProperty("nbt", this.getItemStack().method_7953(new class_2487()).toString());
                    return obj1;
                }
                case FLUID: {
                    Optional<class_2960> optionalIdentifier = this.getIdentifier();
                    if (!optionalIdentifier.isPresent()) {
                        throw new NullPointerException("Invalid Fluid: " + this.toString());
                    }
                    JsonObject obj2 = new JsonObject();
                    obj2.addProperty("type", "fluid");
                    obj2.addProperty("id", optionalIdentifier.get().toString());
                    return obj2;
                }
                case EMPTY: {
                    JsonObject obj3 = new JsonObject();
                    obj3.addProperty("type", "empty");
                    return obj3;
                }
            }
            throw new IllegalArgumentException("Invalid Entry Type!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Optional<class_2960> getIdentifier();

    public Type getType();

    public int getAmount();

    public void setAmount(int var1);

    public boolean isEmpty();

    public EntryStack copy();

    public Object getObject();

    public boolean equals(EntryStack var1, boolean var2, boolean var3);

    public boolean equalsIgnoreTagsAndAmount(EntryStack var1);

    public boolean equalsIgnoreTags(EntryStack var1);

    public boolean equalsIgnoreAmount(EntryStack var1);

    public boolean equalsAll(EntryStack var1);

    default public int hashOfAll() {
        return this.hashCode();
    }

    public int getZ();

    public void setZ(int var1);

    default public class_1799 getItemStack() {
        if (this.getType() == Type.ITEM) {
            return (class_1799)this.getObject();
        }
        return null;
    }

    default public class_1792 getItem() {
        if (this.getType() == Type.ITEM) {
            return ((class_1799)this.getObject()).method_7909();
        }
        return null;
    }

    default public class_3611 getFluid() {
        if (this.getType() == Type.FLUID) {
            return (class_3611)this.getObject();
        }
        return null;
    }

    public <T> EntryStack setting(Settings<T> var1, T var2);

    public <T> EntryStack removeSetting(Settings<T> var1);

    public EntryStack clearSettings();

    default public <T> EntryStack addSetting(Settings<T> settings, T value) {
        return this.setting(settings, value);
    }

    @Deprecated
    default public <T> ObjectHolder<T> getSetting(Settings<T> settings) {
        return ObjectHolder.of(this.get(settings));
    }

    public <T> T get(Settings<T> var1);

    @Nullable
    public QueuedTooltip getTooltip(int var1, int var2);

    public void render(Rectangle var1, int var2, int var3, float var4);

    public static class Settings<T> {
        public static final Supplier<Boolean> TRUE = () -> true;
        public static final Supplier<Boolean> FALSE = () -> false;
        public static final Settings<Supplier<Boolean>> RENDER = new Settings<Supplier<Boolean>>(TRUE);
        public static final Settings<Supplier<Boolean>> CHECK_TAGS = new Settings<Supplier<Boolean>>(FALSE);
        public static final Settings<Supplier<Boolean>> TOOLTIP_ENABLED = new Settings<Supplier<Boolean>>(TRUE);
        public static final Settings<Supplier<Boolean>> TOOLTIP_APPEND_MOD = new Settings<Supplier<Boolean>>(TRUE);
        public static final Settings<Supplier<Boolean>> RENDER_COUNTS = new Settings<Supplier<Boolean>>(TRUE);
        public static final Settings<Function<EntryStack, List<String>>> TOOLTIP_APPEND_EXTRA = new Settings<Function<EntryStack, List>>(stack -> Collections.emptyList());
        public static final Settings<Function<EntryStack, String>> COUNTS = new Settings<Function<EntryStack, String>>(stack -> null);
        private T defaultValue;

        public Settings(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public static class Fluid {
            public static final Settings<Function<EntryStack, String>> AMOUNT_TOOLTIP = new Settings<Function<EntryStack, String>>(stack -> class_1074.method_4662((String)"tooltip.rei.fluid_amount", (Object[])new Object[]{stack.getAmount()}));

            private Fluid() {
            }
        }

        public static class Item {
            public static final Settings<Supplier<Boolean>> RENDER_ENCHANTMENT_GLINT = new Settings<Supplier<Boolean>>(TRUE);
            @Deprecated
            @ApiStatus.ScheduledForRemoval
            public static final Settings<Supplier<Boolean>> RENDER_OVERLAY = RENDER_ENCHANTMENT_GLINT;

            private Item() {
            }
        }
    }

    public static enum Type {
        ITEM,
        FLUID,
        EMPTY,
        RENDER;

    }
}

