/*
 * Copyright (c) 2018, 2019, 2020 shedaniel
 * Licensed under the MIT License (the "License").
 */

package me.shedaniel.rei.gui.widget;

import me.shedaniel.math.api.Point;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_362;
import net.minecraft.class_4068;

/**
 * The base class for a screen widget
 *
 * @see WidgetWithBounds for a widget with bounds
 */
public abstract class Widget extends class_362 implements class_4068 {
    
    /**
     * The Minecraft Client instance
     */
    protected final class_310 minecraft = class_310.method_1551();
    /**
     * The font for rendering text
     */
    protected final class_327 font = minecraft.field_1772;
    
    public int getZ() {
        return this.getBlitOffset();
    }
    
    public void setZ(int z) {
        this.setBlitOffset(z);
    }
    
    public boolean containsMouse(double mouseX, double mouseY) {
        return false;
    }
    
    public final boolean containsMouse(int mouseX, int mouseY) {
        return containsMouse((double) mouseX, (double) mouseY);
    }
    
    public final boolean containsMouse(Point point) {
        return containsMouse(point.x, point.y);
    }
    
    @Override
    public final boolean isMouseOver(double double_1, double double_2) {
        return containsMouse(double_1, double_2);
    }
    
}
