/*
 * Copyright (c) 2018, 2019, 2020 shedaniel
 * Licensed under the MIT License (the "License").
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.prospector.modmenu.ModMenu;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.sargunvohra.mcmods.autoconfig1u.gui.ConfigScreenProvider;
import me.sargunvohra.mcmods.autoconfig1u.gui.registry.GuiRegistry;
import me.sargunvohra.mcmods.autoconfig1u.serializer.JanksonConfigSerializer;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.Jankson;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonObject;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonPrimitive;
import me.sargunvohra.mcmods.autoconfig1u.util.Utils;
import me.shedaniel.cloth.hooks.ScreenHooks;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.ConfigReloadingScreen;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.PreRecipeViewingScreen;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.shedaniel.rei.gui.credits.CreditsScreen;
import me.shedaniel.rei.gui.widget.ReloadConfigButtonWidget;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import static me.sargunvohra.mcmods.autoconfig1u.util.Utils.getUnsafely;
import static me.sargunvohra.mcmods.autoconfig1u.util.Utils.setUnsafely;

@ApiStatus.Internal
public class ConfigManagerImpl implements ConfigManager {
    
    private boolean craftableOnly;
    //    private List<EntryStack> favorites = new ArrayList<>();
    private Gson gson = new GsonBuilder().create();
    
    public ConfigManagerImpl() {
        this.craftableOnly = false;
        AutoConfig.register(ConfigObjectImpl.class, (definition, configClass) -> new JanksonConfigSerializer<>(definition, configClass, Jankson.builder().registerPrimitiveTypeAdapter(class_3675.class_306.class, it -> {
            return it instanceof String ? class_3675.method_15981((String) it) : null;
        }).registerSerializer(class_3675.class_306.class, (it, marshaller) -> new JsonPrimitive(it.method_1441())).registerTypeAdapter(ModifierKeyCode.class, o -> {
            class_3675.class_306 keyCode = class_3675.method_15981(((JsonPrimitive) o.get("keyCode")).asString());
            Modifier modifier = Modifier.of(((Number) ((JsonPrimitive) o.get("modifier")).getValue()).shortValue());
            return ModifierKeyCode.of(keyCode, modifier);
        }).registerSerializer(ModifierKeyCode.class, (keyCode, marshaller) -> {
            JsonObject object = new JsonObject();
            object.put("keyCode", new JsonPrimitive(keyCode.getKeyCode().method_1441()));
            object.put("modifier", new JsonPrimitive(keyCode.getModifier().getValue()));
            return object;
        }).registerSerializer(EntryStack.class, (stack, marshaller) -> {
            return new JsonPrimitive(gson.toJson(stack.toJson()));
        }).registerPrimitiveTypeAdapter(EntryStack.class, it -> {
            return it instanceof String ? EntryStack.readFromJson(gson.fromJson((String) it, JsonElement.class)) : null;
        }).build()));
        GuiRegistry guiRegistry = AutoConfig.getGuiRegistry(ConfigObjectImpl.class);
        //noinspection rawtypes
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(ConfigEntryBuilder.create().startEnumSelector(i13n, (Class) field.getType(), getUnsafely(field, config, null)).setDefaultValue(() -> getUnsafely(field, defaults)).setSaveConsumer(newValue -> setUnsafely(field, config, newValue)).build()), field -> field.getType().isEnum(), ConfigObject.UseEnumSelectorInstead.class);
        //        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
        //            @SuppressWarnings("rawtypes") List<AbstractConfigListEntry> entries = new ArrayList<>();
        //            for (FabricKeyBinding binding : ClientHelper.getInstance().getREIKeyBindings()) {
        //                entries.add(ConfigEntryBuilder.create().fillKeybindingField(I18n.translate(binding.getId()) + ":", binding).build());
        //            }
        //            KeyCodeEntry entry = ConfigEntryBuilder.create().startKeyCodeField(i13n, getUnsafely(field, config, InputUtil.UNKNOWN_KEYCODE)).setDefaultValue(() -> getUnsafely(field, defaults)).setSaveConsumer(newValue -> setUnsafely(field, config, newValue)).build();
        //            entry.setAllowMouse(false);
        //            entries.add(entry);
        //            return entries;
        //        }, field -> field.getType() == InputUtil.KeyCode.class, ConfigObject.AddInFrontKeyCode.class);
        //        guiRegistry.registerPredicateProvider((i13n, field, config, defaults, guiProvider) -> {
        //            KeyCodeEntry entry = ConfigEntryBuilder.create().startKeyCodeField(i13n, getUnsafely(field, config, InputUtil.UNKNOWN_KEYCODE)).setDefaultValue(() -> getUnsafely(field, defaults)).setSaveConsumer(newValue -> setUnsafely(field, config, newValue)).build();
        //            entry.setAllowMouse(false);
        //            return Collections.singletonList(entry);
        //        }, field -> field.getType() == InputUtil.KeyCode.class);
        guiRegistry.registerPredicateProvider((i13n, field, config, defaults, guiProvider) -> {
            if (field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class))
                return Collections.emptyList();
            KeyCodeEntry entry = ConfigEntryBuilder.create().startModifierKeyCodeField(i13n, getUnsafely(field, config, ModifierKeyCode.unknown())).setModifierDefaultValue(() -> getUnsafely(field, defaults)).setModifierSaveConsumer(newValue -> setUnsafely(field, config, newValue)).build();
            entry.setAllowMouse(false);
            return Collections.singletonList(entry);
        }, field -> field.getType() == ModifierKeyCode.class);
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            ConfigObject.UsePercentage bounds = field.getAnnotation(ConfigObject.UsePercentage.class);
            return Collections.singletonList(ConfigEntryBuilder.create().startIntSlider(i13n, class_3532.method_15384(Utils.getUnsafely(field, config, 0.0) * 100), class_3532.method_15384(bounds.min() * 100), class_3532.method_15384(bounds.max() * 100)).setDefaultValue(() -> class_3532.method_15384((double) Utils.getUnsafely(field, defaults) * 100)).setSaveConsumer((newValue) -> {
                Utils.setUnsafely(field, config, newValue / 100d);
            }).setTextGetter(integer -> String.format("Size: %d%%", integer)).build());
        }, (field) -> field.getType() == Double.TYPE || field.getType() == Double.class, ConfigObject.UsePercentage.class);
        
        guiRegistry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            int width = 220;
            return Collections.singletonList(new TooltipListEntry<RecipeScreenType>(i13n, null) {
                private RecipeScreenType type = getUnsafely(field, config, RecipeScreenType.UNSET);
                private class_339 buttonWidget = new class_4264(0, 0, 0, 20, "") {
                    @Override
                    public void onPress() {
                        class_310.method_1551().method_1507(new PreRecipeViewingScreen(getScreen(), type, false, original -> {
                            class_310.method_1551().method_1507(getScreen());
                            type = original ? RecipeScreenType.ORIGINAL : RecipeScreenType.VILLAGER;
                            getScreen().setEdited(true, isRequiresRestart());
                        }));
                    }
                    
                    @Override
                    public void render(int mouseX, int mouseY, float delta) {
                        setMessage(class_1074.method_4662("config.roughlyenoughitems.recipeScreenType.config", type.toString()));
                        super.render(mouseX, mouseY, delta);
                    }
                };
                private List<class_364> children = ImmutableList.of(buttonWidget);
                
                @Override
                public RecipeScreenType getValue() {
                    return type;
                }
                
                @Override
                public Optional<RecipeScreenType> getDefaultValue() {
                    return Optional.ofNullable(getUnsafely(field, defaults));
                }
                
                @Override
                public void save() {
                    Utils.setUnsafely(field, config, type);
                }
                
                @Override
                public List<? extends class_364> children() {
                    return children;
                }
                
                @Override
                public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
                    super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
                    class_1041 window = class_310.method_1551().method_22683();
                    this.buttonWidget.active = this.isEditable();
                    this.buttonWidget.y = y;
                    this.buttonWidget.x = x + entryWidth / 2 - width / 2;
                    this.buttonWidget.setWidth(width);
                    this.buttonWidget.render(mouseX, mouseY, delta);
                }
            });
        }, (field) -> field.getType() == RecipeScreenType.class, ConfigObject.UseSpecialRecipeTypeScreen.class);
        saveConfig();
        RoughlyEnoughItemsCore.LOGGER.info("[REI] Config is loaded.");
    }
    
    @Override
    public List<EntryStack> getFavorites() {
        return ((ConfigObjectImpl) getConfig()).general.favorites;
    }
    
    @Override
    public void saveConfig() {
        //        ConfigObjectImpl object = (ConfigObjectImpl) getConfig();
        //        object.general.favorites.clear();
        //        for (EntryStack stack : favorites) {
        //            JsonElement element = stack.toJson();
        //            if (element != null)
        //                object.general.favorites.add(gson.toJson(element));
        //        }
        ((me.sargunvohra.mcmods.autoconfig1u.ConfigManager<ConfigObjectImpl>) AutoConfig.getConfigHolder(ConfigObjectImpl.class)).save();
    }
    
    @Override
    public ConfigObject getConfig() {
        return AutoConfig.getConfigHolder(ConfigObjectImpl.class).getConfig();
    }
    
    @Override
    public boolean isCraftableOnlyEnabled() {
        return craftableOnly;
    }
    
    @Override
    public void toggleCraftableOnly() {
        craftableOnly = !craftableOnly;
    }
    
    @SuppressWarnings("deprecation")
    @Override
    public class_437 getConfigScreen(class_437 parent) {
        try {
            ConfigScreenProvider<ConfigObjectImpl> provider = (ConfigScreenProvider<ConfigObjectImpl>) AutoConfig.getConfigScreen(ConfigObjectImpl.class, parent);
            provider.setI13nFunction(manager -> "config.roughlyenoughitems");
            provider.setOptionFunction((baseI13n, field) -> field.isAnnotationPresent(ConfigObject.DontApplyFieldName.class) ? baseI13n : String.format("%s.%s", baseI13n, field.getName()));
            provider.setCategoryFunction((baseI13n, categoryName) -> String.format("%s.%s", baseI13n, categoryName));
            provider.setBuildFunction(builder -> {
                if (FabricLoader.getInstance().isModLoaded("modmenu")) {
                    builder.getOrCreateCategory("config.roughlyenoughitems.!general").addEntry(new TooltipListEntry<Object>(class_1074.method_4662("config.roughlyenoughitems.smooth_scrolling"), null) {
                        int width = 220;
                        private class_339 buttonWidget = new class_4264(0, 0, 0, 20, this.getFieldName()) {
                            public void onPress() {
                                class_437 screen = ModMenu.getConfigScreen("cloth-config2", parent);
                                if (screen != null) {
                                    class_310.method_1551().method_1507(screen);
                                } else
                                    ModMenu.openConfigScreen("cloth-config2");
                            }
                        };
                        private List<class_364> children = ImmutableList.of(this.buttonWidget);
                        
                        public Object getValue() {
                            return null;
                        }
                        
                        public Optional<Object> getDefaultValue() {
                            return Optional.empty();
                        }
                        
                        public void save() {
                        }
                        
                        public List<? extends class_364> children() {
                            return this.children;
                        }
                        
                        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
                            super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
                            class_1041 window = class_310.method_1551().method_22683();
                            this.buttonWidget.active = this.isEditable();
                            this.buttonWidget.y = y;
                            this.buttonWidget.x = x + entryWidth / 2 - this.width / 2;
                            this.buttonWidget.setWidth(this.width);
                            this.buttonWidget.render(mouseX, mouseY, delta);
                        }
                    });
                }
                return builder.setAfterInitConsumer(screen -> {
                    if (class_310.method_1551().method_1562() != null && class_310.method_1551().method_1562().method_2877() != null) {
                        ((ScreenHooks) screen).cloth_addButton(new ReloadConfigButtonWidget(4, 4, 100, 20, class_1074.method_4662("text.rei.reload_config"), buttonWidget -> {
                            RoughlyEnoughItemsCore.syncRecipes(null);
                        }) {
                            @Override
                            public void render(int int_1, int int_2, float float_1) {
                                if (RecipeHelper.getInstance().arePluginsLoading()) {
                                    class_310.method_1551().method_1507(new ConfigReloadingScreen(class_310.method_1551().field_1755));
                                } else
                                    super.render(int_1, int_2, float_1);
                            }
                        });
                    }
                    ((ScreenHooks) screen).cloth_addButton(new class_4264(screen.width - 104, 4, 100, 20, class_1074.method_4662("text.rei.credits")) {
                        @Override
                        public void onPress() {
                            class_310.method_1551().method_1507(new CreditsScreen(screen));
                        }
                    });
                }).setSavingRunnable(() -> {
                    saveConfig();
                    if (ScreenHelper.getSearchField() != null)
                        ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                }).build();
            });
            return provider.get();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new class_437(new class_2585("")) {
            @Override
            public void render(int int_1, int int_2, float float_1) {
                renderDirtBackground(0);
                List<String> list = minecraft.field_1772.method_1728(class_1074.method_4662("text.rei.config_api_failed"), width - 100);
                int y = (int) (height / 2 - minecraft.field_1772.field_2000 * 1.3f / 2 * list.size());
                for (String s : list) {
                    drawCenteredString(minecraft.field_1772, s, width / 2, y, -1);
                    y += minecraft.field_1772.field_2000;
                }
                super.render(int_1, int_2, float_1);
            }
            
            @Override
            protected void init() {
                super.init();
                addButton(new net.minecraft.class_4185(width / 2 - 100, height - 26, 200, 20, class_1074.method_4662("text.rei.back"), buttonWidget -> {
                    this.minecraft.method_1507(parent);
                }));
            }
            
            @Override
            public boolean keyPressed(int int_1, int int_2, int int_3) {
                if (int_1 == 256 && this.shouldCloseOnEsc()) {
                    this.minecraft.method_1507(parent);
                    return true;
                }
                return super.keyPressed(int_1, int_2, int_3);
            }
        };
    }
    
}
