/*
 * Copyright (c) 2018, 2019, 2020 shedaniel
 * Licensed under the MIT License (the "License").
 */

package me.shedaniel.rei.plugin.crafting;

import me.shedaniel.rei.api.EntryStack;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_2960;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultShapelessDisplay implements DefaultCraftingDisplay {
    
    private class_1867 display;
    private List<List<EntryStack>> input;
    private List<EntryStack> output;
    
    public DefaultShapelessDisplay(class_1867 recipe) {
        this.display = recipe;
        this.input = recipe.method_8117().stream().map(i -> {
            List<EntryStack> entries = new ArrayList<>();
            for (class_1799 stack : i.method_8105()) {
                entries.add(EntryStack.create(stack));
            }
            return entries;
        }).collect(Collectors.toList());
        this.output = Collections.singletonList(EntryStack.create(recipe.method_8110()));
    }
    
    @Override
    public Optional<class_1860<?>> getOptionalRecipe() {
        return Optional.ofNullable(display);
    }
    
    @Override
    public Optional<class_2960> getRecipeLocation() {
        return Optional.ofNullable(display).map(class_1867::method_8114);
    }
    
    @Override
    public List<List<EntryStack>> getInputEntries() {
        return input;
    }
    
    @Override
    public List<EntryStack> getOutputEntries() {
        return output;
    }
    
    @Override
    public List<List<EntryStack>> getRequiredEntries() {
        return input;
    }
    
    @Override
    public int getWidth() {
        if (display.method_8117().size() > 4)
            return 3;
        return 2;
    }
    
    @Override
    public int getHeight() {
        if (display.method_8117().size() > 4)
            return 3;
        return 2;
    }
    
}
