/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SearchArgument {
    public static final SearchArgument ALWAYS = new SearchArgument(ArgumentType.ALWAYS, "", true);
    @Deprecated
    private static List<class_1792> searchBlacklisted = Lists.newArrayList();
    private ArgumentType argumentType;
    private String text;
    public final Function<String, Boolean> INCLUDE = s -> s.contains(this.text);
    public final Function<String, Boolean> NOT_INCLUDE = s -> !s.contains(this.text);
    private boolean include;

    public SearchArgument(ArgumentType argumentType, String text, boolean include) {
        this(argumentType, text, include, true);
    }

    public SearchArgument(ArgumentType argumentType, String text, boolean include, boolean autoLowerCase) {
        this.argumentType = argumentType;
        this.text = autoLowerCase ? text.toLowerCase(Locale.ROOT) : text;
        this.include = include;
    }

    @ApiStatus.Internal
    public static String tryGetEntryStackName(EntryStack stack) {
        if (stack.getType() == EntryStack.Type.ITEM) {
            return SearchArgument.tryGetItemStackName(stack.getItemStack());
        }
        if (stack.getType() == EntryStack.Type.FLUID) {
            return SearchArgument.tryGetFluidName(stack.getFluid());
        }
        return "";
    }

    @ApiStatus.Internal
    public static String tryGetEntryStackTooltip(EntryStack stack) {
        QueuedTooltip tooltip = stack.getTooltip(0, 0);
        if (tooltip != null) {
            return CollectionUtils.joinToString(tooltip.getText(), "\n");
        }
        return "";
    }

    @ApiStatus.Internal
    public static String tryGetFluidName(class_3611 fluid) {
        class_2960 id = class_2378.field_11154.method_10221((Object)fluid);
        if (class_1074.method_4663((String)("block." + id.toString().replaceFirst(":", ".")))) {
            return class_1074.method_4662((String)("block." + id.toString().replaceFirst(":", ".")), (Object[])new Object[0]);
        }
        return CollectionUtils.mapAndJoinToString(id.method_12832().split("_"), StringUtils::capitalize, " ");
    }

    @ApiStatus.Internal
    public static List<String> tryGetItemStackToolTip(class_1799 itemStack, boolean careAboutAdvanced) {
        if (!searchBlacklisted.contains(itemStack.method_7909())) {
            try {
                return CollectionUtils.map(itemStack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 && careAboutAdvanced ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934)), class_2561::method_10863);
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(itemStack.method_7909());
            }
        }
        return Collections.singletonList(SearchArgument.tryGetItemStackName(itemStack));
    }

    @ApiStatus.Internal
    public static String tryGetItemStackName(class_1799 stack) {
        if (!searchBlacklisted.contains(stack.method_7909())) {
            try {
                return stack.method_7964().method_10863();
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(stack.method_7909());
            }
        }
        try {
            return class_1074.method_4662((String)("item." + class_2378.field_11142.method_10221((Object)stack.method_7909()).toString().replace(":", ".")), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public Function<String, Boolean> getFunction(boolean include) {
        return include ? this.INCLUDE : this.NOT_INCLUDE;
    }

    public ArgumentType getArgumentType() {
        return this.argumentType;
    }

    public String getText() {
        return this.text;
    }

    public boolean isInclude() {
        return this.include;
    }

    public String toString() {
        return String.format("Argument[%s]: name = %s, include = %b", this.argumentType.name(), this.text, this.include);
    }

    @ApiStatus.Internal
    public static class SearchArguments {
        public static final SearchArguments ALWAYS = new SearchArguments(new SearchArgument[]{ALWAYS});
        private SearchArgument[] arguments;

        public SearchArguments(SearchArgument[] arguments) {
            this.arguments = arguments;
        }

        public SearchArgument[] getArguments() {
            return this.arguments;
        }
    }

    public static enum ArgumentType {
        TEXT,
        MOD,
        TOOLTIP,
        TAG,
        ALWAYS;

    }
}

