/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui;

import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import net.minecraft.class_1109;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_3528;
import net.minecraft.class_3545;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

import java.net.URI;
import java.net.URISyntaxException;

@ApiStatus.Internal
public class WarningAndErrorScreen extends class_437 {
    public static final class_3528<WarningAndErrorScreen> INSTANCE = new class_3528<>(WarningAndErrorScreen::new);
    private class_339 buttonExit;
    private StringEntryListWidget listWidget;
    private class_437 parent;
    
    private WarningAndErrorScreen() {
        super(class_333.field_18967);
    }
    
    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }
    
    public void setParent(class_437 parent) {
        this.parent = parent;
    }
    
    private void addText(String string) {
        for (String s : font.method_1728(string, width - 80)) {
            listWidget.creditsAddEntry(new TextItem(s));
        }
    }
    
    private void addLink(String string, String link) {
        for (String s : font.method_1728(string, width - 80)) {
            listWidget.creditsAddEntry(new LinkItem(s, link));
        }
    }
    
    @Override
    protected void init() {
        children.add(listWidget = new StringEntryListWidget(minecraft, width, height, 32, height - 32));
        listWidget.max = 80;
        listWidget.creditsClearEntries();
        listWidget.creditsAddEntry(new EmptyItem());
        if (!RoughlyEnoughItemsState.getWarnings().isEmpty())
            listWidget.creditsAddEntry(new TextItem("§6Warnings:"));
        for (class_3545<String, String> pair : RoughlyEnoughItemsState.getWarnings()) {
            addText(pair.method_15442());
            if (pair.method_15441() != null)
                addLink(pair.method_15441(), pair.method_15441());
            for (int i = 0; i < 2; i++) {
                listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        if (!RoughlyEnoughItemsState.getWarnings().isEmpty() && !RoughlyEnoughItemsState.getErrors().isEmpty()) {
            listWidget.creditsAddEntry(new EmptyItem());
        }
        if (!RoughlyEnoughItemsState.getErrors().isEmpty())
            listWidget.creditsAddEntry(new TextItem("§cErrors:"));
        for (class_3545<String, String> pair : RoughlyEnoughItemsState.getErrors()) {
            addText(pair.method_15442());
            if (pair.method_15441() != null)
                addLink(pair.method_15441(), pair.method_15441());
            for (int i = 0; i < 2; i++) {
                listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        for (StringItem child : listWidget.children()) {
            listWidget.max = Math.max(listWidget.max, child.getWidth());
        }
        children.add(buttonExit = new class_4185(width / 2 - 100, height - 26, 200, 20,
                RoughlyEnoughItemsState.getErrors().isEmpty() ? "Continue" : "Exit",
                button -> {
                    if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
                        RoughlyEnoughItemsState.clear();
                        RoughlyEnoughItemsState.continues();
                        class_310.method_1551().method_1507(parent);
                        setParent(null);
                    } else {
                        class_310.method_1551().method_1592();
                    }
                }));
    }
    
    @Override
    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        return listWidget.mouseScrolled(double_1, double_2, double_3) || super.mouseScrolled(double_1, double_2, double_3);
    }
    
    @Override
    public void render(int int_1, int int_2, float float_1) {
        this.renderDirtBackground(0);
        this.listWidget.render(int_1, int_2, float_1);
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            this.drawCenteredString(this.font, "Warnings during Roughly Enough Items' initialization", this.width / 2, 16, 16777215);
        } else {
            this.drawCenteredString(this.font, "Errors during Roughly Enough Items' initialization", this.width / 2, 16, 16777215);
        }
        super.render(int_1, int_2, float_1);
        this.buttonExit.render(int_1, int_2, float_1);
    }
    
    private static class StringEntryListWidget extends DynamicNewSmoothScrollingEntryListWidget<StringItem> {
        private boolean inFocus;
        private int max = 80;
        
        public StringEntryListWidget(class_310 client, int width, int height, int startY, int endY) {
            super(client, width, height, startY, endY, class_332.BACKGROUND_LOCATION);
        }
        
        @Override
        public boolean changeFocus(boolean boolean_1) {
            if (!this.inFocus && this.getItemCount() == 0) {
                return false;
            } else {
                this.inFocus = !this.inFocus;
                if (this.inFocus && this.getFocused() == null && this.getItemCount() > 0) {
                    this.moveSelection(1);
                } else if (this.inFocus && this.getFocused() != null) {
                    this.moveSelection(0);
                }
                
                return this.inFocus;
            }
        }
        
        public void creditsClearEntries() {
            clearItems();
        }
        
        private StringItem rei_getEntry(int int_1) {
            return this.children().get(int_1);
        }
        
        public void creditsAddEntry(StringItem entry) {
            addItem(entry);
        }
        
        @Override
        public int getItemWidth() {
            return max;
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 40;
        }
    }
    
    private abstract static class StringItem extends DynamicNewSmoothScrollingEntryListWidget.Entry<StringItem> {
        public abstract int getWidth();
    }
    
    private static class EmptyItem extends StringItem {
        @Override
        public void render(int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        
        }
        
        @Override
        public int getItemHeight() {
            return 5;
        }
        
        @Override
        public int getWidth() {
            return 0;
        }
    }
    
    private static class TextItem extends StringItem {
        private String text;
        
        public TextItem(class_2561 textComponent) {
            this(textComponent.method_10863());
        }
        
        public TextItem(String text) {
            this.text = text;
        }
        
        @Override
        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            class_310.method_1551().field_1772.method_1720(text, x + 5, y, -1);
        }
        
        @Override
        public int getItemHeight() {
            return 12;
        }
        
        @Override
        public boolean changeFocus(boolean boolean_1) {
            return false;
        }
        
        @Override
        public int getWidth() {
            return class_310.method_1551().field_1772.method_1727(text) + 10;
        }
    }
    
    private class LinkItem extends StringItem {
        private String text;
        private String link;
        private boolean contains;
        
        public LinkItem(class_2561 textComponent) {
            this(textComponent.method_10863());
        }
        
        public LinkItem(String text) {
            this(text, text);
        }
        
        public LinkItem(String text, String link) {
            this.text = text;
            this.link = link;
        }
        
        @Override
        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (contains) {
                WarningAndErrorScreen.this.renderTooltip("Click to open link.", mouseX, mouseY);
                class_310.method_1551().field_1772.method_1720("§n" + text, x + 5, y, 0xff1fc3ff);
            } else {
                class_310.method_1551().field_1772.method_1720(text, x + 5, y, 0xff1fc3ff);
            }
        }
        
        @Override
        public int getItemHeight() {
            return 12;
        }
        
        @Override
        public boolean changeFocus(boolean boolean_1) {
            return false;
        }
        
        @Override
        public int getWidth() {
            return class_310.method_1551().field_1772.method_1727(text) + 10;
        }
        
        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (contains && button == 0) {
                class_310.method_1551().method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                try {
                    class_156.method_668().method_673(new URI(link));
                    return true;
                } catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }
}
