/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui.config.entry;

import com.google.common.collect.ImmutableList;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.rei.gui.PreRecipeViewingScreen;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class RecipeScreenTypeEntry extends TooltipListEntry<RecipeScreenType> {
    private int width;
    private RecipeScreenType type;
    private RecipeScreenType defaultValue;
    private Consumer<RecipeScreenType> save;
    private class_339 buttonWidget = new class_4264(0, 0, 0, 20, "") {
        @Override
        public void onPress() {
            class_310.method_1551().method_1507(new PreRecipeViewingScreen(getScreen(), type, false, original -> {
                class_310.method_1551().method_1507(getScreen());
                type = original ? RecipeScreenType.ORIGINAL : RecipeScreenType.VILLAGER;
                getScreen().setEdited(true, isRequiresRestart());
            }));
        }
        
        @Override
        public void render(int mouseX, int mouseY, float delta) {
            setMessage(class_1074.method_4662("config.roughlyenoughitems.recipeScreenType.config", type.toString()));
            super.render(mouseX, mouseY, delta);
        }
    };
    private List<class_364> children = ImmutableList.of(buttonWidget);
    
    public RecipeScreenTypeEntry(int width, String fieldName, RecipeScreenType type, RecipeScreenType defaultValue, Consumer<RecipeScreenType> save) {
        super(fieldName, null);
        this.width = width;
        this.type = type;
        this.defaultValue = defaultValue;
        this.save = save;
    }
    
    @Override
    public RecipeScreenType getValue() {
        return type;
    }
    
    @Override
    public Optional<RecipeScreenType> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }
    
    @Override
    public void save() {
        save.accept(type);
    }
    
    @Override
    public List<? extends class_364> children() {
        return children;
    }
    
    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        class_1041 window = class_310.method_1551().method_22683();
        this.buttonWidget.active = this.isEditable();
        this.buttonWidget.y = y;
        this.buttonWidget.x = x + entryWidth / 2 - width / 2;
        this.buttonWidget.setWidth(width);
        this.buttonWidget.render(mouseX, mouseY, delta);
    }
}
