/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_3902;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ExportRecipeIdentifierToast implements class_368 {
    
    protected static final class_2960 TOASTS_TEX = new class_2960("roughlyenoughitems", "textures/gui/toasts.png");
    private String title;
    private String subtitle;
    private long startTime;
    
    public ExportRecipeIdentifierToast(String title, @Nullable String subtitleNullable) {
        this.title = title;
        this.subtitle = subtitleNullable;
    }
    
    public static void addToast(String title, @Nullable String subtitleNullable) {
        class_310.method_1551().method_1566().method_1999(new ExportRecipeIdentifierToast(title, subtitleNullable));
    }
    
    @Override
    public class_369 method_1986(class_374 toastManager, long var2) {
        toastManager.method_1995().method_1531().method_22813(field_2207);
        RenderSystem.color3f(1.0F, 1.0F, 1.0F);
        toastManager.blit(0, 0, 0, 0, 160, 32);
        if (this.subtitle == null) {
            toastManager.method_1995().field_1772.method_1729(this.title, 18.0F, 12.0F, 11141120);
        } else {
            toastManager.method_1995().field_1772.method_1729(this.title, 18.0F, 7.0F, 11141120);
            toastManager.method_1995().field_1772.method_1729(this.subtitle, 18.0F, 18.0F, -16777216);
        }
        
        return var2 - this.startTime < 5000L ? class_369.field_2210 : class_369.field_2209;
    }
    
    @Override
    public Object method_1987() {
        return class_3902.field_17274;
    }
}