/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import me.shedaniel.math.api.Executor;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.*;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.compat.ModelHasDepth1151Compat;
import me.shedaniel.rei.impl.compat.ModelSideLit1152Compat;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

@ApiStatus.Internal
public class ItemEntryStack extends AbstractEntryStack implements OptimalEntryStack {
    
    private static final Predicate<class_1087> IS_SIDE_LIT;
    private static final class_4587 MATRICES = new class_4587();
    
    static {
        boolean isOn1_15_2 = false;
        String isSideLit = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_1087", "method_24304", "()Z");
        try {
            class_1087.class.getDeclaredMethod(isSideLit);
            isOn1_15_2 = true;
        } catch (NoSuchMethodException ignored) {
        }
        //noinspection Convert2MethodRef
        IS_SIDE_LIT = isOn1_15_2 ? Executor.call(() -> () -> new ModelSideLit1152Compat()) : Executor.call(() -> () -> new ModelHasDepth1151Compat());
    }
    
    private class_1799 itemStack;
    
    public ItemEntryStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }
    
    @Override
    public Optional<class_2960> getIdentifier() {
        return Optional.ofNullable(class_2378.field_11142.method_10221(getItem()));
    }
    
    @Override
    public Type getType() {
        return Type.ITEM;
    }
    
    @Override
    public int getAmount() {
        return itemStack.method_7947();
    }
    
    @Override
    public void setAmount(int amount) {
        itemStack.method_7939(amount);
    }
    
    @Override
    public boolean isEmpty() {
        return itemStack.method_7960();
    }
    
    @Override
    public EntryStack copy() {
        EntryStack stack = EntryStack.create(getItemStack().method_7972());
        for (Map.Entry<Settings<?>, Object> entry : getSettings().entrySet()) {
            stack.setting((Settings<? super Object>) entry.getKey(), entry.getValue());
        }
        return stack;
    }
    
    @Override
    public Object getObject() {
        return itemStack;
    }
    
    @Override
    public boolean equalsIgnoreTagsAndAmount(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        return itemStack.method_7909() == stack.getItem();
    }
    
    @Override
    public boolean equalsAll(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        if (itemStack.method_7909() != stack.getItem() || getAmount() != stack.getAmount())
            return false;
        return class_1799.method_7975(itemStack, stack.getItemStack());
    }
    
    @Override
    public boolean equalsIgnoreAmount(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        if (itemStack.method_7909() != stack.getItem())
            return false;
        class_1799 otherStack = stack.getItemStack();
        class_2487 o1 = itemStack.method_7969();
        class_2487 o2 = otherStack.method_7969();
        return o1 == o2 || ((o1 != null && o2 != null) && equals(o1, o2));
    }
    
    public boolean equals(class_2487 o1, class_2487 o2) {
        int o1Size = 0;
        int o2Size = 0;
        for (String key : o1.method_10541()) {
            if (key.equals("Count"))
                continue;
            o1Size++;
        }
        for (String key : o2.method_10541()) {
            if (key.equals("Count"))
                continue;
            o2Size++;
            if (o2Size > o1Size)
                return false;
        }
        if (o1Size != o2Size)
            return false;
        
        try {
            for (String key : o1.method_10541()) {
                if (key.equals("Count"))
                    continue;
                class_2520 value = o1.method_10580(key);
                class_2520 otherValue = o2.method_10580(key);
                if (value == null) {
                    if (!(otherValue == null && o2.method_10545(key)))
                        return false;
                } else if (value instanceof class_2487 && otherValue instanceof class_2487) {
                    if (!(value == otherValue || (value != null && otherValue != null) && equals((class_2487) value, (class_2487) otherValue)))
                        return false;
                } else {
                    if (!value.method_10714().equals(otherValue.method_10714()))
                        return false;
                }
            }
        } catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        
        return true;
    }
    
    @Override
    public boolean equalsIgnoreTags(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        if (itemStack.method_7909() != stack.getItem())
            return false;
        return getAmount() == stack.getAmount();
    }
    
    @Override
    public int hashOfAll() {
        int result = hashIgnoreAmount();
        result = 31 * result + itemStack.method_7947();
        return result;
    }
    
    @Override
    public int hashIgnoreTags() {
        int result = hashIgnoreAmountAndTags();
        result = 31 * result + itemStack.method_7947();
        return result;
    }
    
    @Override
    public int hashIgnoreAmount() {
        int result = 1;
        result = 31 * result + getType().hashCode();
        result = 31 * result + itemStack.method_7909().hashCode();
        if (itemStack.method_7985()) {
            result = 31 * result + itemStack.method_7969().method_10714().hashCode();
        } else {
            result = 31 * result;
        }
        return result;
    }
    
    @Override
    public int hashIgnoreAmountAndTags() {
        int result = 1;
        result = 31 * result + getType().hashCode();
        result = 31 * result + itemStack.method_7909().hashCode();
        return result;
    }
    
    @Nullable
    @Override
    public QueuedTooltip getTooltip(int mouseX, int mouseY) {
        if (isEmpty() || !get(Settings.TOOLTIP_ENABLED).get())
            return null;
        List<String> toolTip = Lists.newArrayList(SearchArgument.tryGetItemStackToolTip(getItemStack(), true));
        toolTip.addAll(get(Settings.TOOLTIP_APPEND_EXTRA).apply(this));
        if (get(Settings.TOOLTIP_APPEND_MOD).get() && ConfigObject.getInstance().shouldAppendModNames()) {
            final String modString = ClientHelper.getInstance().getFormattedModFromItem(getItem());
            boolean alreadyHasMod = false;
            for (String s : toolTip)
                if (s.equalsIgnoreCase(modString)) {
                    alreadyHasMod = true;
                    break;
                }
            if (!alreadyHasMod)
                toolTip.add(modString);
        }
        return QueuedTooltip.create(toolTip);
    }
    
    @Override
    public void render(Rectangle bounds, int mouseX, int mouseY, float delta) {
        optimisedRenderStart(delta);
        optimisedRenderBase(bounds, mouseX, mouseY, delta);
        optimisedRenderOverlay(bounds, mouseX, mouseY, delta);
        optimisedRenderEnd(delta);
    }
    
    @Override
    public void optimisedRenderStart(float delta) {
        class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
        class_4493.method_21920();
    }
    
    @Override
    public void optimisedRenderEnd(float delta) {
        class_4493.method_21922();
    }
    
    private class_1087 getModelFromStack(class_1799 stack) {
        class_1087 model = class_310.method_1551().method_1480().method_4012().method_3308(stack);
        if (stack.method_7909().method_7845())
            model = model.method_4710().method_3495(model, stack, null, null);
        if (model != null)
            return model;
        return class_310.method_1551().method_1480().method_4012().method_3303().method_4744();
    }
    
    @Override
    public void optimisedRenderBase(Rectangle bounds, int mouseX, int mouseY, float delta) {
        if (!isEmpty() && get(Settings.RENDER).get()) {
            class_1799 stack = getItemStack();
            ((ItemStackHook) (Object) stack).rei_setRenderEnchantmentGlint(get(Settings.Item.RENDER_ENCHANTMENT_GLINT).get());
            MATRICES.method_22903();
            MATRICES.method_22904(bounds.getCenterX(), bounds.getCenterY(), 100.0F + getZ());
            MATRICES.method_22905(bounds.getWidth(), (bounds.getWidth() + bounds.getHeight()) / -2f, bounds.getHeight());
            class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
            class_1087 model = getModelFromStack(stack);
            boolean bl = !IS_SIDE_LIT.test(model);
            if (bl)
                class_4493.method_24221();
            class_310.method_1551().method_1480().method_23179(stack, class_809.class_811.field_4317, false, MATRICES, immediate, 15728880, class_4608.field_21444, model);
            immediate.method_22993();
            if (bl)
                class_4493.method_24222();
            MATRICES.method_22909();
            ((ItemStackHook) (Object) stack).rei_setRenderEnchantmentGlint(false);
        }
    }
    
    @Override
    public void optimisedRenderOverlay(Rectangle bounds, int mouseX, int mouseY, float delta) {
        if (!isEmpty() && get(Settings.RENDER).get()) {
            class_310.method_1551().method_1480().field_4730 = getZ();
            class_310.method_1551().method_1480().method_4022(class_310.method_1551().field_1772, getItemStack(), bounds.x, bounds.y, get(Settings.RENDER_COUNTS).get() ? get(Settings.COUNTS).apply(this) : "");
            class_310.method_1551().method_1480().field_4730 = 0.0F;
        }
    }
}
