/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.RecipeDisplayExporter;
import me.shedaniel.rei.gui.RecipeScreen;
import me.shedaniel.rei.gui.widget.AutoCraftingButtonWidget;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.CategoryBaseWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.PanelWidget;
import me.shedaniel.rei.gui.widget.RecipeChoosePageWidget;
import me.shedaniel.rei.gui.widget.SlotBaseWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ClientHelperImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class RecipeViewingScreen
extends class_437
implements RecipeScreen {
    public static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private final List<Widget> preWidgets = Lists.newArrayList();
    private final List<Widget> widgets = Lists.newArrayList();
    private final Map<Rectangle, List<Widget>> recipeBounds = Maps.newHashMap();
    private final List<TabWidget> tabs = Lists.newArrayList();
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoriesMap;
    private final List<RecipeCategory<?>> categories;
    private final RecipeCategory<RecipeDisplay> selectedCategory;
    public int guiWidth;
    public int guiHeight;
    public int page;
    public int categoryPages = -1;
    public int largestWidth;
    public int largestHeight;
    public boolean choosePageActivated = false;
    public RecipeChoosePageWidget recipeChoosePageWidget;
    private int tabsPerPage = 5;
    private Rectangle bounds;
    @Nullable
    private CategoryBaseWidget workingStationsBaseWidget;
    private ButtonWidget recipeBack;
    private ButtonWidget recipeNext;
    private ButtonWidget categoryBack;
    private ButtonWidget categoryNext;
    private EntryStack ingredientStackToNotice = EntryStack.empty();
    private EntryStack resultStackToNotice = EntryStack.empty();

    public RecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> categoriesMap, @Nullable class_2960 category) {
        super(class_333.field_18967);
        class_1041 window = class_310.method_1551().method_22683();
        this.bounds = new Rectangle(window.method_4486() / 2 - this.guiWidth / 2, window.method_4502() / 2 - this.guiHeight / 2, 176, 150);
        this.categoriesMap = categoriesMap;
        this.categories = Lists.newArrayList(categoriesMap.keySet());
        RecipeCategory<?> selected = this.categories.get(0);
        if (category != null) {
            for (RecipeCategory<?> recipeCategory : this.categories) {
                if (!recipeCategory.getIdentifier().equals((Object)category)) continue;
                selected = recipeCategory;
                break;
            }
        }
        this.selectedCategory = selected;
    }

    @ApiStatus.Internal
    static void transformIngredientNotice(List<Widget> setupDisplay, EntryStack noticeStack) {
        RecipeViewingScreen.transformNotice(1, setupDisplay, noticeStack);
    }

    @ApiStatus.Internal
    static void transformResultNotice(List<Widget> setupDisplay, EntryStack noticeStack) {
        RecipeViewingScreen.transformNotice(2, setupDisplay, noticeStack);
    }

    @Override
    public class_2960 getCurrentCategory() {
        return this.selectedCategory.getIdentifier();
    }

    @Override
    public void recalculateCategoryPage() {
        this.categoryPages = -1;
    }

    private static void transformNotice(int marker, List<Widget> setupDisplay, EntryStack noticeStack) {
        if (noticeStack.isEmpty()) {
            return;
        }
        for (Widget widget : setupDisplay) {
            EntryStack stack;
            EntryWidget entry;
            if (!(widget instanceof EntryWidget) || (entry = (EntryWidget)widget).getNoticeMark() != marker || entry.entries().size() <= 1 || (stack = CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(entry.entries(), noticeStack)) == null) continue;
            entry.clearStacks();
            entry.entry(stack);
        }
    }

    @Override
    @ApiStatus.Internal
    public void addIngredientStackToNotice(EntryStack stack) {
        this.ingredientStackToNotice = stack;
    }

    @Override
    @ApiStatus.Internal
    public void addResultStackToNotice(EntryStack stack) {
        this.resultStackToNotice = stack;
    }

    @Nullable
    public CategoryBaseWidget getWorkingStationsBaseWidget() {
        return this.workingStationsBaseWidget;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 256 && this.choosePageActivated) {
            this.choosePageActivated = false;
            this.init();
            return true;
        }
        if (int_1 == 258) {
            boolean boolean_1;
            boolean bl = boolean_1 = !RecipeViewingScreen.hasShiftDown();
            if (!this.changeFocus(boolean_1)) {
                this.changeFocus(boolean_1);
            }
            return true;
        }
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.keyPressed(int_1, int_2, int_3);
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(int_1, int_2)) {
            if (this.recipeNext.enabled) {
                this.recipeNext.onPressed();
            }
            return this.recipeNext.enabled;
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(int_1, int_2)) {
            if (this.recipeBack.enabled) {
                this.recipeBack.onPressed();
            }
            return this.recipeBack.enabled;
        }
        for (class_364 element : this.children()) {
            if (!element.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        if (int_1 == 256 || this.minecraft.field_1690.field_1822.method_1417(int_1, int_2)) {
            class_310.method_1551().method_1507(ScreenHelper.getLastContainerScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (int_1 == 259) {
            if (ScreenHelper.hasLastRecipeScreen()) {
                this.minecraft.method_1507(ScreenHelper.getLastRecipeScreen());
            } else {
                this.minecraft.method_1507(ScreenHelper.getLastContainerScreen());
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        boolean isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        int tabSize = isCompactTabs ? 24 : 28;
        this.children.clear();
        this.recipeBounds.clear();
        this.tabs.clear();
        this.preWidgets.clear();
        this.widgets.clear();
        this.largestWidth = this.width - 100;
        this.largestHeight = Math.max(this.height - 36, 100);
        int maxWidthDisplay = CollectionUtils.mapAndMax(this.getCurrentDisplayed(), this.selectedCategory::getDisplayWidth, Comparator.naturalOrder()).orElse(150);
        this.guiWidth = maxWidthDisplay + 20;
        this.guiHeight = class_3532.method_15357((double)class_3532.method_15350((double)((double)(this.selectedCategory.getDisplayHeight() + 4) * (double)(this.getRecipesPerPage() + 1) + 36.0), (double)100.0, (double)this.largestHeight));
        this.tabsPerPage = Math.max(5, class_3532.method_15357((double)(((double)this.guiWidth - 20.0) / (double)tabSize)));
        if (this.categoryPages == -1) {
            this.categoryPages = Math.max(0, this.categories.indexOf(this.selectedCategory) / this.tabsPerPage);
        }
        this.bounds = new Rectangle(this.width / 2 - this.guiWidth / 2, this.height / 2 - this.guiHeight / 2, this.guiWidth, this.guiHeight);
        this.page = class_3532.method_15340((int)this.page, (int)0, (int)(this.getTotalPages(this.selectedCategory) - 1));
        ButtonWidget w = new ButtonWidget(new Rectangle(this.bounds.x + 2, this.bounds.y - 16, 10, 10), class_1074.method_4662((String)"text.rei.left_arrow", (Object[])new Object[0])){

            @Override
            public void onPressed() {
                --RecipeViewingScreen.this.categoryPages;
                if (RecipeViewingScreen.this.categoryPages < 0) {
                    RecipeViewingScreen.this.categoryPages = class_3532.method_15386((float)((float)RecipeViewingScreen.this.categories.size() / (float)RecipeViewingScreen.this.tabsPerPage)) - 1;
                }
                RecipeViewingScreen.this.init();
            }
        };
        this.widgets.add(w);
        ButtonWidget w2 = new ButtonWidget(new Rectangle(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10), class_1074.method_4662((String)"text.rei.right_arrow", (Object[])new Object[0])){

            @Override
            public void onPressed() {
                ++RecipeViewingScreen.this.categoryPages;
                if (RecipeViewingScreen.this.categoryPages > class_3532.method_15386((float)((float)RecipeViewingScreen.this.categories.size() / (float)RecipeViewingScreen.this.tabsPerPage)) - 1) {
                    RecipeViewingScreen.this.categoryPages = 0;
                }
                RecipeViewingScreen.this.init();
            }
        };
        this.widgets.add(w2);
        w2.enabled = this.categories.size() > this.tabsPerPage;
        w.enabled = w2.enabled;
        this.categoryBack = new ButtonWidget(new Rectangle(this.bounds.getX() + 5, this.bounds.getY() + 5, 12, 12), class_1074.method_4662((String)"text.rei.left_arrow", (Object[])new Object[0])){

            @Override
            public void onPressed() {
                int currentCategoryIndex = RecipeViewingScreen.this.categories.indexOf(RecipeViewingScreen.this.selectedCategory);
                if (--currentCategoryIndex < 0) {
                    currentCategoryIndex = RecipeViewingScreen.this.categories.size() - 1;
                }
                ClientHelperImpl.getInstance().openRecipeViewingScreen(RecipeViewingScreen.this.categoriesMap, ((RecipeCategory)RecipeViewingScreen.this.categories.get(currentCategoryIndex)).getIdentifier(), RecipeViewingScreen.this.ingredientStackToNotice, RecipeViewingScreen.this.resultStackToNotice);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.previous_category", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.categoryBack);
        this.widgets.add(new ClickableLabelWidget(new Point(this.bounds.getCenterX(), this.bounds.getY() + 7), ""){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                this.setText(RecipeViewingScreen.this.selectedCategory.getCategoryName());
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.view_all_categories", (Object[])new Object[0]));
            }

            @Override
            public void onLabelClicked() {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                ClientHelper.getInstance().executeViewAllRecipesKeyBind();
            }
        });
        this.categoryNext = new ButtonWidget(new Rectangle(this.bounds.getMaxX() - 17, this.bounds.getY() + 5, 12, 12), class_1074.method_4662((String)"text.rei.right_arrow", (Object[])new Object[0])){

            @Override
            public void onPressed() {
                int currentCategoryIndex = RecipeViewingScreen.this.categories.indexOf(RecipeViewingScreen.this.selectedCategory);
                if (++currentCategoryIndex >= RecipeViewingScreen.this.categories.size()) {
                    currentCategoryIndex = 0;
                }
                ClientHelperImpl.getInstance().openRecipeViewingScreen(RecipeViewingScreen.this.categoriesMap, ((RecipeCategory)RecipeViewingScreen.this.categories.get(currentCategoryIndex)).getIdentifier(), RecipeViewingScreen.this.ingredientStackToNotice, RecipeViewingScreen.this.resultStackToNotice);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.next_category", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.categoryNext);
        this.categoryBack.enabled = this.categories.size() > 1;
        this.categoryNext.enabled = this.categories.size() > 1;
        this.recipeBack = new ButtonWidget(new Rectangle(this.bounds.getX() + 5, this.bounds.getY() + 19, 12, 12), class_1074.method_4662((String)"text.rei.left_arrow", (Object[])new Object[0])){

            @Override
            public void onPressed() {
                --RecipeViewingScreen.this.page;
                if (RecipeViewingScreen.this.page < 0) {
                    RecipeViewingScreen.this.page = RecipeViewingScreen.this.getTotalPages(RecipeViewingScreen.this.selectedCategory) - 1;
                }
                RecipeViewingScreen.this.init();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.previous_page", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.recipeBack);
        this.widgets.add(new ClickableLabelWidget(new Point(this.bounds.getCenterX(), this.bounds.getY() + 21), ""){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                this.setText(String.format("%d/%d", RecipeViewingScreen.this.page + 1, RecipeViewingScreen.this.getTotalPages(RecipeViewingScreen.this.selectedCategory)));
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.choose_page", (Object[])new Object[0]));
            }

            @Override
            public void onLabelClicked() {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                RecipeViewingScreen.this.choosePageActivated = true;
                RecipeViewingScreen.this.init();
            }
        }.clickable(this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPageByHeight()));
        this.recipeNext = new ButtonWidget(new Rectangle(this.bounds.getMaxX() - 17, this.bounds.getY() + 19, 12, 12), class_1074.method_4662((String)"text.rei.right_arrow", (Object[])new Object[0])){

            @Override
            public void onPressed() {
                ++RecipeViewingScreen.this.page;
                if (RecipeViewingScreen.this.page >= RecipeViewingScreen.this.getTotalPages(RecipeViewingScreen.this.selectedCategory)) {
                    RecipeViewingScreen.this.page = 0;
                }
                RecipeViewingScreen.this.init();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.next_page", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.recipeNext);
        this.recipeNext.enabled = this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPageByHeight();
        this.recipeBack.enabled = this.recipeNext.enabled;
        int tabV = isCompactTabs ? 166 : 192;
        for (int i = 0; i < this.tabsPerPage; ++i) {
            int j = i + this.categoryPages * this.tabsPerPage;
            if (this.categories.size() <= j) continue;
            final RecipeCategory<?> tabCategory = this.categories.get(j);
            TabWidget tab = new TabWidget(i, tabSize, this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.categoryPages * this.tabsPerPage, this.tabsPerPage) * tabSize / 2, this.bounds.y, 0, tabV){

                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.containsMouse(mouseX, mouseY)) {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        if (this.selected) {
                            return false;
                        }
                        ClientHelperImpl.getInstance().openRecipeViewingScreen(RecipeViewingScreen.this.categoriesMap, tabCategory.getIdentifier(), RecipeViewingScreen.this.ingredientStackToNotice, RecipeViewingScreen.this.resultStackToNotice);
                        return true;
                    }
                    return false;
                }
            };
            this.tabs.add(tab);
            tab.setRenderer(this.categories.get(j), this.categories.get(j).getLogo(), this.categories.get(j).getCategoryName(), j == this.categories.indexOf(this.selectedCategory));
        }
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getAutoCraftButtonArea(this.selectedCategory);
        int recipeHeight = this.selectedCategory.getDisplayHeight();
        List<RecipeDisplay> currentDisplayed = this.getCurrentDisplayed();
        for (int i = 0; i < currentDisplayed.size(); ++i) {
            RecipeDisplay display = currentDisplayed.get(i);
            Supplier<RecipeDisplay> displaySupplier = () -> display;
            int displayWidth = this.selectedCategory.getDisplayWidth(displaySupplier.get());
            Rectangle displayBounds = new Rectangle(this.getBounds().getCenterX() - displayWidth / 2, this.getBounds().y - 2 + 36 + recipeHeight * i + 4 * i, displayWidth, recipeHeight);
            List<Widget> setupDisplay = this.selectedCategory.setupDisplay(displaySupplier, displayBounds);
            RecipeViewingScreen.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
            RecipeViewingScreen.transformResultNotice(setupDisplay, this.resultStackToNotice);
            this.recipeBounds.put(displayBounds, setupDisplay);
            this.widgets.addAll(setupDisplay);
            if (!supplier.isPresent() || supplier.get().get(displayBounds) == null) continue;
            this.widgets.add(new AutoCraftingButtonWidget(displayBounds, supplier.get().get(displayBounds), supplier.get().getButtonText(), displaySupplier, setupDisplay, this.selectedCategory));
        }
        this.recipeChoosePageWidget = this.choosePageActivated ? new RecipeChoosePageWidget(this, this.page, this.getTotalPages(this.selectedCategory)) : null;
        this.workingStationsBaseWidget = null;
        List<List<EntryStack>> workingStations = RecipeHelper.getInstance().getWorkingStations(this.selectedCategory.getIdentifier());
        if (!workingStations.isEmpty()) {
            int hh = class_3532.method_15375((float)((float)(this.bounds.height - 16) / 18.0f));
            int actualHeight = Math.min(hh, workingStations.size());
            int innerWidth = class_3532.method_15386((float)((float)workingStations.size() / (float)hh));
            int xx = this.bounds.x - (8 + innerWidth * 16) + 6;
            int yy = this.bounds.y + 16;
            this.workingStationsBaseWidget = new CategoryBaseWidget(new Rectangle(xx - 5, yy - 5, 15 + innerWidth * 16, 10 + actualHeight * 16));
            this.preWidgets.add(this.workingStationsBaseWidget);
            this.preWidgets.add(new SlotBaseWidget(new Rectangle(xx - 1, yy - 1, innerWidth * 16 + 2, actualHeight * 16 + 2)));
            int index = 0;
            List<String> list = Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662((String)"text.rei.working_station", (Object[])new Object[0]));
            xx += (innerWidth - 1) * 16;
            for (List<EntryStack> workingStation : workingStations) {
                this.preWidgets.add(new WorkstationSlotWidget(xx, yy, CollectionUtils.map(workingStation, stack -> stack.copy().setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> list))));
                yy += 16;
                if (++index < hh) continue;
                index = 0;
                yy = this.bounds.y + 16;
                xx -= 16;
            }
        }
        this.children.addAll(this.tabs);
        this.children.add(ScreenHelper.getLastOverlay(true, false));
        this.children.addAll(this.widgets);
        this.children.addAll(this.preWidgets);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public List<RecipeDisplay> getCurrentDisplayed() {
        ArrayList list = Lists.newArrayList();
        int recipesPerPage = this.getRecipesPerPage();
        for (int i = 0; i <= recipesPerPage; ++i) {
            if (this.page * (recipesPerPage + 1) + i >= this.categoriesMap.get(this.selectedCategory).size()) continue;
            list.add(this.categoriesMap.get(this.selectedCategory).get(this.page * (recipesPerPage + 1) + i));
        }
        return list;
    }

    public RecipeCategory<RecipeDisplay> getSelectedCategory() {
        return this.selectedCategory;
    }

    public int getPage() {
        return this.page;
    }

    public int getCategoryPage() {
        return this.categoryPages;
    }

    private int getRecipesPerPage() {
        if (this.selectedCategory.getFixedRecipesPerPage() > 0) {
            return this.selectedCategory.getFixedRecipesPerPage() - 1;
        }
        int height = this.selectedCategory.getDisplayHeight();
        return class_3532.method_15340((int)(class_3532.method_15357((double)(((double)this.largestHeight - 36.0) / ((double)height + 4.0))) - 1), (int)0, (int)Math.min(ConfigObject.getInstance().getMaxRecipePerPage() - 1, this.selectedCategory.getMaximumRecipePerPage() - 1));
    }

    private int getRecipesPerPageByHeight() {
        int height = this.selectedCategory.getDisplayHeight();
        return class_3532.method_15340((int)class_3532.method_15357((double)(((double)this.guiHeight - 36.0) / ((double)height + 4.0))), (int)0, (int)Math.min(ConfigObject.getInstance().getMaxRecipePerPage() - 1, this.selectedCategory.getMaximumRecipePerPage() - 1));
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        for (Widget widget : this.preWidgets) {
            widget.render(mouseX, mouseY, delta);
        }
        if (this.selectedCategory != null) {
            this.selectedCategory.drawCategoryBackground(this.bounds, mouseX, mouseY, delta);
        } else {
            PanelWidget.render(this.bounds, -1);
            if (ScreenHelper.isDarkModeEnabled()) {
                RecipeViewingScreen.fill((int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-12566464);
                RecipeViewingScreen.fill((int)(this.bounds.x + 17), (int)(this.bounds.y + 19), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 30), (int)-12566464);
            } else {
                RecipeViewingScreen.fill((int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-6381922);
                RecipeViewingScreen.fill((int)(this.bounds.x + 17), (int)(this.bounds.y + 19), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 31), (int)-6381922);
            }
        }
        for (TabWidget tab : this.tabs) {
            if (tab.isSelected()) continue;
            tab.render(mouseX, mouseY, delta);
        }
        super.render(mouseX, mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.render(mouseX, mouseY, delta);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (TabWidget tab : this.tabs) {
            if (!tab.isSelected()) continue;
            tab.render(mouseX, mouseY, delta);
        }
        ScreenHelper.getLastOverlay().render(mouseX, mouseY, delta);
        ScreenHelper.getLastOverlay().lateRender(mouseX, mouseY, delta);
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesCurrentKey()) {
            for (Map.Entry<Rectangle, List<Widget>> entry : this.recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                this.setBlitOffset(470);
                if (bounds.contains(mouseX, mouseY)) {
                    this.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 1744822402, 1744822402);
                    String s = class_1074.method_4662((String)"text.rei.release_export", (Object[])new Object[]{export.getLocalizedName()});
                    class_4587 matrices = new class_4587();
                    class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                    matrices.method_22904(0.0, 0.0, 480.0);
                    class_1159 matrix = matrices.method_23760().method_23761();
                    this.font.method_22942(s, (float)bounds.getCenterX() - (float)this.font.method_1727(s) / 2.0f, (float)bounds.getCenterY() - 4.5f, -16777216, false, matrix, (class_4597)immediate, false, 0, 0xF000F0);
                    immediate.method_22993();
                } else {
                    this.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 0x67FFFFFF, 0x67FFFFFF);
                }
                this.setBlitOffset(0);
            }
        }
        if (this.choosePageActivated) {
            this.setBlitOffset(500);
            this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
            this.setBlitOffset(0);
            this.recipeChoosePageWidget.render(mouseX, mouseY, delta);
        }
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesKey(keyCode, scanCode)) {
            for (Map.Entry<Rectangle, List<Widget>> entry : this.recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                if (!bounds.contains(PointHelper.fromMouse())) continue;
                RecipeDisplayExporter.exportRecipeDisplay(bounds, entry.getValue());
                break;
            }
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public int getTotalPages(RecipeCategory<RecipeDisplay> category) {
        return class_3532.method_15384((double)((double)this.categoriesMap.get(category).size() / (double)(this.getRecipesPerPage() + 1)));
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean charTyped(char char_1, int int_1) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.charTyped(char_1, int_1);
        }
        for (class_364 listener : this.children()) {
            if (!listener.charTyped(char_1, int_1)) continue;
            return true;
        }
        return super.charTyped(char_1, int_1);
    }

    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.mouseDragged(double_1, double_2, int_1, double_3, double_4);
        }
        return super.mouseDragged(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean mouseReleased(double double_1, double double_2, int int_1) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.mouseReleased(double_1, double_2, int_1);
        }
        return super.mouseReleased(double_1, double_2, int_1);
    }

    public boolean mouseScrolled(double i, double j, double amount) {
        for (class_364 listener : this.children()) {
            if (!listener.mouseScrolled(i, j, amount)) continue;
            return true;
        }
        if (this.getBounds().contains(PointHelper.fromMouse())) {
            if (amount > 0.0 && this.recipeBack.enabled) {
                this.recipeBack.onPressed();
            } else if (amount < 0.0 && this.recipeNext.enabled) {
                this.recipeNext.onPressed();
            }
        }
        if (new Rectangle(this.bounds.x, this.bounds.y - 28, this.bounds.width, 28).contains(PointHelper.fromMouse())) {
            if (amount > 0.0 && this.categoryBack.enabled) {
                this.categoryBack.onPressed();
            } else if (amount < 0.0 && this.categoryNext.enabled) {
                this.categoryNext.onPressed();
            }
        }
        return super.mouseScrolled(i, j, amount);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.choosePageActivated) {
            if (this.recipeChoosePageWidget.containsMouse(double_1, double_2)) {
                return this.recipeChoosePageWidget.mouseClicked(double_1, double_2, int_1);
            }
            this.choosePageActivated = false;
            this.init();
            return false;
        }
        for (class_364 entry : this.children()) {
            if (!entry.mouseClicked(double_1, double_2, int_1)) continue;
            this.setFocused(entry);
            if (int_1 == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public class_364 getFocused() {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget;
        }
        return super.getFocused();
    }

    public static class WorkstationSlotWidget
    extends EntryWidget {
        public WorkstationSlotWidget(int x, int y, List<EntryStack> widgets) {
            super(new Point(x, y));
            this.entries(widgets);
            this.noBackground();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.getInnerBounds().contains(mouseX, mouseY);
        }
    }
}

