/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.RecipeScreen;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.widget.AutoCraftingButtonWidget;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.CategoryBaseWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.ScrollingContainer;
import me.shedaniel.rei.gui.widget.SlotBaseWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ClientHelperImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class VillagerRecipeViewingScreen
extends class_437
implements RecipeScreen {
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoryMap;
    private final List<RecipeCategory<?>> categories;
    private final List<Widget> widgets = Lists.newArrayList();
    private final List<ButtonWidget> buttonWidgets = Lists.newArrayList();
    private final List<RecipeEntry> recipeRenderers = Lists.newArrayList();
    private final List<TabWidget> tabs = Lists.newArrayList();
    public Rectangle bounds;
    public Rectangle scrollListBounds;
    private int tabsPerPage = 8;
    private int selectedCategoryIndex = 0;
    private int selectedRecipeIndex = 0;
    private final ScrollingContainer scrolling = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(VillagerRecipeViewingScreen.this.scrollListBounds.x + 1, VillagerRecipeViewingScreen.this.scrollListBounds.y + 1, VillagerRecipeViewingScreen.this.scrollListBounds.width - 2, VillagerRecipeViewingScreen.this.scrollListBounds.height - 2);
        }

        @Override
        public int getMaxScrollHeight() {
            int i = 0;
            for (ButtonWidget button : VillagerRecipeViewingScreen.this.buttonWidgets) {
                i += button.getBounds().height;
            }
            return i;
        }
    };
    private float scrollBarAlpha = 0.0f;
    private float scrollBarAlphaFuture = 0.0f;
    private long scrollBarAlphaFutureTime = -1L;
    private int tabsPage = -1;
    private EntryStack ingredientStackToNotice = EntryStack.empty();
    private EntryStack resultStackToNotice = EntryStack.empty();

    public VillagerRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> categoryMap, @Nullable class_2960 category) {
        super(class_333.field_18967);
        this.categoryMap = categoryMap;
        this.categories = Lists.newArrayList(categoryMap.keySet());
        if (category != null) {
            for (int i = 0; i < this.categories.size(); ++i) {
                if (!this.categories.get(i).getIdentifier().equals((Object)category)) continue;
                this.selectedCategoryIndex = i;
                break;
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void addIngredientStackToNotice(EntryStack stack) {
        this.ingredientStackToNotice = stack;
    }

    @Override
    public void addResultStackToNotice(EntryStack stack) {
        this.resultStackToNotice = stack;
    }

    @Override
    public class_2960 getCurrentCategory() {
        return this.categories.get(this.selectedCategoryIndex).getIdentifier();
    }

    @Override
    public void recalculateCategoryPage() {
        this.tabsPage = -1;
    }

    protected void init() {
        super.init();
        boolean isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        int tabSize = isCompactTabs ? 24 : 28;
        this.scrolling.draggingScrollBar = false;
        this.children.clear();
        this.widgets.clear();
        this.buttonWidgets.clear();
        this.recipeRenderers.clear();
        this.tabs.clear();
        int largestWidth = this.width - 100;
        int largestHeight = this.height - 40;
        RecipeCategory<?> category = this.categories.get(this.selectedCategoryIndex);
        RecipeDisplay display = this.categoryMap.get(category).get(this.selectedRecipeIndex);
        int guiWidth = class_3532.method_15340((int)(category.getDisplayWidth(display) + 30), (int)0, (int)largestWidth) + 100;
        int guiHeight = class_3532.method_15340((int)(category.getDisplayHeight() + 40), (int)166, (int)largestHeight);
        this.tabsPerPage = Math.max(5, class_3532.method_15357((double)(((double)guiWidth - 20.0) / (double)tabSize)));
        if (this.tabsPage == -1) {
            this.tabsPage = this.selectedCategoryIndex / this.tabsPerPage;
        }
        this.bounds = new Rectangle(this.width / 2 - guiWidth / 2, this.height / 2 - guiHeight / 2, guiWidth, guiHeight);
        List<List<EntryStack>> workingStations = RecipeHelper.getInstance().getWorkingStations(category.getIdentifier());
        if (!workingStations.isEmpty()) {
            int ww = class_3532.method_15375((float)((float)(this.bounds.width - 16) / 18.0f));
            int w = Math.min(ww, workingStations.size());
            int h = class_3532.method_15386((float)((float)workingStations.size() / (float)ww));
            int xx = this.bounds.x + 16;
            int yy = this.bounds.y + this.bounds.height + 2;
            this.widgets.add(new CategoryBaseWidget(new Rectangle(xx - 5, this.bounds.y + this.bounds.height - 5, 10 + w * 16, 12 + h * 16)));
            this.widgets.add(new SlotBaseWidget(new Rectangle(xx - 1, yy - 1, 2 + w * 16, 2 + h * 16)));
            int index = 0;
            List<String> list = Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662((String)"text.rei.working_station", (Object[])new Object[0]));
            for (List<EntryStack> workingStation : workingStations) {
                this.widgets.add(new RecipeViewingScreen.WorkstationSlotWidget(xx, yy, CollectionUtils.map(workingStation, stack -> stack.copy().setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> list))));
                xx += 16;
                if (++index < ww) continue;
                index = 0;
                xx = this.bounds.x + 16;
                yy += 16;
            }
        }
        this.widgets.add(new CategoryBaseWidget(this.bounds));
        this.scrollListBounds = new Rectangle(this.bounds.x + 4, this.bounds.y + 17, 102, guiHeight - 17 - 7);
        this.widgets.add(new SlotBaseWidget(this.scrollListBounds));
        Rectangle recipeBounds = new Rectangle(this.bounds.x + 100 + (guiWidth - 100) / 2 - category.getDisplayWidth(display) / 2, this.bounds.y + this.bounds.height / 2 - category.getDisplayHeight() / 2, category.getDisplayWidth(display), category.getDisplayHeight());
        List<Widget> setupDisplay = category.setupDisplay(() -> display, recipeBounds);
        RecipeViewingScreen.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
        RecipeViewingScreen.transformResultNotice(setupDisplay, this.resultStackToNotice);
        this.widgets.addAll(setupDisplay);
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getAutoCraftButtonArea(category);
        if (supplier.isPresent() && supplier.get().get(recipeBounds) != null) {
            this.widgets.add(new AutoCraftingButtonWidget(recipeBounds, supplier.get().get(recipeBounds), supplier.get().getButtonText(), () -> display, setupDisplay, category));
        }
        int index = 0;
        for (RecipeDisplay recipeDisplay : this.categoryMap.get(category)) {
            final int finalIndex = index++;
            RecipeEntry recipeEntry = category.getSimpleRenderer(recipeDisplay);
            this.recipeRenderers.add(recipeEntry);
            this.buttonWidgets.add(new ButtonWidget(new Rectangle(this.bounds.x + 5, 0, recipeEntry.getWidth(), recipeEntry.getHeight()), ""){

                @Override
                public void onPressed() {
                    VillagerRecipeViewingScreen.this.selectedRecipeIndex = finalIndex;
                    VillagerRecipeViewingScreen.this.init();
                }

                @Override
                public boolean isHovered(int mouseX, int mouseY) {
                    return this.isMouseOver(mouseX, mouseY) && VillagerRecipeViewingScreen.this.scrollListBounds.contains(mouseX, mouseY) || this.focused;
                }

                @Override
                protected int getTextureId(boolean boolean_1) {
                    this.enabled = VillagerRecipeViewingScreen.this.selectedRecipeIndex != finalIndex;
                    return super.getTextureId(boolean_1);
                }

                @Override
                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.isMouseOver(mouseX, mouseY) && VillagerRecipeViewingScreen.this.scrollListBounds.contains(mouseX, mouseY) && this.enabled && button == 0) {
                        this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        this.onPressed();
                        return true;
                    }
                    return false;
                }
            });
        }
        int tabV = isCompactTabs ? 166 : 192;
        for (int i = 0; i < this.tabsPerPage; ++i) {
            int j = i + this.tabsPage * this.tabsPerPage;
            if (this.categories.size() <= j) continue;
            final RecipeCategory<?> tabCategory = this.categories.get(j);
            TabWidget tab = new TabWidget(i, tabSize, this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.tabsPage * this.tabsPerPage, this.tabsPerPage) * tabSize / 2, this.bounds.y, 0, tabV){

                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.containsMouse(mouseX, mouseY)) {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        if (this.selected) {
                            return false;
                        }
                        ClientHelperImpl.getInstance().openRecipeViewingScreen(VillagerRecipeViewingScreen.this.categoryMap, tabCategory.getIdentifier(), VillagerRecipeViewingScreen.this.ingredientStackToNotice, VillagerRecipeViewingScreen.this.resultStackToNotice);
                        return true;
                    }
                    return false;
                }
            };
            this.tabs.add(tab);
            tab.setRenderer(this.categories.get(j), this.categories.get(j).getLogo(), this.categories.get(j).getCategoryName(), j == this.selectedCategoryIndex);
        }
        ButtonWidget w = new ButtonWidget(new Rectangle(this.bounds.x + 2, this.bounds.y - 16, 10, 10), (class_2561)new class_2588("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                VillagerRecipeViewingScreen.this.tabsPage--;
                if (VillagerRecipeViewingScreen.this.tabsPage < 0) {
                    VillagerRecipeViewingScreen.this.tabsPage = class_3532.method_15386((float)((float)VillagerRecipeViewingScreen.this.categories.size() / (float)VillagerRecipeViewingScreen.this.tabsPerPage)) - 1;
                }
                VillagerRecipeViewingScreen.this.init();
            }
        };
        this.widgets.add(w);
        ButtonWidget w2 = new ButtonWidget(new Rectangle(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10), (class_2561)new class_2588("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                VillagerRecipeViewingScreen.this.tabsPage++;
                if (VillagerRecipeViewingScreen.this.tabsPage > class_3532.method_15386((float)((float)VillagerRecipeViewingScreen.this.categories.size() / (float)VillagerRecipeViewingScreen.this.tabsPerPage)) - 1) {
                    VillagerRecipeViewingScreen.this.tabsPage = 0;
                }
                VillagerRecipeViewingScreen.this.init();
            }
        };
        this.widgets.add(w2);
        w2.enabled = this.categories.size() > this.tabsPerPage;
        w.enabled = w2.enabled;
        this.widgets.add(new ClickableLabelWidget(new Point(this.bounds.x + 4 + this.scrollListBounds.width / 2, this.bounds.y + 6), this.categories.get(this.selectedCategoryIndex).getCategoryName()){

            @Override
            public void onLabelClicked() {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                ClientHelper.getInstance().executeViewAllRecipesKeyBind();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.view_all_categories", (Object[])new Object[0]));
            }
        });
        this.children.addAll(this.buttonWidgets);
        this.widgets.addAll(this.tabs);
        this.children.addAll(this.widgets);
        this.children.add(ScreenHelper.getLastOverlay(true, false));
        ScreenHelper.getLastOverlay().init();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int int_1) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, int_1)) {
            this.scrollBarAlpha = 1.0f;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, int_1);
    }

    public boolean charTyped(char char_1, int int_1) {
        for (class_364 listener : this.children()) {
            if (!listener.charTyped(char_1, int_1)) continue;
            return true;
        }
        return super.charTyped(char_1, int_1);
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        double height = this.scrolling.getMaxScrollHeight();
        if (this.scrollListBounds.contains(double_1, double_2) && height > (double)(this.scrollListBounds.height - 2)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlphaFuture = 1.0f;
            }
            if ((float)(System.currentTimeMillis() - this.scrollBarAlphaFutureTime) > 300.0f) {
                this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            }
            return true;
        }
        for (class_364 listener : this.children()) {
            if (!listener.mouseScrolled(double_1, double_2, double_3)) continue;
            return true;
        }
        if (this.bounds.contains(PointHelper.ofMouse())) {
            if (double_3 < 0.0 && this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.init();
            } else if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.init();
                return true;
            }
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    public void render(int mouseX, int mouseY, float delta) {
        if (ConfigObject.getInstance().doesVillagerScreenHavePermanentScrollBar()) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 0.0f;
            this.scrollBarAlpha = 1.0f;
        } else if (this.scrollBarAlphaFutureTime > 0L) {
            long l = System.currentTimeMillis() - this.scrollBarAlphaFutureTime;
            if ((float)l > 300.0f) {
                if (this.scrollBarAlphaFutureTime == 0L) {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                    this.scrollBarAlphaFutureTime = -1L;
                } else if ((float)l > 2000.0f && this.scrollBarAlphaFuture == 1.0f) {
                    this.scrollBarAlphaFuture = 0.0f;
                    this.scrollBarAlphaFutureTime = System.currentTimeMillis();
                } else {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                }
            } else if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlpha = Math.min(this.scrollBarAlpha, 1.0f - Math.min(1.0f, (float)l / 300.0f));
            } else if (this.scrollBarAlphaFuture == 1.0f) {
                this.scrollBarAlpha = Math.max(Math.min(1.0f, (float)l / 300.0f), this.scrollBarAlpha);
            }
        }
        this.scrolling.updatePosition(delta);
        this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        int yOffset = 0;
        for (Widget widget : this.widgets) {
            widget.render(mouseX, mouseY, delta);
        }
        ScreenHelper.getLastOverlay().render(mouseX, mouseY, delta);
        RenderSystem.pushMatrix();
        ScissorsHandler.INSTANCE.scissor(this.scrolling.getBounds());
        for (ButtonWidget button : this.buttonWidgets) {
            button.getBounds().y = this.scrollListBounds.y + 1 + yOffset - (int)this.scrolling.scrollAmount;
            if (button.getBounds().getMaxY() > this.scrollListBounds.getMinY() && button.getBounds().getMinY() < this.scrollListBounds.getMaxY()) {
                button.render(mouseX, mouseY, delta);
            }
            yOffset += button.getBounds().height;
        }
        for (int i = 0; i < this.buttonWidgets.size(); ++i) {
            if (this.buttonWidgets.get(i).getBounds().getMaxY() <= this.scrollListBounds.getMinY() || this.buttonWidgets.get(i).getBounds().getMinY() >= this.scrollListBounds.getMaxY()) continue;
            this.recipeRenderers.get(i).setZ(1);
            this.recipeRenderers.get(i).render(this.buttonWidgets.get(i).getBounds(), mouseX, mouseY, delta);
            ScreenHelper.getLastOverlay().addTooltip(this.recipeRenderers.get(i).getTooltip(mouseX, mouseY));
        }
        this.scrolling.renderScrollBar(0, this.scrollBarAlpha);
        ScissorsHandler.INSTANCE.removeLastScissor();
        RenderSystem.popMatrix();
        ScreenHelper.getLastOverlay().lateRender(mouseX, mouseY, delta);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, int_1, double_3, double_4)) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 1.0f;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 258) {
            boolean boolean_1;
            boolean bl = boolean_1 = !VillagerRecipeViewingScreen.hasShiftDown();
            if (!this.changeFocus(boolean_1)) {
                this.changeFocus(boolean_1);
            }
            return true;
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.init();
                return true;
            }
            return false;
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.init();
                return true;
            }
            return false;
        }
        for (class_364 element : this.children()) {
            if (!element.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        if (int_1 == 256 || this.minecraft.field_1690.field_1822.method_1417(int_1, int_2)) {
            class_310.method_1551().method_1507(ScreenHelper.getLastContainerScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (int_1 == 259) {
            if (ScreenHelper.hasLastRecipeScreen()) {
                this.minecraft.method_1507(ScreenHelper.getLastRecipeScreen());
            } else {
                this.minecraft.method_1507(ScreenHelper.getLastContainerScreen());
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }
}

