/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.config.entry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.gui.OverlaySearchField;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.ScrollingContainer;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.SearchArgument;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FilteringEntry
extends AbstractConfigListEntry<List<EntryStack>> {
    protected List<EntryStack> selected = Lists.newArrayList();
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        @Override
        public int getMaxScrollHeight() {
            return class_3532.method_15386((float)((float)FilteringEntry.this.entryStacks.size() / ((float)((FilteringEntry)FilteringEntry.this).innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize() + 28;
        }

        @Override
        public Rectangle getBounds() {
            return FilteringEntry.this.getBounds();
        }

        @Override
        public int getScrollBarX() {
            return FilteringEntry.this.getParent().right - 7;
        }
    };
    private Consumer<List<EntryStack>> saveConsumer;
    private List<EntryStack> defaultValue;
    private List<EntryStack> configFiltered;
    private QueuedTooltip tooltip = null;
    private ClothConfigScreen.ListWidget lastList = null;
    private List<EntryStack> entryStacks = null;
    private Rectangle innerBounds;
    private List<EntryListEntry> entries = Collections.emptyList();
    private List<class_364> elements = Collections.emptyList();
    private Point selectionPoint = null;
    private Point secondPoint = null;
    private OverlaySearchField searchField;
    private class_4185 selectAllButton;
    private class_4185 selectNoneButton;
    private class_4185 hideButton;
    private class_4185 showButton;
    private List<SearchArgument.SearchArguments> lastSearchArguments = Collections.emptyList();

    public FilteringEntry(List<EntryStack> configFiltered, List<EntryStack> defaultValue, Consumer<List<EntryStack>> saveConsumer) {
        super("", false);
        this.configFiltered = configFiltered;
        this.defaultValue = defaultValue;
        this.saveConsumer = saveConsumer;
        this.searchField = new OverlaySearchField(0, 0, 0, 0);
        String selectAllText = class_1074.method_4662((String)"config.roughlyenoughitems.filteredEntries.selectAll", (Object[])new Object[0]);
        this.selectAllButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_1727(selectAllText) + 10, 20, selectAllText, button -> {
            this.selectionPoint = new Point(-1073741823, -1073741823);
            this.secondPoint = new Point(0x3FFFFFFF, 0x3FFFFFFF);
        });
        String selectNoneText = class_1074.method_4662((String)"config.roughlyenoughitems.filteredEntries.selectNone", (Object[])new Object[0]);
        this.selectNoneButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_1727(selectNoneText) + 10, 20, selectNoneText, button -> {
            this.selectionPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.secondPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        });
        String hideText = class_1074.method_4662((String)"config.roughlyenoughitems.filteredEntries.hide", (Object[])new Object[0]);
        this.hideButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_1727(hideText) + 10, 20, hideText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack stack = this.entryStacks.get(i);
                EntryListEntry entry = this.entries.get(i);
                entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
                if (!entry.isSelected() || entry.isFiltered()) continue;
                configFiltered.add(stack);
                this.getScreen().setEdited(true, false);
            }
        });
        String showText = class_1074.method_4662((String)"config.roughlyenoughitems.filteredEntries.show", (Object[])new Object[0]);
        this.showButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_1727(showText) + 10, 20, showText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack stack = this.entryStacks.get(i);
                EntryListEntry entry = this.entries.get(i);
                entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
                if (!entry.isSelected() || !configFiltered.remove(stack)) continue;
                this.getScreen().setEdited(true, false);
            }
        });
        this.searchField.isMain = false;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)(width * EntryListWidget.entrySize()) / 2.0f), bounds.y + 5, width * EntryListWidget.entrySize(), bounds.height);
    }

    public Rectangle getBounds() {
        ClothConfigScreen.ListWidget listWidget = this.getParent();
        return new Rectangle(listWidget.left, listWidget.top, listWidget.right - listWidget.left, listWidget.bottom - listWidget.top);
    }

    public List<EntryStack> getValue() {
        return this.configFiltered;
    }

    public Optional<List<EntryStack>> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    public void save() {
        this.saveConsumer.accept((List<EntryStack>)this.getValue());
    }

    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        int nextIndex;
        ClothConfigScreen.ListWidget parent = this.getParent();
        Rectangle bounds = this.getBounds();
        if (this.lastList != parent) {
            this.updateSearch(this.searchField.getText());
            this.lastList = parent;
            this.searchField.getBounds().setBounds(bounds.getCenterX() - 75, bounds.getMaxY() - 22, 150, 18);
            this.selectAllButton.x = 2;
            this.selectAllButton.y = bounds.getMaxY() - 22;
            this.selectNoneButton.x = 4 + this.selectAllButton.getWidth();
            this.selectNoneButton.y = bounds.getMaxY() - 22;
            this.hideButton.x = bounds.getMaxX() - this.hideButton.getWidth() - this.showButton.getWidth() - 4;
            this.hideButton.y = bounds.getMaxY() - 22;
            this.showButton.x = bounds.getMaxX() - this.showButton.getWidth() - 2;
            this.showButton.y = bounds.getMaxY() - 22;
            this.searchField.setChangedListener(this::updateSearch);
        }
        this.tooltip = null;
        if (bounds.isEmpty()) {
            return;
        }
        for (EntryListEntry entry : this.entries) {
            entry.clearStacks();
        }
        int skip = Math.max(0, class_3532.method_15357((double)(this.scrolling.scrollAmount / (double)EntryListWidget.entrySize())));
        for (int i = nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize(); i < this.entryStacks.size(); ++i) {
            EntryStack stack = this.entryStacks.get(i);
            EntryListEntry entry = this.entries.get(nextIndex);
            entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
            if (entry.getBounds().y > bounds.getMaxY()) break;
            entry.entry(stack);
            entry.render(mouseX, mouseY, delta);
            ++nextIndex;
        }
        this.updatePosition(delta);
        this.scrolling.renderScrollBar(-16777216, 1.0f);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)300.0f);
        this.searchField.laterRender(mouseX, mouseY, delta);
        this.selectAllButton.render(mouseX, mouseY, delta);
        this.selectNoneButton.render(mouseX, mouseY, delta);
        this.hideButton.render(mouseX, mouseY, delta);
        this.showButton.render(mouseX, mouseY, delta);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-300.0f);
        if (this.tooltip != null) {
            ScreenHelper.getLastOverlay().renderTooltip(this.tooltip);
        }
    }

    private Rectangle getSelection() {
        if (this.selectionPoint != null) {
            Point p = this.secondPoint;
            if (p == null) {
                p = PointHelper.fromMouse();
                p.translate(0, (int)this.scrolling.scrollAmount);
            }
            int left = Math.min(p.x, this.selectionPoint.x);
            int top = Math.min(p.y, this.selectionPoint.y);
            int right = Math.max(p.x, this.selectionPoint.x);
            int bottom = Math.max(p.y, this.selectionPoint.y);
            return new Rectangle(left, (int)((double)top - this.scrolling.scrollAmount), right - left, bottom - top);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy, true)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.scrolling.scrollTarget >= 0.0 && this.scrolling.scrollTarget <= (double)this.scrolling.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.scrolling.scrollTarget / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.scrolling.scrollTarget = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scrolling.scrollTarget, (double)nearestRow, (double)0.001f) ? (this.scrolling.scrollTarget += (nearestRow - this.scrolling.scrollTarget) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scrolling.updatePosition(delta);
    }

    public void updateSearch(String searchTerm) {
        this.lastSearchArguments = SearchArgument.processSearchTerm(searchTerm);
        LinkedHashSet list = Sets.newLinkedHashSet();
        for (EntryStack stack : EntryRegistry.getInstance().getStacksList()) {
            if (!this.canLastSearchTermsBeAppliedTo(stack)) continue;
            list.add(stack.copy().setting(EntryStack.Settings.CHECK_AMOUNT, EntryStack.Settings.FALSE).setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
        }
        this.entryStacks = Lists.newArrayList((Iterable)list);
        this.updateEntriesPosition();
    }

    public boolean canLastSearchTermsBeAppliedTo(EntryStack stack) {
        return this.lastSearchArguments.isEmpty() || SearchArgument.canSearchTermsBeAppliedTo(stack, this.lastSearchArguments);
    }

    public void updateEntriesPosition() {
        this.innerBounds = FilteringEntry.updateInnerBounds(this.getBounds());
        int width = this.innerBounds.width / EntryListWidget.entrySize();
        int pageHeight = this.innerBounds.height / EntryListWidget.entrySize();
        int slotsToPrepare = Math.max(this.entryStacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * EntryListWidget.entrySize() + this.innerBounds.x;
            int yPos = currentY * EntryListWidget.entrySize() + this.innerBounds.y;
            entries.add(new EntryListEntry(xPos, yPos));
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
        this.elements = Lists.newArrayList((Iterable)entries);
        this.elements.add((class_364)this.searchField);
    }

    public List<? extends class_364> children() {
        return this.elements;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.scrolling.updateDraggingState(double_1, double_2, int_1)) {
            return true;
        }
        if (this.getBounds().contains(double_1, double_2)) {
            if (this.searchField.mouseClicked(double_1, double_2, int_1)) {
                this.selectionPoint = null;
                this.secondPoint = null;
                return true;
            }
            if (this.selectAllButton.mouseClicked(double_1, double_2, int_1)) {
                return true;
            }
            if (this.selectNoneButton.mouseClicked(double_1, double_2, int_1)) {
                return true;
            }
            if (this.hideButton.mouseClicked(double_1, double_2, int_1)) {
                return true;
            }
            if (this.showButton.mouseClicked(double_1, double_2, int_1)) {
                return true;
            }
            if (int_1 == 0) {
                this.selectionPoint = new Point(double_1, double_2 + this.scrolling.scrollAmount);
                this.secondPoint = null;
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.selectionPoint != null && button == 0 && this.secondPoint == null) {
            this.secondPoint = new Point(mouseX, mouseY + this.scrolling.scrollAmount);
            if (this.secondPoint.equals((Object)this.selectionPoint)) {
                this.secondPoint.translate(1, 1);
            }
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean charTyped(char chr, int keyCode) {
        for (class_364 class_3642 : this.children()) {
            if (!class_3642.charTyped(chr, keyCode)) continue;
            return true;
        }
        return super.charTyped(chr, keyCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (class_364 class_3642 : this.children()) {
            if (!class_3642.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (class_437.isSelectAll((int)keyCode)) {
            this.selectionPoint = new Point(0, 0);
            this.secondPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            return true;
        }
        return false;
    }

    public void updateArea(@Nullable String searchTerm) {
        if (searchTerm != null) {
            this.updateSearch(searchTerm);
        } else if (this.entryStacks == null) {
            this.updateSearch("");
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (this.getBounds().contains(double_1, double_2)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        super.mouseScrolled(double_1, double_2, double_3);
        return true;
    }

    private class EntryListEntry
    extends EntryWidget {
        private int backupY;

        private EntryListEntry(int x, int y) {
            super(new Point(x, y));
            this.backupY = y;
            this.getBounds().width = this.getBounds().height = EntryListWidget.entrySize();
            this.interactableFavorites(false);
            this.interactable(false);
            this.noHighlight();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FilteringEntry.this.getBounds().contains(mouseX, mouseY);
        }

        @Override
        protected void drawHighlighted(int mouseX, int mouseY, float delta) {
        }

        @Override
        public void render(int mouseX, int mouseY, float delta) {
            super.render(mouseX, mouseY, delta);
            if (this.isSelected()) {
                Rectangle bounds = this.getBounds();
                RenderSystem.disableDepthTest();
                this.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -1989447430, -1989447430);
                RenderSystem.enableDepthTest();
            }
        }

        @Override
        public EntryStack getCurrentEntry() {
            return super.getCurrentEntry();
        }

        public boolean isSelected() {
            return FilteringEntry.this.getSelection().intersects(this.getBounds());
        }

        public boolean isFiltered() {
            return CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(FilteringEntry.this.configFiltered, this.getCurrentEntry()) != null;
        }

        @Override
        protected void drawBackground(int mouseX, int mouseY, float delta) {
            if (this.isFiltered()) {
                Rectangle bounds = this.getBounds();
                RenderSystem.disableDepthTest();
                this.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -65536, -65536);
                RenderSystem.enableDepthTest();
            }
        }

        @Override
        protected void queueTooltip(int mouseX, int mouseY, float delta) {
            if (FilteringEntry.this.searchField.containsMouse(mouseX, mouseY)) {
                return;
            }
            QueuedTooltip tooltip = this.getCurrentTooltip(mouseX, mouseY);
            if (tooltip != null) {
                FilteringEntry.this.tooltip = tooltip;
            }
        }
    }
}

