/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.ScrollingContainer;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FavoritesListWidget
extends WidgetWithBounds {
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return FavoritesListWidget.this.bounds;
        }

        @Override
        public int getMaxScrollHeight() {
            return class_3532.method_15386((float)((float)(FavoritesListWidget.this.favorites.size() + FavoritesListWidget.this.blockedCount) / ((float)((FavoritesListWidget)FavoritesListWidget.this).innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }

        @Override
        public int getScrollBarX() {
            if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
                return ((FavoritesListWidget)FavoritesListWidget.this).bounds.x + 1;
            }
            return FavoritesListWidget.this.bounds.getMaxX() - 7;
        }
    };
    protected int blockedCount;
    List<EntryStack> favorites = null;
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryListEntry> entries = Collections.emptyList();
    private boolean draggingScrollBar = false;

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
        if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) + 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
        }
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) - 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (this.bounds.contains(double_1, double_2)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(int mouseX, int mouseY, float delta) {
        int nextIndex;
        if (this.bounds.isEmpty()) {
            return;
        }
        for (EntryListEntry entry : this.entries) {
            entry.clearStacks();
        }
        ScissorsHandler.INSTANCE.scissor(this.bounds);
        int skip = Math.max(0, class_3532.method_15357((double)(this.scrolling.scrollAmount / (double)EntryListWidget.entrySize())));
        this.blockedCount = 0;
        block1: for (int i = nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize(); i < this.favorites.size(); ++i) {
            EntryStack stack = this.favorites.get(i);
            while (true) {
                EntryListEntry entry = this.entries.get(nextIndex);
                entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
                if (entry.getBounds().y > this.bounds.getMaxY()) break block1;
                if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                    entry.entry(stack);
                    entry.render(mouseX, mouseY, delta);
                    ++nextIndex;
                    continue block1;
                }
                ++this.blockedCount;
                ++nextIndex;
            }
        }
        this.updatePosition(delta);
        this.scrolling.renderScrollBar();
        ScissorsHandler.INSTANCE.removeLastScissor();
        if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating() && !this.minecraft.field_1724.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(class_1074.method_4662((String)"text.rei.delete_items", (Object[])new Object[0])));
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, int_1, double_3, double_4, true)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.scrolling.scrollTarget >= 0.0 && this.scrolling.scrollTarget <= (double)this.scrolling.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.scrolling.scrollTarget / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.scrolling.scrollTarget = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scrolling.scrollTarget, (double)nearestRow, (double)0.001f) ? (this.scrolling.scrollTarget += (nearestRow - this.scrolling.scrollTarget) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scrolling.updatePosition(delta);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.fromMouse())) {
            for (Widget widget : this.children()) {
                if (!widget.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateFavoritesBounds(DisplayHelper.DisplayBoundsHandler boundsHandler, @Nullable String searchTerm) {
        this.bounds = boundsHandler.getFavoritesListArea(!ConfigObject.getInstance().isLeftHandSidePanel() ? boundsHandler.getLeftBounds(class_310.method_1551().field_1755) : boundsHandler.getRightBounds(class_310.method_1551().field_1755));
    }

    public void updateSearch(EntryListWidget listWidget, String searchTerm) {
        if (ConfigObject.getInstance().isFavoritesEnabled() && ConfigObject.getInstance().doDisplayFavoritesOnTheLeft()) {
            if (ConfigObject.getInstance().doSearchFavorites()) {
                ArrayList list = Lists.newArrayList();
                boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
                List<EntryStack> workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
                for (EntryStack stack : ConfigObject.getInstance().getFavorites()) {
                    if (!listWidget.canLastSearchTermsBeAppliedTo(stack) || checkCraftable && CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(workingItems, stack) == null) continue;
                    list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, EntryListWidget.RENDER_ENCHANTMENT_GLINT));
                }
                ItemListOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
                if (ordering == ItemListOrdering.name) {
                    list.sort(EntryListWidget.ENTRY_NAME_COMPARER);
                }
                if (ordering == ItemListOrdering.item_groups) {
                    list.sort(EntryListWidget.ENTRY_GROUP_COMPARER);
                }
                if (!ConfigObject.getInstance().isItemListAscending()) {
                    Collections.reverse(list);
                }
                this.favorites = list;
            } else {
                ArrayList list = Lists.newArrayList();
                boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
                List<EntryStack> workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
                for (EntryStack stack : ConfigObject.getInstance().getFavorites()) {
                    if (checkCraftable && CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(workingItems, stack) == null) continue;
                    list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, EntryListWidget.RENDER_ENCHANTMENT_GLINT));
                }
                Object ordering = ConfigObject.getInstance().getItemListOrdering();
                if (ordering == ItemListOrdering.name) {
                    list.sort(EntryListWidget.ENTRY_NAME_COMPARER);
                }
                if (ordering == ItemListOrdering.item_groups) {
                    list.sort(EntryListWidget.ENTRY_GROUP_COMPARER);
                }
                if (!ConfigObject.getInstance().isItemListAscending()) {
                    Collections.reverse(list);
                }
                this.favorites = list;
            }
        } else {
            this.favorites = Collections.emptyList();
        }
    }

    public void updateEntriesPosition() {
        this.innerBounds = FavoritesListWidget.updateInnerBounds(this.bounds);
        int width = this.innerBounds.width / EntryListWidget.entrySize();
        int pageHeight = this.innerBounds.height / EntryListWidget.entrySize();
        int slotsToPrepare = Math.max(this.favorites.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * EntryListWidget.entrySize() + this.innerBounds.x;
            int yPos = currentY * EntryListWidget.entrySize() + this.innerBounds.y;
            entries.add((EntryListEntry)new EntryListEntry(xPos, yPos).noBackground());
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
    }

    public List<? extends Widget> children() {
        return this.entries;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.scrolling.updateDraggingState(double_1, double_2, int_1)) {
            return true;
        }
        if (this.containsMouse(double_1, double_2)) {
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
            for (Widget widget : this.children()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    private class EntryListEntry
    extends EntryWidget {
        private int backupY;

        private EntryListEntry(int x, int y) {
            super(new Point(x, y));
            this.backupY = y;
            this.getBounds().width = this.getBounds().height = EntryListWidget.entrySize();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FavoritesListWidget.this.bounds.contains(mouseX, mouseY);
        }

        @Override
        protected void drawHighlighted(int mouseX, int mouseY, float delta) {
            if (!this.getCurrentEntry().isEmpty()) {
                super.drawHighlighted(mouseX, mouseY, delta);
            }
        }

        @Override
        protected boolean reverseFavoritesAction() {
            return true;
        }

        @Override
        public void queueTooltip(int mouseX, int mouseY, float delta) {
            if (!ClientHelper.getInstance().isCheating() || this.minecraft.field_1724.field_7514.method_7399().method_7960()) {
                super.queueTooltip(mouseX, mouseY, delta);
            }
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            EntryStack entry;
            if (!this.interactable) {
                return super.mouseClicked(mouseX, mouseY, button);
            }
            if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating() && !(entry = this.getCurrentEntry().copy()).isEmpty()) {
                if (entry.getType() == EntryStack.Type.FLUID) {
                    entry = EntryStack.copyFluidToBucket(entry);
                }
                if (entry.getType() == EntryStack.Type.ITEM) {
                    entry.setAmount(button != 1 && !class_437.hasShiftDown() ? 1 : entry.getItemStack().method_7914());
                }
                ClientHelper.getInstance().tryCheatingEntry(entry);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }
}

