/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.OverlaySearchField;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.config.SearchFieldLocation;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.CraftableToggleButtonWidget;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.gui.widget.LateRenderedButton;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.Weather;
import me.shedaniel.rei.listeners.ContainerScreenHooks;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_1269;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_638;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ContainerScreenOverlay
extends WidgetWithBounds {
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final List<QueuedTooltip> QUEUED_TOOLTIPS = Lists.newArrayList();
    private static final EntryListWidget ENTRY_LIST_WIDGET = new EntryListWidget();
    private static FavoritesListWidget favoritesListWidget = null;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReInit = false;
    private int tooltipWidth;
    private int tooltipHeight;
    private List<String> tooltipLines;
    public final TriConsumer<Integer, Integer, Float> renderTooltipCallback = (x, y, aFloat) -> {
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        this.setBlitOffset(999);
        this.fillGradient(x - 3, y - 4, x + this.tooltipWidth + 3, y - 3, -267386864, -267386864);
        this.fillGradient(x - 3, y + this.tooltipHeight + 3, x + this.tooltipWidth + 3, y + this.tooltipHeight + 4, -267386864, -267386864);
        this.fillGradient(x - 3, y - 3, x + this.tooltipWidth + 3, y + this.tooltipHeight + 3, -267386864, -267386864);
        this.fillGradient(x - 4, y - 3, x - 3, y + this.tooltipHeight + 3, -267386864, -267386864);
        this.fillGradient(x + this.tooltipWidth + 3, y - 3, x + this.tooltipWidth + 4, y + this.tooltipHeight + 3, -267386864, -267386864);
        this.fillGradient(x - 3, y - 3 + 1, x - 3 + 1, y + this.tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
        this.fillGradient(x + this.tooltipWidth + 2, y - 3 + 1, x + this.tooltipWidth + 3, y + this.tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
        this.fillGradient(x - 3, y - 3, x + this.tooltipWidth + 3, y - 3 + 1, 0x505000FF, 0x505000FF);
        this.fillGradient(x - 3, y + this.tooltipHeight + 2, x + this.tooltipWidth + 3, y + this.tooltipHeight + 3, 1344798847, 1344798847);
        int currentY = y;
        class_4587 matrixStack_1 = new class_4587();
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        matrixStack_1.method_22904(0.0, 0.0, (double)this.getBlitOffset());
        class_1159 matrix4f_1 = matrixStack_1.method_23760().method_23761();
        for (int lineIndex = 0; lineIndex < this.tooltipLines.size(); ++lineIndex) {
            this.font.method_22942(this.tooltipLines.get(lineIndex), (float)x.intValue(), (float)currentY, -1, true, matrix4f_1, (class_4597)immediate, false, 0, 0xF000F0);
            currentY += lineIndex == 0 ? 12 : 10;
        }
        immediate.method_22993();
        this.setBlitOffset(0);
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    };
    private Rectangle bounds;
    private class_1041 window;
    @Nullable
    private LateRenderedButton craftableToggleButton;
    private LateRenderedButton configButton;
    private ButtonWidget leftButton;
    private ButtonWidget rightButton;

    public static EntryListWidget getEntryListWidget() {
        return ENTRY_LIST_WIDGET;
    }

    @Nullable
    public static FavoritesListWidget getFavoritesListWidget() {
        return favoritesListWidget;
    }

    public void init(boolean useless) {
        this.init();
    }

    public void init() {
        this.shouldReInit = false;
        this.children().clear();
        this.window = class_310.method_1551().method_22683();
        DisplayHelper.DisplayBoundsHandler<?> boundsHandler = DisplayHelper.getInstance().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
        this.bounds = ConfigObject.getInstance().isLeftHandSidePanel() ? boundsHandler.getLeftBounds(class_310.method_1551().field_1755) : boundsHandler.getRightBounds(class_310.method_1551().field_1755);
        this.widgets.add(ENTRY_LIST_WIDGET);
        if (ConfigObject.getInstance().doDisplayFavoritesOnTheLeft() && ConfigObject.getInstance().isFavoritesEnabled()) {
            if (favoritesListWidget == null) {
                favoritesListWidget = new FavoritesListWidget();
            }
            this.widgets.add(favoritesListWidget);
        }
        ENTRY_LIST_WIDGET.updateArea(boundsHandler, ScreenHelper.getSearchField() == null ? "" : null);
        if (ScreenHelper.getSearchField() == null) {
            ScreenHelper.setSearchField(new OverlaySearchField(0, 0, 0, 0));
        }
        ScreenHelper.getSearchField().getBounds().setBounds(this.getSearchFieldArea());
        this.widgets.add(ScreenHelper.getSearchField());
        ScreenHelper.getSearchField().setChangedListener(ENTRY_LIST_WIDGET::updateSearch);
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.leftButton = new ButtonWidget(new Rectangle(this.bounds.x, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (class_2561)new class_2588("text.rei.left_arrow", new Object[0])){

                @Override
                public void onPressed() {
                    ENTRY_LIST_WIDGET.previousPage();
                    if (ENTRY_LIST_WIDGET.getPage() < 0) {
                        ENTRY_LIST_WIDGET.setPage(ENTRY_LIST_WIDGET.getTotalPages() - 1);
                    }
                    ENTRY_LIST_WIDGET.updateEntriesPosition();
                }

                @Override
                public boolean containsMouse(double mouseX, double mouseY) {
                    return ContainerScreenOverlay.this.isNotInExclusionZones(mouseX, mouseY) && super.containsMouse(mouseX, mouseY);
                }
            }.tooltip(() -> class_1074.method_4662((String)"text.rei.previous_page", (Object[])new Object[0])).canChangeFocuses(false);
            this.widgets.add(this.leftButton);
            this.rightButton = new ButtonWidget(new Rectangle(this.bounds.x + this.bounds.width - 18, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (class_2561)new class_2588("text.rei.right_arrow", new Object[0])){

                @Override
                public void onPressed() {
                    ENTRY_LIST_WIDGET.nextPage();
                    if (ENTRY_LIST_WIDGET.getPage() >= ENTRY_LIST_WIDGET.getTotalPages()) {
                        ENTRY_LIST_WIDGET.setPage(0);
                    }
                    ENTRY_LIST_WIDGET.updateEntriesPosition();
                }

                @Override
                public boolean containsMouse(double mouseX, double mouseY) {
                    return ContainerScreenOverlay.this.isNotInExclusionZones(mouseX, mouseY) && super.containsMouse(mouseX, mouseY);
                }
            }.tooltip(() -> class_1074.method_4662((String)"text.rei.next_page", (Object[])new Object[0])).canChangeFocuses(false);
            this.widgets.add(this.rightButton);
        }
        this.configButton = new LateRenderedButton(this.getConfigButtonArea(), class_333.field_18967){

            @Override
            public void onPressed() {
                if (class_437.hasShiftDown()) {
                    ClientHelper.getInstance().setCheating(!ClientHelper.getInstance().isCheating());
                    return;
                }
                ConfigManager.getInstance().openConfigScreen((class_437)ScreenHelper.getLastContainerScreen());
            }

            @Override
            public void render(int mouseX, int mouseY, float delta) {
            }

            @Override
            public void lateRender(int mouseX, int mouseY, float delta) {
                this.setBlitOffset(600);
                super.render(mouseX, mouseY, delta);
                Rectangle bounds = this.getBounds();
                if (ClientHelper.getInstance().isCheating() && RoughlyEnoughItemsCore.hasOperatorPermission()) {
                    if (RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                        3.fill((int)(bounds.x + 1), (int)(bounds.y + 1), (int)(bounds.getMaxX() - 1), (int)(bounds.getMaxY() - 1), (int)721354752);
                    } else {
                        3.fill((int)(bounds.x + 1), (int)(bounds.y + 1), (int)(bounds.getMaxX() - 1), (int)(bounds.getMaxY() - 1), (int)1476440063);
                    }
                }
                class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.blit(bounds.x + 3, bounds.y + 3, 0, 0, 14, 14);
                this.setBlitOffset(0);
            }

            @Override
            public Optional<String> getTooltips() {
                String tooltips = class_1074.method_4662((String)"text.rei.config_tooltip", (Object[])new Object[0]);
                tooltips = tooltips + "\n  ";
                tooltips = !ClientHelper.getInstance().isCheating() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_disabled", (Object[])new Object[0]) : (!RoughlyEnoughItemsCore.hasOperatorPermission() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_enabled_no_perms", (Object[])new Object[0]) : (RoughlyEnoughItemsCore.hasPermissionToUsePackets() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_enabled", (Object[])new Object[0]) : tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_limited_enabled", (Object[])new Object[0])));
                return Optional.ofNullable(tooltips);
            }

            @Override
            public boolean changeFocus(boolean boolean_1) {
                return false;
            }

            @Override
            public boolean containsMouse(double mouseX, double mouseY) {
                return ContainerScreenOverlay.this.isNotInExclusionZones(mouseX, mouseY) && super.containsMouse(mouseX, mouseY);
            }
        };
        this.widgets.add(this.configButton);
        if (ConfigObject.getInstance().doesShowUtilsButtons()) {
            this.widgets.add(new ButtonWidget(ConfigObject.getInstance().isLowerConfigButton() ? new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? this.window.method_4486() - 30 : 10, 10, 20, 20) : new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? this.window.method_4486() - 55 : 35, 10, 20, 20), class_333.field_18967){

                @Override
                public void onPressed() {
                    class_310.method_1551().field_1724.method_3142(ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", ContainerScreenOverlay.this.getNextGameMode(class_437.hasShiftDown()).method_8381()));
                }

                @Override
                public void render(int mouseX, int mouseY, float delta) {
                    this.setText(ContainerScreenOverlay.this.getGameModeShortText(ContainerScreenOverlay.this.getCurrentGameMode()));
                    super.render(mouseX, mouseY, delta);
                }

                @Override
                public boolean containsMouse(double mouseX, double mouseY) {
                    return ContainerScreenOverlay.this.isNotInExclusionZones(mouseX, mouseY) && super.containsMouse(mouseX, mouseY);
                }
            }.tooltip(() -> class_1074.method_4662((String)"text.rei.gamemode_button.tooltip", (Object[])new Object[]{this.getGameModeText(this.getNextGameMode(class_437.hasShiftDown()))})).canChangeFocuses(false));
            int xxx = ConfigObject.getInstance().isLeftHandSidePanel() ? this.window.method_4486() - 30 : 10;
            for (final Weather weather : Weather.values()) {
                this.widgets.add(new ButtonWidget(new Rectangle(xxx, 35, 20, 20), class_333.field_18967){

                    @Override
                    public void onPressed() {
                        class_310.method_1551().field_1724.method_3142(ConfigObject.getInstance().getWeatherCommand().replaceAll("\\{weather}", weather.name().toLowerCase(Locale.ROOT)));
                    }

                    @Override
                    public void render(int mouseX, int mouseY, float delta) {
                        super.render(mouseX, mouseY, delta);
                        class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.blit(this.getBounds().x + 3, this.getBounds().y + 3, weather.getId() * 14, 14, 14, 14);
                    }

                    @Override
                    public boolean containsMouse(double mouseX, double mouseY) {
                        return ContainerScreenOverlay.this.isNotInExclusionZones(mouseX, mouseY) && super.containsMouse(mouseX, mouseY);
                    }
                }.tooltip(() -> class_1074.method_4662((String)"text.rei.weather_button.tooltip", (Object[])new Object[]{class_1074.method_4662((String)weather.getTranslateKey(), (Object[])new Object[0])})).canChangeFocuses(false));
                xxx += ConfigObject.getInstance().isLeftHandSidePanel() ? -25 : 25;
            }
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.widgets.add(new ClickableLabelWidget(new Point(this.bounds.x + this.bounds.width / 2, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 10), ""){

                @Override
                public void render(int mouseX, int mouseY, float delta) {
                    this.clickable(ENTRY_LIST_WIDGET.getTotalPages() > 1);
                    this.setText(String.format("%s/%s", ENTRY_LIST_WIDGET.getPage() + 1, Math.max(ENTRY_LIST_WIDGET.getTotalPages(), 1)));
                    super.render(mouseX, mouseY, delta);
                }

                @Override
                public void onLabelClicked() {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                    ENTRY_LIST_WIDGET.setPage(0);
                    ENTRY_LIST_WIDGET.updateEntriesPosition();
                }

                @Override
                public boolean changeFocus(boolean boolean_1) {
                    return false;
                }
            }.tooltip(() -> class_1074.method_4662((String)"text.rei.go_back_first_page", (Object[])new Object[0])));
        }
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            this.craftableToggleButton = new CraftableToggleButtonWidget(this.getCraftableToggleArea()){

                @Override
                public void onPressed() {
                    ConfigManager.getInstance().toggleCraftableOnly();
                    ENTRY_LIST_WIDGET.updateSearch(ScreenHelper.getSearchField().getText());
                }

                @Override
                public boolean containsMouse(double mouseX, double mouseY) {
                    return ContainerScreenOverlay.this.isNotInExclusionZones(mouseX, mouseY) && super.containsMouse(mouseX, mouseY);
                }
            };
            this.widgets.add(this.craftableToggleButton);
        } else {
            this.craftableToggleButton = null;
        }
    }

    private Weather getNextWeather() {
        try {
            Weather current = this.getCurrentWeather();
            int next = current.getId() + 1;
            if (next >= 3) {
                next = 0;
            }
            return Weather.byId(next);
        }
        catch (Exception e) {
            return Weather.CLEAR;
        }
    }

    private Weather getCurrentWeather() {
        class_638 world = class_310.method_1551().field_1687;
        if (world.method_8546()) {
            return Weather.THUNDER;
        }
        if (world.method_8401().method_156()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private String getGameModeShortText(class_1934 gameMode) {
        return class_1074.method_4662((String)("text.rei.short_gamemode." + gameMode.method_8381()), (Object[])new Object[0]);
    }

    private String getGameModeText(class_1934 gameMode) {
        return class_1074.method_4662((String)("selectWorld.gameMode." + gameMode.method_8381()), (Object[])new Object[0]);
    }

    private class_1934 getNextGameMode(boolean reverse) {
        try {
            class_1934 current = this.getCurrentGameMode();
            int next = current.method_8379() + 1;
            if (reverse) {
                next -= 2;
            }
            if (next > 3) {
                next = 0;
            }
            if (next < 0) {
                next = 3;
            }
            return class_1934.method_8384((int)next);
        }
        catch (Exception e) {
            return class_1934.field_9218;
        }
    }

    private class_1934 getCurrentGameMode() {
        return class_310.method_1551().method_1562().method_2871(class_310.method_1551().field_1724.method_7334().getId()).method_2958();
    }

    private Rectangle getSearchFieldArea() {
        int widthRemoved = 1 + (ConfigObject.getInstance().isCraftableFilterEnabled() ? 22 : 0) + (ConfigObject.getInstance().isLowerConfigButton() ? 22 : 0);
        SearchFieldLocation searchFieldLocation = ConfigObject.getInstance().getSearchFieldLocation();
        if (searchFieldLocation == SearchFieldLocation.BOTTOM_SIDE) {
            return new Rectangle(this.bounds.x + 2, this.window.method_4502() - 22, this.bounds.width - 6 - widthRemoved, 18);
        }
        if (searchFieldLocation == SearchFieldLocation.TOP_SIDE) {
            return new Rectangle(this.bounds.x + 2, 4, this.bounds.width - 6 - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof RecipeViewingScreen) {
            RecipeViewingScreen widget = (RecipeViewingScreen)class_310.method_1551().field_1755;
            return new Rectangle(widget.getBounds().x, this.window.method_4502() - 22, widget.getBounds().width - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen) {
            VillagerRecipeViewingScreen widget = (VillagerRecipeViewingScreen)class_310.method_1551().field_1755;
            return new Rectangle(widget.bounds.x, this.window.method_4502() - 22, widget.bounds.width - widthRemoved, 18);
        }
        return new Rectangle(ScreenHelper.getLastContainerScreenHooks().rei_getContainerLeft(), this.window.method_4502() - 22, ScreenHelper.getLastContainerScreenHooks().rei_getContainerWidth() - widthRemoved, 18);
    }

    private Rectangle getCraftableToggleArea() {
        Rectangle area = this.getSearchFieldArea();
        area.setLocation(area.x + area.width + 4, area.y - 1);
        area.setSize(20, 20);
        return area;
    }

    private Rectangle getConfigButtonArea() {
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            Rectangle area = this.getSearchFieldArea();
            area.setLocation(area.x + area.width + (ConfigObject.getInstance().isCraftableFilterEnabled() ? 26 : 4), area.y - 1);
            area.setSize(20, 20);
            return area;
        }
        return new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? this.window.method_4486() - 30 : 10, 10, 20, 20);
    }

    private String getCheatModeText() {
        return class_1074.method_4662((String)String.format("%s%s", "text.rei.", ClientHelper.getInstance().isCheating() ? "cheat" : "nocheat"), (Object[])new Object[0]);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(int mouseX, int mouseY, float delta) {
        ContainerScreenHooks hooks;
        List<class_1799> currentStacks = ClientHelper.getInstance().getInventoryItemsTypes();
        if (this.shouldReInit) {
            this.init();
        } else {
            for (DisplayHelper.DisplayBoundsHandler<?> handler : DisplayHelper.getInstance().getSortedBoundsHandlers(this.minecraft.field_1755.getClass())) {
                if (handler == null || !handler.shouldRecalculateArea(!ConfigObject.getInstance().isLeftHandSidePanel(), this.bounds)) continue;
                this.init();
                break;
            }
        }
        if (ConfigManager.getInstance().isCraftableOnlyEnabled() && (currentStacks.size() != ScreenHelper.inventoryStacks.size() || !this.hasSameListContent(new LinkedList<class_1799>(ScreenHelper.inventoryStacks), currentStacks))) {
            ScreenHelper.inventoryStacks = currentStacks;
            ENTRY_LIST_WIDGET.updateSearch(ScreenHelper.getSearchField().getText());
        }
        if (OverlaySearchField.isSearching) {
            this.setBlitOffset(200);
            if (class_310.method_1551().field_1755 instanceof class_465) {
                hooks = (ContainerScreenHooks)class_310.method_1551().field_1755;
                int left = hooks.rei_getContainerLeft();
                int top = hooks.rei_getContainerTop();
                for (class_1735 slot : ((class_465)class_310.method_1551().field_1755).method_17577().field_7761) {
                    if (slot.method_7681() && ENTRY_LIST_WIDGET.canLastSearchTermsBeAppliedTo(EntryStack.create(slot.method_7677()))) continue;
                    this.fillGradient(left + slot.field_7873, top + slot.field_7872, left + slot.field_7873 + 16, top + slot.field_7872 + 16, -601874400, -601874400);
                }
            }
            this.setBlitOffset(0);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderWidgets(mouseX, mouseY, delta);
        if (class_310.method_1551().field_1755 instanceof class_465 && ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            hooks = (ContainerScreenHooks)class_310.method_1551().field_1755;
            for (RecipeHelper.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas()) {
                if (!area.getScreenClass().equals(class_310.method_1551().field_1755.getClass()) || !area.getRectangle().contains(mouseX - hooks.rei_getContainerLeft(), mouseY - hooks.rei_getContainerTop())) continue;
                String collect = CollectionUtils.mapAndJoinToString(area.getCategories(), identifier -> RecipeHelper.getInstance().getCategory((class_2960)identifier).getCategoryName(), ", ");
                QUEUED_TOOLTIPS.add(QueuedTooltip.create(class_1074.method_4662((String)"text.rei.view_recipes_for", (Object[])new Object[]{collect})));
                break;
            }
        }
    }

    public void lateRender(int mouseX, int mouseY, float delta) {
        class_437 currentScreen;
        if (ScreenHelper.isOverlayVisible()) {
            ScreenHelper.getSearchField().laterRender(mouseX, mouseY, delta);
            if (this.craftableToggleButton != null) {
                this.craftableToggleButton.lateRender(mouseX, mouseY, delta);
            }
            this.configButton.lateRender(mouseX, mouseY, delta);
        }
        if (!((currentScreen = class_310.method_1551().field_1755) instanceof RecipeViewingScreen) || !((RecipeViewingScreen)currentScreen).choosePageActivated) {
            for (QueuedTooltip queuedTooltip : QUEUED_TOOLTIPS) {
                if (queuedTooltip == null) continue;
                this.renderTooltip(queuedTooltip);
            }
        }
        QUEUED_TOOLTIPS.clear();
    }

    public void renderTooltip(QueuedTooltip tooltip) {
        if (tooltip.getConsumer() == null) {
            this.renderTooltip(tooltip.getText(), tooltip.getX(), tooltip.getY());
        } else {
            tooltip.getConsumer().accept(tooltip);
        }
    }

    public void renderTooltip(List<String> lines, int mouseX, int mouseY) {
        if (lines.isEmpty()) {
            return;
        }
        this.tooltipWidth = lines.stream().map(arg_0 -> ((class_327)this.font).method_1727(arg_0)).max(Integer::compareTo).get();
        this.tooltipHeight = lines.size() <= 1 ? 8 : lines.size() * 10;
        this.tooltipLines = lines;
        ScreenHelper.drawHoveringWidget(mouseX, mouseY, this.renderTooltipCallback, this.tooltipWidth, this.tooltipHeight, 0.0f);
    }

    private boolean hasSameListContent(List<class_1799> list1, List<class_1799> list2) {
        list1.sort(Comparator.comparing(Object::toString));
        list2.sort(Comparator.comparing(Object::toString));
        return CollectionUtils.mapAndJoinToString(list1, Object::toString, "").equals(CollectionUtils.mapAndJoinToString(list2, Object::toString, ""));
    }

    public void addTooltip(@Nullable QueuedTooltip queuedTooltip) {
        if (queuedTooltip != null) {
            QUEUED_TOOLTIPS.add(queuedTooltip);
        }
    }

    public void renderWidgets(int int_1, int int_2, float float_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return;
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.rightButton.enabled = ENTRY_LIST_WIDGET.getTotalPages() > 1;
            this.leftButton.enabled = this.rightButton.enabled;
        }
        for (Widget widget : this.widgets) {
            widget.render(int_1, int_2, float_1);
        }
    }

    public boolean mouseScrolled(double i, double j, double amount) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (this.isInside(PointHelper.fromMouse())) {
            if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
                if (amount > 0.0 && this.leftButton.enabled) {
                    this.leftButton.onPressed();
                } else if (amount < 0.0 && this.rightButton.enabled) {
                    this.rightButton.onPressed();
                } else {
                    return false;
                }
                return true;
            }
            if (ENTRY_LIST_WIDGET.mouseScrolled(i, j, amount)) {
                return true;
            }
        }
        if (this.isNotInExclusionZones(PointHelper.getMouseX(), PointHelper.getMouseY()) && favoritesListWidget != null && favoritesListWidget.mouseScrolled(i, j, amount)) {
            return true;
        }
        for (Widget widget : this.widgets) {
            if (widget == ENTRY_LIST_WIDGET || favoritesListWidget != null && widget == favoritesListWidget || !widget.mouseScrolled(i, j, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (ScreenHelper.isOverlayVisible()) {
            if (ScreenHelper.getSearchField().keyPressed(int_1, int_2, int_3)) {
                return true;
            }
            for (class_364 class_3642 : this.widgets) {
                if (class_3642 == ScreenHelper.getSearchField() || !class_3642.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesKey(int_1, int_2)) {
            ScreenHelper.toggleOverlayVisible();
            return true;
        }
        class_1799 itemStack = null;
        if (class_310.method_1551().field_1755 instanceof class_465 && ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot() != null && !ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot().method_7677().method_7960()) {
            itemStack = ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot().method_7677();
        }
        if (itemStack != null && !itemStack.method_7960()) {
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(int_1, int_2)) {
                return ClientHelper.getInstance().executeRecipeKeyBind(itemStack);
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(int_1, int_2)) {
                return ClientHelper.getInstance().executeUsageKeyBind(itemStack);
            }
        }
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesKey(int_1, int_2)) {
            ScreenHelper.getSearchField().setFocused(true);
            this.setFocused((class_364)ScreenHelper.getSearchField());
            ScreenHelper.getSearchField().keybindFocusTime = System.currentTimeMillis();
            ScreenHelper.getSearchField().keybindFocusKey = int_1;
            return true;
        }
        return false;
    }

    public boolean charTyped(char char_1, int int_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (ScreenHelper.getSearchField().charTyped(char_1, int_1)) {
            return true;
        }
        for (class_364 class_3642 : this.widgets) {
            if (class_3642 == ScreenHelper.getSearchField() || !class_3642.charTyped(char_1, int_1)) continue;
            return true;
        }
        return false;
    }

    public List<? extends class_364> children() {
        return this.widgets;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (class_310.method_1551().field_1755 instanceof class_465 && ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            ContainerScreenHooks hooks = (ContainerScreenHooks)class_310.method_1551().field_1755;
            for (RecipeHelper.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas()) {
                if (!area.getScreenClass().equals(class_310.method_1551().field_1755.getClass()) || !area.getRectangle().contains(double_1 - (double)hooks.rei_getContainerLeft(), double_2 - (double)hooks.rei_getContainerTop())) continue;
                ClientHelper.getInstance().executeViewAllRecipesFromCategories(Arrays.asList(area.getCategories()));
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                return true;
            }
        }
        for (class_364 class_3642 : this.widgets) {
            if (!class_3642.mouseClicked(double_1, double_2, int_1)) continue;
            this.setFocused(class_3642);
            if (int_1 == 0) {
                this.setDragging(true);
            }
            if (!(class_3642 instanceof OverlaySearchField)) {
                ScreenHelper.getSearchField().setFocused(false);
            }
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        return this.getFocused() != null && this.isDragging() && int_1 == 0 && this.getFocused().mouseDragged(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean isInside(double mouseX, double mouseY) {
        return this.bounds.contains(mouseX, mouseY) && this.isNotInExclusionZones(mouseX, mouseY);
    }

    public boolean isNotInExclusionZones(double mouseX, double mouseY) {
        for (DisplayHelper.DisplayBoundsHandler<?> handler : DisplayHelper.getInstance().getSortedBoundsHandlers(class_310.method_1551().field_1755.getClass())) {
            class_1269 in = handler.isInZone(mouseX, mouseY);
            if (in == class_1269.field_5811) continue;
            return in == class_1269.field_5812;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }
}

