/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FavoritesListWidget
extends WidgetWithBounds {
    protected double target;
    protected double scroll;
    protected long start;
    protected long duration;
    protected int blockedCount;
    List<EntryStack> favorites = null;
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryListEntry> entries = Collections.emptyList();
    private boolean draggingScrollBar = false;

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
        if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) + 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
        }
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) - 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
    }

    protected final int getMaxScrollPosition() {
        return class_3532.method_15386((float)((float)(this.favorites.size() + this.blockedCount) / ((float)this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
    }

    protected final int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - this.innerBounds.height);
    }

    protected final double clamp(double v) {
        return this.clamp(v, 200.0);
    }

    protected final double clamp(double v, double clampExtension) {
        return class_3532.method_15350((double)v, (double)(-clampExtension), (double)((double)this.getMaxScroll() + clampExtension));
    }

    protected final void offset(double value, boolean animated) {
        this.scrollTo(this.target + value, animated);
    }

    protected final void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    protected final void scrollTo(double value, boolean animated, long duration) {
        this.target = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scroll = this.target;
        }
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.bounds.contains(double_1, double_2)) {
            this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(int mouseX, int mouseY, float delta) {
        int nextIndex;
        if (this.bounds.isEmpty()) {
            return;
        }
        for (EntryListEntry entry : this.entries) {
            entry.clearStacks();
        }
        ScissorsHandler.INSTANCE.scissor(this.bounds);
        int skip = Math.max(0, class_3532.method_15357((double)(this.scroll / (double)EntryListWidget.entrySize())));
        this.blockedCount = 0;
        block1: for (int i = nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize(); i < this.favorites.size(); ++i) {
            EntryStack stack = this.favorites.get(i);
            while (true) {
                EntryListEntry entry = this.entries.get(nextIndex);
                entry.getBounds().y = (int)((double)entry.backupY - this.scroll);
                if (entry.getBounds().y > this.bounds.getMaxY()) break block1;
                if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                    entry.entry(stack);
                    entry.render(mouseX, mouseY, delta);
                    ++nextIndex;
                    continue block1;
                }
                ++this.blockedCount;
                ++nextIndex;
            }
        }
        this.updatePosition(delta);
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.renderScrollbar();
    }

    private int getScrollbarMinX() {
        if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
            return this.bounds.x + 1;
        }
        return this.bounds.getMaxX() - 7;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        int actualHeight;
        float height;
        if (int_1 == 0 && this.draggingScrollBar && (height = (float)this.getMaxScrollPosition()) > (float)(actualHeight = this.innerBounds.height) && mouseY >= (double)this.innerBounds.y && mouseY <= (double)this.innerBounds.getMaxY()) {
            double double_5 = Math.max(1, this.getMaxScroll());
            int int_2 = this.innerBounds.height;
            int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
            double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
            float to = class_3532.method_15363((float)((float)(this.scroll + double_4 * double_6)), (float)0.0f, (float)(height - (float)this.innerBounds.height));
            if (ConfigObject.getInstance().doesSnapToRows()) {
                double nearestRow = (double)Math.round((double)to / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
                this.scrollTo(nearestRow, false);
            } else {
                this.scrollTo(to, false);
            }
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    private void renderScrollbar() {
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int height = this.innerBounds.height * this.innerBounds.height / this.getMaxScrollPosition();
            height = class_3532.method_15340((int)height, (int)32, (int)(this.innerBounds.height - 8));
            height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)maxScroll ? (int)this.scroll - maxScroll : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.scroll * (this.innerBounds.height - height) / maxScroll + this.innerBounds.y, this.innerBounds.y), this.innerBounds.getMaxY() - height);
            int scrollbarPositionMinX = this.getScrollbarMinX();
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse());
            float bottomC = (hovered ? 0.67f : 0.5f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
            float topC = (hovered ? 0.87f : 0.67f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.shadeModel((int)7425);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height), 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            tessellator.method_1350();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            tessellator.method_1350();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.target >= 0.0 && this.target <= (double)this.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.target / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.target = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.target, (double)nearestRow, (double)0.001f) ? (this.target += (nearestRow - this.target) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        double[] targetD = new double[]{this.target};
        this.scroll = ClothConfigInitializer.handleScrollingPosition((double[])targetD, (double)this.scroll, (double)this.getMaxScroll(), (float)delta, (double)this.start, (double)this.duration);
        this.target = targetD[0];
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.fromMouse())) {
            for (Widget widget : this.children()) {
                if (!widget.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateFavoritesBounds(DisplayHelper.DisplayBoundsHandler boundsHandler, @Nullable String searchTerm) {
        this.bounds = boundsHandler.getFavoritesListArea(!ConfigObject.getInstance().isLeftHandSidePanel() ? boundsHandler.getLeftBounds(class_310.method_1551().field_1755) : boundsHandler.getRightBounds(class_310.method_1551().field_1755));
    }

    public void updateSearch(EntryListWidget listWidget, String searchTerm) {
        if (ConfigObject.getInstance().isFavoritesEnabled() && ConfigObject.getInstance().doDisplayFavoritesOnTheLeft()) {
            if (ConfigObject.getInstance().doSearchFavorites()) {
                ArrayList list = Lists.newArrayList();
                boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
                List<EntryStack> workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
                for (EntryStack stack : ConfigManager.getInstance().getFavorites()) {
                    if (!listWidget.canLastSearchTermsBeAppliedTo(stack) || checkCraftable && CollectionUtils.findFirstOrNullEquals(workingItems, stack) == null) continue;
                    list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, EntryListWidget.RENDER_ENCHANTMENT_GLINT));
                }
                ItemListOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
                if (ordering == ItemListOrdering.name) {
                    list.sort(EntryListWidget.ENTRY_NAME_COMPARER);
                }
                if (ordering == ItemListOrdering.item_groups) {
                    list.sort(EntryListWidget.ENTRY_GROUP_COMPARER);
                }
                if (!ConfigObject.getInstance().isItemListAscending()) {
                    Collections.reverse(list);
                }
                this.favorites = list;
            } else {
                ArrayList list = Lists.newArrayList();
                boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
                List<EntryStack> workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
                for (EntryStack stack : ConfigManager.getInstance().getFavorites()) {
                    if (checkCraftable && CollectionUtils.findFirstOrNullEquals(workingItems, stack) == null) continue;
                    list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, EntryListWidget.RENDER_ENCHANTMENT_GLINT));
                }
                Object ordering = ConfigObject.getInstance().getItemListOrdering();
                if (ordering == ItemListOrdering.name) {
                    list.sort(EntryListWidget.ENTRY_NAME_COMPARER);
                }
                if (ordering == ItemListOrdering.item_groups) {
                    list.sort(EntryListWidget.ENTRY_GROUP_COMPARER);
                }
                if (!ConfigObject.getInstance().isItemListAscending()) {
                    Collections.reverse(list);
                }
                this.favorites = list;
            }
        } else {
            this.favorites = Collections.emptyList();
        }
    }

    public void updateEntriesPosition() {
        this.innerBounds = FavoritesListWidget.updateInnerBounds(this.bounds);
        int width = this.innerBounds.width / EntryListWidget.entrySize();
        int pageHeight = this.innerBounds.height / EntryListWidget.entrySize();
        int slotsToPrepare = Math.max(this.favorites.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * EntryListWidget.entrySize() + this.innerBounds.x;
            int yPos = currentY * EntryListWidget.entrySize() + this.innerBounds.y;
            entries.add((EntryListEntry)new EntryListEntry(xPos, yPos).noBackground());
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
    }

    public List<? extends Widget> children() {
        return this.entries;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        double scrollbarPositionMinX;
        int actualHeight;
        double height = this.getMaxScroll();
        if (height > (double)(actualHeight = this.bounds.height) && double_2 >= (double)this.bounds.y && double_2 <= (double)this.bounds.getMaxY() && double_1 >= (scrollbarPositionMinX = (double)this.getScrollbarMinX()) - 1.0 & double_1 <= scrollbarPositionMinX + 8.0) {
            this.draggingScrollBar = true;
            return true;
        }
        this.draggingScrollBar = false;
        if (this.containsMouse(double_1, double_2)) {
            for (Widget widget : this.children()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    private class EntryListEntry
    extends EntryWidget {
        private int backupY;

        private EntryListEntry(int x, int y) {
            super(new Point(x, y));
            this.backupY = y;
            this.getBounds().width = this.getBounds().height = EntryListWidget.entrySize();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FavoritesListWidget.this.bounds.contains(mouseX, mouseY);
        }

        @Override
        protected void drawHighlighted(int mouseX, int mouseY, float delta) {
            if (!this.getCurrentEntry().isEmpty()) {
                super.drawHighlighted(mouseX, mouseY, delta);
            }
        }

        @Override
        protected boolean reverseFavoritesAction() {
            return true;
        }
    }
}

