/*
 * Copyright (c) 2018, 2019, 2020 shedaniel
 * Licensed under the MIT License (the "License").
 */

package me.shedaniel.rei.plugin.containers;

import me.shedaniel.rei.server.ContainerInfo;
import me.shedaniel.rei.server.RecipeFinder;
import net.minecraft.class_1703;
import net.minecraft.class_1729;
import net.minecraft.class_1799;

public class CraftingContainerInfoWrapper<T extends class_1729<?>> implements ContainerInfo<T> {
    private Class<? extends class_1729<?>> containerClass;
    
    public CraftingContainerInfoWrapper(Class<T> containerClass) {
        this.containerClass = containerClass;
    }
    
    public static <R extends class_1729<?>> ContainerInfo<R> create(Class<R> containerClass) {
        return new CraftingContainerInfoWrapper<>(containerClass);
    }
    
    @Override
    public Class<? extends class_1703> getContainerClass() {
        return containerClass;
    }
    
    @Override
    public int getCraftingResultSlotIndex(T container) {
        return container.method_7655();
    }
    
    @Override
    public int getCraftingWidth(T container) {
        return container.method_7653();
    }
    
    @Override
    public int getCraftingHeight(T container) {
        return container.method_7656();
    }
    
    @Override
    public void clearCraftingSlots(T container) {
        container.method_7657();
    }
    
    @Override
    public void populateRecipeFinder(T container, RecipeFinder var1) {
        container.method_7654(new net.minecraft.class_1662() {
            @Override
            public void method_7404(class_1799 itemStack_1) {
                var1.addNormalItem(itemStack_1);
            }
        });
    }
}
