/*
 * Copyright (c) 2018, 2019, 2020 shedaniel
 * Licensed under the MIT License (the "License").
 */

package me.shedaniel.rei.plugin.information;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.widget.*;
import me.shedaniel.rei.impl.RenderingEntry;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_341;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class DefaultInformationCategory implements RecipeCategory<DefaultInformationDisplay> {
    protected static void innerBlit(class_1159 matrix4f, int xStart, int xEnd, int yStart, int yEnd, int z, float uStart, float uEnd, float vStart, float vEnd) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(7, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, xStart, yEnd, z).method_22913(uStart, vEnd).method_1344();
        bufferBuilder.method_22918(matrix4f, xEnd, yEnd, z).method_22913(uEnd, vEnd).method_1344();
        bufferBuilder.method_22918(matrix4f, xEnd, yStart, z).method_22913(uEnd, vStart).method_1344();
        bufferBuilder.method_22918(matrix4f, xStart, yStart, z).method_22913(uStart, vStart).method_1344();
        bufferBuilder.method_1326();
        RenderSystem.enableAlphaTest();
        class_286.method_1309(bufferBuilder);
    }
    
    @Override
    public class_2960 getIdentifier() {
        return DefaultPlugin.INFO;
    }
    
    @Override
    public String getCategoryName() {
        return class_1074.method_4662("category.rei.information");
    }
    
    @Override
    public RecipeEntry getSimpleRenderer(DefaultInformationDisplay recipe) {
        class_2561 name = recipe.getName();
        return new RecipeEntry() {
            @Override
            public int getHeight() {
                return 10 + class_310.method_1551().field_1772.field_2000;
            }
            
            @Nullable
            @Override
            public QueuedTooltip getTooltip(int mouseX, int mouseY) {
                return null;
            }
            
            @Override
            public void render(Rectangle rectangle, int mouseX, int mouseY, float delta) {
                class_310.method_1551().field_1772.method_1729(name.method_10863(), rectangle.x + 5, rectangle.y + 6, -1);
            }
        };
    }
    
    @Override
    public EntryStack getLogo() {
        return new RenderingEntry() {
            @Override
            public void render(Rectangle bounds, int mouseX, int mouseY, float delta) {
                class_310.method_1551().method_1531().method_22813(DefaultPlugin.getDisplayTexture());
                class_1159 matrix4f = class_1159.method_24021(-1.2f, -1, 0);
                DefaultInformationCategory.innerBlit(matrix4f, bounds.getCenterX() - 8, bounds.getCenterX() + 8, bounds.getCenterY() - 8, bounds.getCenterY() + 8, 0, 116f / 256f, (116f + 16f) / 256f, 0f, 16f / 256f);
            }
        };
    }
    
    @Override
    public List<Widget> setupDisplay(Supplier<DefaultInformationDisplay> recipeDisplaySupplier, Rectangle bounds) {
        DefaultInformationDisplay display = recipeDisplaySupplier.get();
        List<Widget> widgets = Lists.newArrayList();
        widgets.add(LabelWidget.create(new Point(bounds.getCenterX(), bounds.y + 3), display.getName().method_10863()).noShadow().color(ScreenHelper.isDarkModeEnabled() ? 0xFFBBBBBB : 0xFF404040));
        widgets.add(EntryWidget.create(bounds.getCenterX() - 8, bounds.y + 15).entries(display.getEntryStacks()));
        Rectangle rectangle = new Rectangle(bounds.getCenterX() - (bounds.width / 2), bounds.y + 35, bounds.width, bounds.height - 40);
        widgets.add(new SlotBaseWidget(rectangle));
        widgets.add(new ScrollableTextWidget(rectangle, display.getTexts()));
        return widgets;
    }
    
    @Override
    public int getDisplayHeight() {
        return 140;
    }
    
    @Override
    public int getFixedRecipesPerPage() {
        return 1;
    }
    
    private static class ScrollableTextWidget extends WidgetWithBounds {
        private Rectangle bounds;
        private List<class_2561> texts;
        private double target;
        private double scroll;
        private long start;
        private long duration;
        
        public ScrollableTextWidget(Rectangle bounds, List<class_2561> texts) {
            this.bounds = bounds;
            this.texts = Lists.newArrayList();
            for (class_2561 text : texts) {
                if (!this.texts.isEmpty())
                    this.texts.add(null);
                this.texts.addAll(class_341.method_1850(text, bounds.width - 11, class_310.method_1551().field_1772, true, false));
            }
        }
        
        @Override
        public boolean mouseScrolled(double double_1, double double_2, double double_3) {
            if (containsMouse(double_1, double_2)) {
                offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
                return true;
            }
            return false;
        }
        
        public void offset(double value, boolean animated) {
            scrollTo(target + value, animated);
        }
        
        public void scrollTo(double value, boolean animated) {
            scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
        }
        
        public void scrollTo(double value, boolean animated, long duration) {
            target = clamp(value);
            
            if (animated) {
                start = System.currentTimeMillis();
                this.duration = duration;
            } else
                scroll = target;
        }
        
        public final double clamp(double v) {
            return clamp(v, DynamicEntryListWidget.SmoothScrollingSettings.CLAMP_EXTENSION);
        }
        
        public final double clamp(double v, double clampExtension) {
            return class_3532.method_15350(v, -clampExtension, getMaxScroll() + clampExtension);
        }
        
        protected int getMaxScroll() {
            return Math.max(0, this.getMaxScrollPosition() - this.getBounds().height + 4);
        }
        
        protected int getMaxScrollPosition() {
            int i = 0;
            for (class_2561 entry : texts) {
                i += entry == null ? 4 : font.field_2000;
            }
            return i;
        }
        
        @Override
        public Rectangle getBounds() {
            return bounds;
        }
        
        @Override
        public void render(int mouseX, int mouseY, float delta) {
            updatePosition(delta);
            Rectangle innerBounds = new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 7, bounds.height - 2);
            ScissorsHandler.INSTANCE.scissor(innerBounds);
            int currentY = (int) -scroll + innerBounds.y;
            for (class_2561 text : texts) {
                if (text != null && currentY + font.field_2000 >= innerBounds.y && currentY <= innerBounds.getMaxY()) {
                    font.method_1729(text.method_10863(), innerBounds.x + 2, currentY + 2, ScreenHelper.isDarkModeEnabled() ? 0xFFBBBBBB : 0xFF090909);
                }
                currentY += text == null ? 4 : font.field_2000;
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            ScissorsHandler.INSTANCE.scissor(bounds);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate(770, 771, 0, 1);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel(7425);
            RenderSystem.disableTexture();
            renderScrollBar();
            RenderSystem.enableTexture();
            RenderSystem.shadeModel(7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
            ScissorsHandler.INSTANCE.removeLastScissor();
        }
        
        @SuppressWarnings("deprecation")
        private void renderScrollBar() {
            int maxScroll = getMaxScroll();
            int scrollbarPositionMinX = getBounds().getMaxX() - 7;
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            if (maxScroll > 0) {
                int height = (int) (((this.getBounds().height - 2f) * (this.getBounds().height - 2f)) / this.getMaxScrollPosition());
                height = class_3532.method_15340(height, 32, this.getBounds().height - 2);
                height -= Math.min((scroll < 0 ? (int) -scroll : scroll > maxScroll ? (int) scroll - maxScroll : 0), height * .95);
                height = Math.max(10, height);
                int minY = Math.min(Math.max((int) scroll * (this.getBounds().height - 2 - height) / maxScroll + getBounds().y + 1, getBounds().y + 1), getBounds().getMaxY() - 1 - height);
                
                boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse());
                int bottomC = hovered ? 168 : 128;
                int topC = hovered ? 222 : 172;
                
                // Black Bar
                buffer.method_1328(7, class_290.field_1575);
                buffer.method_22912(scrollbarPositionMinX, this.getBounds().y + 1, 0.0D).method_22913(0, 1).method_1336(0, 0, 0, 255).method_1344();
                buffer.method_22912(scrollbarPositionMaxX, this.getBounds().y + 1, 0.0D).method_22913(1, 1).method_1336(0, 0, 0, 255).method_1344();
                buffer.method_22912(scrollbarPositionMaxX, getBounds().getMaxY() - 1, 0.0D).method_22913(1, 0).method_1336(0, 0, 0, 255).method_1344();
                buffer.method_22912(scrollbarPositionMinX, getBounds().getMaxY() - 1, 0.0D).method_22913(0, 0).method_1336(0, 0, 0, 255).method_1344();
                tessellator.method_1350();
                
                // Bottom
                buffer.method_1328(7, class_290.field_1575);
                buffer.method_22912(scrollbarPositionMinX, minY + height, 0.0D).method_22913(0, 1).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                buffer.method_22912(scrollbarPositionMaxX, minY + height, 0.0D).method_22913(1, 1).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                buffer.method_22912(scrollbarPositionMaxX, minY, 0.0D).method_22913(1, 0).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                buffer.method_22912(scrollbarPositionMinX, minY, 0.0D).method_22913(0, 0).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                tessellator.method_1350();
                
                // Top
                buffer.method_1328(7, class_290.field_1575);
                buffer.method_22912(scrollbarPositionMinX, (minY + height - 1), 0.0D).method_22913(0, 1).method_1336(topC, topC, topC, 255).method_1344();
                buffer.method_22912((scrollbarPositionMaxX - 1), (minY + height - 1), 0.0D).method_22913(1, 1).method_1336(topC, topC, topC, 255).method_1344();
                buffer.method_22912((scrollbarPositionMaxX - 1), minY, 0.0D).method_22913(1, 0).method_1336(topC, topC, topC, 255).method_1344();
                buffer.method_22912(scrollbarPositionMinX, minY, 0.0D).method_22913(0, 0).method_1336(topC, topC, topC, 255).method_1344();
                tessellator.method_1350();
            }
        }
        
        private void updatePosition(float delta) {
            double[] target = new double[]{this.target};
            this.scroll = ClothConfigInitializer.handleScrollingPosition(target, this.scroll, this.getMaxScroll(), delta, this.start, this.duration);
            this.target = target[0];
        }
        
        @Override
        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }
}
