/*
 * Copyright (c) 2018, 2019, 2020 shedaniel
 * Licensed under the MIT License (the "License").
 */

package me.shedaniel.rei.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.class_1011;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_276;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3306;
import net.minecraft.class_364;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class RecipeDisplayExporter extends Widget {
    private static final RecipeDisplayExporter INSTANCE = new RecipeDisplayExporter();
    
    private RecipeDisplayExporter() {}
    
    public static void exportRecipeDisplay(Rectangle rectangle, List<Widget> widgets) {
        INSTANCE.exportRecipe(rectangle, widgets);
    }
    
    private static File getExportFilename(File directory) {
        String string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        int i = 1;
        
        while (true) {
            File file = new File(directory, "REI_" + string + (i == 1 ? "" : "_" + i) + ".png");
            if (!file.exists()) {
                return file;
            }
            
            ++i;
        }
    }
    
    @SuppressWarnings("deprecation")
    private void exportRecipe(Rectangle rectangle, List<Widget> widgets) {
        class_276 framebuffer = new class_276(rectangle.width * 8, rectangle.height * 8, true, class_310.field_1703);
        framebuffer.method_1236(0, 0, 0, 0);
        //        int color = ScreenHelper.isDarkModeEnabled() ? -13750738 : -3750202;
        //        framebuffer.setClearColor(((color >> 16) & 0xFF) / 255f, ((color >> 8) & 0xFF) / 255f, (color & 0xFF) / 255f, ((color >> 24) & 0xFF) / 255f);
        framebuffer.method_1230(class_310.field_1703);
        RenderSystem.pushMatrix();
        //        RenderSystem.clear(16640, MinecraftClient.IS_SYSTEM_MAC);
        framebuffer.method_1235(true);
        
        // Fresh matrices
        //        RenderSystem.clear(256, MinecraftClient.IS_SYSTEM_MAC);
        RenderSystem.matrixMode(GL11.GL_PROJECTION);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        //        RenderSystem.ortho(0.0D, rectangle.width * 8, rectangle.height * 8, 0.0D, -1, 1);
        //        RenderSystem.scalef(1, -1,0);
        //        RenderSystem.ortho(-1, 1, 1, -1, -1, 1);
        //        RenderSystem.ortho(-1, 1, 1, -1, -1, 1);
        RenderSystem.matrixMode(GL11.GL_MODELVIEW);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        //        RenderSystem.translatef(0.0F, 0.0F, -2000.0F);
        //        RenderSystem.rotatef(180, 1, 0, 0);
        RenderSystem.scalef(2f / rectangle.width, -2f / rectangle.height, 0);
        //        RenderSystem.scalef(1f / rectangle.width, -1f / rectangle.height, 0);
        //        RenderSystem.translatef(10,10,0);
        RenderSystem.translatef(-rectangle.x, -rectangle.y, 0);
        //        RenderSystem.translatef(rectangle.x, rectangle.y, 0);
        RenderSystem.translatef(-rectangle.width / 2f, -rectangle.height / 2f, 0);
        
        //        RenderSystem.enableAlphaTest();
        //        RenderSystem.alphaFunc(516, 0.1F);
        //        RenderSystem.enableBlend();
        //        RenderSystem.blendFuncSeparate(GlStateManager.SrcFactor.ONE_MINUS_DST_ALPHA, GlStateManager.DstFactor.DST_ALPHA, GlStateManager.SrcFactor.ONE, GlStateManager.DstFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc(class_4493.class_4535.SRC_ALPHA, class_4493.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask(false);
        RenderSystem.disableCull();
        RenderSystem.pushLightingAttributes();
        for (Widget widget : widgets) {
            widget.render(-1, -1, minecraft.method_1488());
        }
        {
            class_1799 stack = new class_1799(class_1802.field_8212);
            final class_1087 model = minecraft.method_1480().method_4019(stack, minecraft.field_1687, minecraft.field_1724);
            minecraft.method_1531().method_22813(class_1059.field_5275);
            minecraft.method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
            
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc(class_4493.class_4535.SRC_ALPHA, class_4493.class_4534.ONE_MINUS_SRC_ALPHA);
            
            RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
            class_4587 matrixStack = new class_4587();
            
            matrixStack.method_22904(rectangle.x + 8, rectangle.y + 8, 0);
            matrixStack.method_22905(16, -16, 1F);
            
            boolean disableGuiLight = !model.method_24304();
            if (disableGuiLight) {
                class_308.method_24210();
            }
            
            class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
            minecraft.method_1480().method_23179(stack, class_809.class_811.field_4317, false, matrixStack, immediate, 15728880, class_4608.field_21444, model);
            immediate.method_22993();
            
            RenderSystem.enableDepthTest();
            
            if (disableGuiLight) {
                class_308.method_24211();
            }
            
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
        }
        //        fillGradient(0, 0, 10, 10, -1, -1);
        //        fillGradient(rectangle.x, rectangle.y, rectangle.x + 10, rectangle.y + 10, -16777216, -16777216);
        RenderSystem.depthMask(true);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        //        RenderSystem.disableAlphaTest();
        //        RenderSystem.disableBlend();
        
        // Reset matrices
        RenderSystem.matrixMode(GL11.GL_PROJECTION);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode(GL11.GL_MODELVIEW);
        RenderSystem.popMatrix();
        
        framebuffer.method_1240();
        RenderSystem.popMatrix();
        RenderSystem.viewport(0, 0, minecraft.method_22683().method_4489(), minecraft.method_22683().method_4506());
        
        class_1011 nativeImage = new class_1011(rectangle.width * 8, rectangle.height * 8, false);
        RenderSystem.bindTexture(framebuffer.field_1475);
        nativeImage.method_4327(0, false);
        {
            int width = rectangle.width * 8;
            int height = rectangle.height * 8;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (x > 24 && x < width - 24 && y > 24 && y < height - 24)
                        nativeImage.method_4305(x, y, nativeImage.method_4315(x, y) | 255 << class_1011.class_1012.field_4997.method_4332());
                }
            }
        }
        
        nativeImage.method_4319();
        class_3306.field_14301.execute(() -> {
            try {
                File export = new File(minecraft.field_1697, "export");
                //noinspection ResultOfMethodCallIgnored
                export.mkdirs();
                nativeImage.method_4325(getExportFilename(export));
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                nativeImage.close();
                RenderSystem.recordRenderCall(framebuffer::method_1238);
            }
        });
    }
    
    @Override
    public void render(int mouseX, int mouseY, float delta) {
    
    }
    
    @Override
    public List<? extends class_364> children() {
        return null;
    }
}
