/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.entries.SimpleRecipeEntry;
import me.shedaniel.rei.gui.widget.PanelWidget;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.ApiStatus;

public interface RecipeCategory<T extends RecipeDisplay> {
    public class_2960 getIdentifier();

    default public EntryStack getLogo() {
        return EntryStack.empty();
    }

    public String getCategoryName();

    @ApiStatus.OverrideOnly
    default public RecipeEntry getSimpleRenderer(T recipe) {
        return SimpleRecipeEntry.create(() -> recipe.getInputEntries(), () -> recipe.getOutputEntries());
    }

    @ApiStatus.OverrideOnly
    default public List<Widget> setupDisplay(Supplier<T> recipeDisplaySupplier, Rectangle bounds) {
        return Collections.singletonList(new RecipeBaseWidget(bounds));
    }

    @ApiStatus.OverrideOnly
    default public void drawCategoryBackground(Rectangle bounds, int mouseX, int mouseY, float delta) {
        PanelWidget.render(bounds, -1);
        if (ScreenHelper.isDarkModeEnabled()) {
            class_332.fill((int)(bounds.x + 17), (int)(bounds.y + 5), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 17), (int)-12566464);
            class_332.fill((int)(bounds.x + 17), (int)(bounds.y + 19), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 31), (int)-12566464);
        } else {
            class_332.fill((int)(bounds.x + 17), (int)(bounds.y + 5), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 17), (int)-6381922);
            class_332.fill((int)(bounds.x + 17), (int)(bounds.y + 19), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 31), (int)-6381922);
        }
    }

    default public int getDisplayHeight() {
        return 66;
    }

    default public int getDisplayWidth(T display) {
        return 150;
    }

    default public int getMaximumRecipePerPage() {
        return 99;
    }

    default public int getFixedRecipesPerPage() {
        return -1;
    }
}

