/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.OptimalEntryStack;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.SearchArgument;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_1269;
import net.minecraft.class_1761;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EntryListWidget
extends WidgetWithBounds {
    static final Supplier<Boolean> RENDER_ENCHANTMENT_GLINT = ConfigObject.getInstance()::doesRenderEntryEnchantmentGlint;
    static final Comparator<? super EntryStack> ENTRY_NAME_COMPARER = Comparator.comparing(SearchArgument::tryGetEntryStackName);
    static final Comparator<? super EntryStack> ENTRY_GROUP_COMPARER = Comparator.comparingInt(stack -> {
        class_1761 group;
        if (stack.getType() == EntryStack.Type.ITEM && (group = stack.getItem().method_7859()) != null) {
            return group.method_7741();
        }
        return Integer.MAX_VALUE;
    });
    private static final int SIZE = 18;
    private static final boolean LAZY = true;
    private static int page;
    protected double target;
    protected double scroll;
    protected long start;
    protected long duration;
    protected int blockedCount;
    private boolean debugTime;
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryStack> allStacks = null;
    private List<EntryStack> favorites = null;
    private List<EntryListEntry> entries = Collections.emptyList();
    private List<Widget> renders = Collections.emptyList();
    private List<Widget> widgets = Collections.emptyList();
    private List<SearchArgument.SearchArguments> lastSearchArguments = Collections.emptyList();
    private String lastSearchTerm = null;
    private boolean draggingScrollBar = false;

    public static int entrySize() {
        return class_3532.method_15384((double)(18.0 * ConfigObject.getInstance().getEntrySize()));
    }

    static boolean notSteppingOnExclusionZones(int left, int top, Rectangle listArea) {
        class_310 instance = class_310.method_1551();
        for (DisplayHelper.DisplayBoundsHandler<?> sortedBoundsHandler : DisplayHelper.getInstance().getSortedBoundsHandlers(instance.field_1755.getClass())) {
            class_1269 fit = sortedBoundsHandler.canItemSlotWidgetFit(left, top, instance.field_1755, listArea);
            if (fit == class_1269.field_5811) continue;
            return fit == class_1269.field_5812;
        }
        return true;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) + 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
            }
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) - 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
        }
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2) / (float)EntryListWidget.entrySize())), 1);
        int height = Math.max(class_3532.method_15375((float)((float)(bounds.height - 2) / (float)EntryListWidget.entrySize())), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f)), (int)((float)bounds.getCenterY() - (float)height * ((float)EntryListWidget.entrySize() / 2.0f)), width * EntryListWidget.entrySize(), height * EntryListWidget.entrySize());
    }

    protected final int getSlotsHeightNumberForFavorites() {
        if (this.favorites.isEmpty()) {
            return 0;
        }
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return class_3532.method_15386((float)(2.0f + (float)this.favorites.size() / ((float)this.innerBounds.width / (float)EntryListWidget.entrySize())));
        }
        int height = class_3532.method_15386((float)((float)this.favorites.size() / ((float)this.innerBounds.width / (float)EntryListWidget.entrySize())));
        int pagesToFit = class_3532.method_15386((float)((float)height / ((float)this.innerBounds.height / (float)EntryListWidget.entrySize() - 1.0f)));
        if (height > this.innerBounds.height / EntryListWidget.entrySize() - 1 && height % (this.innerBounds.height / EntryListWidget.entrySize()) == this.innerBounds.height / EntryListWidget.entrySize() - 2) {
            --height;
        }
        return height + pagesToFit + 1;
    }

    protected final int getScrollNumberForFavorites() {
        if (this.favorites.isEmpty()) {
            return 0;
        }
        return this.innerBounds.width / EntryListWidget.entrySize() * this.getSlotsHeightNumberForFavorites();
    }

    protected final int getMaxScrollPosition() {
        if (this.favorites.isEmpty()) {
            return class_3532.method_15386((float)((float)(this.allStacks.size() + this.blockedCount) / ((float)this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }
        return class_3532.method_15386((float)((float)(this.allStacks.size() + this.blockedCount + this.getScrollNumberForFavorites()) / ((float)this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize() - 12;
    }

    protected final int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - this.innerBounds.height);
    }

    protected final double clamp(double v) {
        return this.clamp(v, 200.0);
    }

    protected final double clamp(double v, double clampExtension) {
        return class_3532.method_15350((double)v, (double)(-clampExtension), (double)((double)this.getMaxScroll() + clampExtension));
    }

    protected final void offset(double value, boolean animated) {
        this.scrollTo(this.target + value, animated);
    }

    protected final void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    protected final void scrollTo(double value, boolean animated, long duration) {
        this.target = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scroll = this.target;
        }
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.bounds.contains(double_1, double_2)) {
            this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        EntryListWidget.page = page;
    }

    public void previousPage() {
        --page;
    }

    public void nextPage() {
        ++page;
    }

    public int getTotalPages() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return 1;
        }
        return class_3532.method_15386((float)((float)(this.allStacks.size() + this.getScrollNumberForFavorites()) / (float)this.entries.size()));
    }

    /*
     * WARNING - void declaration
     */
    public void render(int mouseX, int mouseY, float delta) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int nextIndex;
            for (EntryListEntry entryListEntry2 : this.entries) {
                entryListEntry2.clearStacks();
            }
            ScissorsHandler.INSTANCE.scissor(this.bounds);
            int sizeForFavorites = this.getSlotsHeightNumberForFavorites();
            int n = Math.max(0, class_3532.method_15357((double)(this.scroll / (double)EntryListWidget.entrySize())) - sizeForFavorites);
            int i = nextIndex = n * this.innerBounds.width / EntryListWidget.entrySize();
            this.blockedCount = 0;
            if (this.debugTime) {
                void var10_29;
                int offset;
                long l;
                EntryListEntry entry;
                long totalTimeStart = System.nanoTime();
                boolean bl = false;
                long time = 0L;
                if (sizeForFavorites > 0) {
                    this.drawString(this.font, class_1074.method_4662((String)"text.rei.favorites", (Object[])new Object[0]), this.innerBounds.x + 2, (int)((double)(this.innerBounds.y + 8) - this.scroll), -1);
                    nextIndex += this.innerBounds.width / EntryListWidget.entrySize();
                    block1: for (EntryStack stack : this.favorites) {
                        while (true) {
                            entry = this.entries.get(nextIndex);
                            entry.getBounds().y = (int)((double)entry.backupY - this.scroll);
                            if (entry.getBounds().y > this.bounds.getMaxY()) break block1;
                            if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                                void var10_28;
                                entry.entry(stack);
                                entry.isFavorites = true;
                                ++var10_28;
                                l = System.currentTimeMillis();
                                entry.render(mouseX, mouseY, delta);
                                time += System.currentTimeMillis() - l;
                                ++nextIndex;
                                continue block1;
                            }
                            ++this.blockedCount;
                            ++nextIndex;
                        }
                    }
                    nextIndex += this.innerBounds.width / -EntryListWidget.entrySize() + this.getScrollNumberForFavorites() - this.favorites.size();
                }
                int n2 = offset = sizeForFavorites > 0 ? -12 : 0;
                block3: while (i < this.allStacks.size()) {
                    EntryStack stack;
                    stack = this.allStacks.get(i);
                    while (true) {
                        entry = this.entries.get(nextIndex);
                        entry.getBounds().y = (int)((double)entry.backupY - this.scroll + (double)offset);
                        if (entry.getBounds().y > this.bounds.getMaxY()) break block3;
                        if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                            entry.entry(stack);
                            entry.isFavorites = false;
                            if (!entry.getCurrentEntry().isEmpty()) {
                                ++var10_29;
                                l = System.nanoTime();
                                entry.render(mouseX, mouseY, delta);
                                time += System.nanoTime() - l;
                            }
                            ++nextIndex;
                            break;
                        }
                        ++this.blockedCount;
                        ++nextIndex;
                    }
                    ++i;
                }
                long totalTime = System.nanoTime() - totalTimeStart;
                int z = this.getZ();
                this.setZ(500);
                String str = String.format("%d entries, avg. %.0fns, ttl. %.0fms, %s fps", (int)var10_29, (double)time / (double)var10_29, (double)totalTime / 1000000.0, this.minecraft.field_1770.split(" ")[0]);
                int n3 = this.bounds.x;
                int n4 = this.bounds.y;
                int n5 = this.bounds.x + this.font.method_1727(str) + 2;
                int n6 = this.bounds.y;
                this.font.getClass();
                this.fillGradient(n3, n4, n5, n6 + 9 + 2, -16777216, -16777216);
                class_4587 matrixStack_1 = new class_4587();
                class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                matrixStack_1.method_22904(0.0, 0.0, (double)this.getZ());
                class_1159 matrix4f_1 = matrixStack_1.method_23760().method_23761();
                this.font.method_22942(str, (float)(this.bounds.x + 2), (float)(this.bounds.y + 2), -1, false, matrix4f_1, (class_4597)immediate, false, 0, 0xF000F0);
                immediate.method_22993();
                this.setZ(z);
            } else {
                int offset;
                if (sizeForFavorites > 0) {
                    this.drawString(this.font, class_1074.method_4662((String)"text.rei.favorites", (Object[])new Object[0]), this.innerBounds.x + 2, (int)((double)(this.innerBounds.y + 8) - this.scroll), -1);
                    nextIndex += this.innerBounds.width / EntryListWidget.entrySize();
                    block5: for (EntryStack stack : this.favorites) {
                        while (true) {
                            EntryListEntry entryListEntry3 = this.entries.get(nextIndex);
                            entryListEntry3.getBounds().y = (int)((double)entryListEntry3.backupY - this.scroll);
                            if (entryListEntry3.getBounds().y > this.bounds.getMaxY()) break block5;
                            if (EntryListWidget.notSteppingOnExclusionZones(entryListEntry3.getBounds().x, entryListEntry3.getBounds().y, this.innerBounds)) {
                                entryListEntry3.entry(stack);
                                entryListEntry3.isFavorites = true;
                                entryListEntry3.render(mouseX, mouseY, delta);
                                ++nextIndex;
                                continue block5;
                            }
                            ++this.blockedCount;
                            ++nextIndex;
                        }
                    }
                    nextIndex += this.innerBounds.width / -EntryListWidget.entrySize() + this.getScrollNumberForFavorites() - this.favorites.size();
                }
                int n7 = offset = sizeForFavorites > 0 ? -12 : 0;
                block7: while (i < this.allStacks.size()) {
                    EntryStack stack;
                    stack = this.allStacks.get(i);
                    while (true) {
                        EntryListEntry entryListEntry4 = this.entries.get(nextIndex);
                        entryListEntry4.getBounds().y = (int)((double)entryListEntry4.backupY - this.scroll + (double)offset);
                        if (entryListEntry4.getBounds().y > this.bounds.getMaxY()) break block7;
                        if (EntryListWidget.notSteppingOnExclusionZones(entryListEntry4.getBounds().x, entryListEntry4.getBounds().y, this.innerBounds)) {
                            entryListEntry4.entry(stack);
                            entryListEntry4.isFavorites = false;
                            entryListEntry4.render(mouseX, mouseY, delta);
                            ++nextIndex;
                            break;
                        }
                        ++this.blockedCount;
                        ++nextIndex;
                    }
                    ++i;
                }
            }
            this.updatePosition(delta);
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.renderScrollbar();
        } else if (this.debugTime) {
            int size = 0;
            long l = 0L;
            for (Widget widget : this.renders) {
                widget.render(mouseX, mouseY, delta);
            }
            long totalTimeStart = System.nanoTime();
            if (ConfigObject.getInstance().doesFastEntryRendering()) {
                for (Map.Entry entry : this.entries.stream().collect(Collectors.groupingBy(entryListEntry -> entryListEntry.getCurrentEntry().getClass())).entrySet()) {
                    List list = (List)entry.getValue();
                    if (list.isEmpty()) continue;
                    EntryListEntry firstWidget = (EntryListEntry)((Object)list.get(0));
                    EntryStack first = firstWidget.getCurrentEntry();
                    if (first instanceof OptimalEntryStack) {
                        EntryStack currentEntry;
                        OptimalEntryStack firstStack = (OptimalEntryStack)((Object)first);
                        firstStack.optimisedRenderStart(delta);
                        long l2 = System.nanoTime();
                        for (EntryListEntry listEntry : list) {
                            currentEntry = listEntry.getCurrentEntry();
                            currentEntry.setZ(100);
                            listEntry.drawBackground(mouseX, mouseY, delta);
                            ((OptimalEntryStack)((Object)currentEntry)).optimisedRenderBase(listEntry.getInnerBounds(), mouseX, mouseY, delta);
                            if (currentEntry.isEmpty()) continue;
                            ++size;
                        }
                        for (EntryListEntry listEntry : list) {
                            currentEntry = listEntry.getCurrentEntry();
                            ((OptimalEntryStack)((Object)currentEntry)).optimisedRenderOverlay(listEntry.getInnerBounds(), mouseX, mouseY, delta);
                            if (!listEntry.containsMouse(mouseX, mouseY)) continue;
                            listEntry.queueTooltip(mouseX, mouseY, delta);
                            listEntry.drawHighlighted(mouseX, mouseY, delta);
                        }
                        l += System.nanoTime() - l2;
                        firstStack.optimisedRenderEnd(delta);
                        continue;
                    }
                    for (EntryListEntry listEntry : list) {
                        if (listEntry.getCurrentEntry().isEmpty()) continue;
                        ++size;
                        long l3 = System.nanoTime();
                        listEntry.render(mouseX, mouseY, delta);
                        l += System.nanoTime() - l3;
                    }
                }
            } else {
                for (EntryListEntry entryListEntry5 : this.entries) {
                    if (entryListEntry5.getCurrentEntry().isEmpty()) continue;
                    ++size;
                    long l4 = System.nanoTime();
                    entryListEntry5.render(mouseX, mouseY, delta);
                    l += System.nanoTime() - l4;
                }
            }
            long totalTime = System.nanoTime() - totalTimeStart;
            int z = this.getZ();
            this.setZ(500);
            String str = String.format("%d entries, avg. %.0fns, ttl. %.0fms, %s fps", size, (double)l / (double)size, (double)totalTime / 1000000.0, this.minecraft.field_1770.split(" ")[0]);
            int stringWidth = this.font.method_1727(str);
            int n = Math.min(this.bounds.x, this.minecraft.field_1755.width - stringWidth - 2);
            int n8 = this.bounds.y;
            int n9 = this.bounds.x + stringWidth + 2;
            int n10 = this.bounds.y;
            this.font.getClass();
            this.fillGradient(n, n8, n9, n10 + 9 + 2, -16777216, -16777216);
            class_4587 matrixStack_1 = new class_4587();
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            matrixStack_1.method_22904(0.0, 0.0, (double)this.getZ());
            class_1159 matrix4f_1 = matrixStack_1.method_23760().method_23761();
            this.font.method_22942(str, (float)Math.min(this.bounds.x + 2, this.minecraft.field_1755.width - stringWidth), (float)(this.bounds.y + 2), -1, false, matrix4f_1, (class_4597)immediate, false, 0, 0xF000F0);
            immediate.method_22993();
            this.setZ(z);
        } else {
            for (Widget widget : this.renders) {
                widget.render(mouseX, mouseY, delta);
            }
            if (ConfigObject.getInstance().doesFastEntryRendering()) {
                for (Map.Entry entry : this.entries.stream().collect(Collectors.groupingBy(entryListEntry -> entryListEntry.getCurrentEntry().getClass())).entrySet()) {
                    List list = (List)entry.getValue();
                    if (list.isEmpty()) continue;
                    EntryListEntry firstWidget = (EntryListEntry)((Object)list.get(0));
                    EntryStack first = firstWidget.getCurrentEntry();
                    if (first instanceof OptimalEntryStack) {
                        EntryStack currentEntry;
                        OptimalEntryStack firstStack = (OptimalEntryStack)((Object)first);
                        firstStack.optimisedRenderStart(delta);
                        for (EntryListEntry listEntry : list) {
                            currentEntry = listEntry.getCurrentEntry();
                            currentEntry.setZ(100);
                            listEntry.drawBackground(mouseX, mouseY, delta);
                            ((OptimalEntryStack)((Object)currentEntry)).optimisedRenderBase(listEntry.getInnerBounds(), mouseX, mouseY, delta);
                        }
                        for (EntryListEntry listEntry : list) {
                            currentEntry = listEntry.getCurrentEntry();
                            ((OptimalEntryStack)((Object)currentEntry)).optimisedRenderOverlay(listEntry.getInnerBounds(), mouseX, mouseY, delta);
                            if (!listEntry.containsMouse(mouseX, mouseY)) continue;
                            listEntry.queueTooltip(mouseX, mouseY, delta);
                            listEntry.drawHighlighted(mouseX, mouseY, delta);
                        }
                        firstStack.optimisedRenderEnd(delta);
                        continue;
                    }
                    for (EntryListEntry entryListEntry6 : list) {
                        if (entryListEntry6.getCurrentEntry().isEmpty()) continue;
                        entryListEntry6.render(mouseX, mouseY, delta);
                    }
                }
            } else {
                for (EntryListEntry entryListEntry7 : this.entries) {
                    if (entryListEntry7.getCurrentEntry().isEmpty()) continue;
                    entryListEntry7.render(mouseX, mouseY, delta);
                }
            }
        }
        if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating() && !this.minecraft.field_1724.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(class_1074.method_4662((String)"text.rei.delete_items", (Object[])new Object[0])));
        }
    }

    private int getScrollbarMinX() {
        if (ConfigObject.getInstance().isLeftHandSidePanel()) {
            return this.bounds.x + 1;
        }
        return this.bounds.getMaxX() - 7;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        int actualHeight;
        float height;
        if (int_1 == 0 && this.draggingScrollBar && (height = (float)this.getMaxScrollPosition()) > (float)(actualHeight = this.innerBounds.height) && mouseY >= (double)this.innerBounds.y && mouseY <= (double)this.innerBounds.getMaxY()) {
            double double_5 = Math.max(1, this.getMaxScroll());
            int int_2 = this.innerBounds.height;
            int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
            double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
            float to = class_3532.method_15363((float)((float)(this.scroll + double_4 * double_6)), (float)0.0f, (float)(height - (float)this.innerBounds.height));
            if (ConfigObject.getInstance().doesSnapToRows()) {
                double nearestRow = (double)Math.round((double)to / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
                this.scrollTo(nearestRow, false);
            } else {
                this.scrollTo(to, false);
            }
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    private void renderScrollbar() {
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int height = this.innerBounds.height * this.innerBounds.height / this.getMaxScrollPosition();
            height = class_3532.method_15340((int)height, (int)32, (int)(this.innerBounds.height - 8));
            height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)maxScroll ? (int)this.scroll - maxScroll : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.scroll * (this.innerBounds.height - height) / maxScroll + this.innerBounds.y, this.innerBounds.y), this.innerBounds.getMaxY() - height);
            int scrollbarPositionMinX = this.getScrollbarMinX();
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse());
            float bottomC = (hovered ? 0.67f : 0.5f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
            float topC = (hovered ? 0.87f : 0.67f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.shadeModel((int)7425);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height), 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            tessellator.method_1350();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            tessellator.method_1350();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.target >= 0.0 && this.target <= (double)this.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.target / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.target = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.target, (double)nearestRow, (double)0.001f) ? (this.target += (nearestRow - this.target) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        double[] targetD = new double[]{this.target};
        this.scroll = ClothConfigInitializer.handleScrollingPosition((double[])targetD, (double)this.scroll, (double)this.getMaxScroll(), (float)delta, (double)this.start, (double)this.duration);
        this.target = targetD[0];
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.fromMouse())) {
            for (Widget widget : this.widgets) {
                if (!widget.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(DisplayHelper.DisplayBoundsHandler<?> boundsHandler, @Nullable String searchTerm) {
        this.bounds = boundsHandler.getItemListArea(ScreenHelper.getLastOverlay().getBounds());
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(boundsHandler, searchTerm);
        }
        if (searchTerm != null) {
            this.updateSearch(searchTerm, true);
        } else if (this.allStacks == null || this.favorites == null || favoritesListWidget != null && favoritesListWidget.favorites == null) {
            this.updateSearch("", true);
        } else {
            this.updateEntriesPosition();
        }
    }

    public void updateEntriesPosition() {
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.renders = Lists.newArrayList();
            page = Math.max(page, 0);
            ArrayList entries = Lists.newArrayList();
            int width = this.innerBounds.width / EntryListWidget.entrySize();
            int height = this.innerBounds.height / EntryListWidget.entrySize();
            for (int currentY = 0; currentY < height; ++currentY) {
                for (int currentX = 0; currentX < width; ++currentX) {
                    if (!EntryListWidget.notSteppingOnExclusionZones(currentX * EntryListWidget.entrySize() + this.innerBounds.x, currentY * EntryListWidget.entrySize() + this.innerBounds.y, this.innerBounds)) continue;
                    entries.add((EntryListEntry)new EntryListEntry(currentX * EntryListWidget.entrySize() + this.innerBounds.x, currentY * EntryListWidget.entrySize() + this.innerBounds.y).noBackground());
                }
            }
            page = Math.max(Math.min(page, this.getTotalPages() - 1), 0);
            int numberForFavorites = this.getScrollNumberForFavorites();
            List subList = this.allStacks.stream().skip(Math.max(0, page * entries.size() - numberForFavorites)).limit(Math.max(0, entries.size() - Math.max(0, numberForFavorites - page * entries.size()))).collect(Collectors.toList());
            for (int i = 0; i < subList.size(); ++i) {
                EntryStack stack = (EntryStack)subList.get(i);
                ((EntryListEntry)((Object)entries.get(i + Math.max(0, numberForFavorites - page * entries.size())))).clearStacks().entry(stack);
                ((EntryListEntry)((Object)entries.get(i + Math.max(0, numberForFavorites - page * entries.size())))).isFavorites = false;
            }
            this.entries = entries;
            if (numberForFavorites > 0) {
                int skippedFavorites = page * (entries.size() - width);
                int j = 0;
                if (skippedFavorites < this.favorites.size()) {
                    this.renders.add(LabelWidget.create(new Point(this.innerBounds.x + 2, this.innerBounds.y + 6), class_1074.method_4662((String)"text.rei.favorites", (Object[])new Object[0])).leftAligned());
                    j += width;
                }
                List subFavoritesList = this.favorites.stream().skip(skippedFavorites).limit(Math.max(0, entries.size() - width)).collect(Collectors.toList());
                for (EntryStack stack : subFavoritesList) {
                    ((EntryListEntry)((Object)entries.get(j))).clearStacks().entry(stack);
                    ((EntryListEntry)((Object)entries.get(j))).isFavorites = true;
                    ++j;
                }
            }
            this.widgets = Lists.newArrayList(this.renders);
            this.widgets.addAll(entries);
        } else {
            page = 0;
            int width = this.innerBounds.width / EntryListWidget.entrySize();
            int pageHeight = this.innerBounds.height / EntryListWidget.entrySize();
            int sizeForFavorites = this.getScrollNumberForFavorites();
            int slotsToPrepare = Math.max(this.allStacks.size() * 3 + sizeForFavorites * 3, width * pageHeight * 3);
            int currentX = 0;
            int currentY = 0;
            ArrayList entries = Lists.newArrayList();
            for (int i = 0; i < slotsToPrepare; ++i) {
                int xPos = currentX * EntryListWidget.entrySize() + this.innerBounds.x;
                int yPos = currentY * EntryListWidget.entrySize() + this.innerBounds.y;
                entries.add((EntryListEntry)new EntryListEntry(xPos, yPos).noBackground());
                if (++currentX < width) continue;
                currentX = 0;
                ++currentY;
            }
            this.entries = entries;
            this.widgets = Lists.newArrayList(this.renders);
            this.widgets.addAll(entries);
        }
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateEntriesPosition();
        }
    }

    @ApiStatus.Internal
    public List<EntryStack> getAllStacks() {
        return this.allStacks;
    }

    public void updateSearch(String searchTerm) {
        this.updateSearch(searchTerm, true);
    }

    public void updateSearch(String searchTerm, boolean ignoreLastSearch) {
        List<EntryStack> workingItems;
        boolean checkCraftable;
        ArrayList list;
        long started = System.nanoTime();
        if (ignoreLastSearch || this.lastSearchTerm == null || !this.lastSearchTerm.equals(searchTerm)) {
            ItemListOrdering ordering;
            this.lastSearchTerm = searchTerm;
            this.lastSearchArguments = SearchArgument.processSearchTerm(searchTerm);
            list = Lists.newArrayList();
            checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
            workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
            List<EntryStack> stacks = EntryRegistry.getInstance().getPreFilteredList();
            if (stacks instanceof CopyOnWriteArrayList && !stacks.isEmpty()) {
                if (ConfigObject.getInstance().shouldAsyncSearch()) {
                    int size = ConfigObject.getInstance().getNumberAsyncSearch();
                    ArrayList completableFutures = Lists.newArrayList();
                    for (int i = 0; i < stacks.size(); i += size) {
                        int[] start = new int[]{i};
                        completableFutures.add(CompletableFuture.supplyAsync(() -> {
                            int end = Math.min(stacks.size() - 1, start[0] + size);
                            ArrayList filtered = Lists.newArrayList();
                            while (start[0] < end) {
                                EntryStack stack = (EntryStack)stacks.get(start[0]);
                                if (this.canLastSearchTermsBeAppliedTo(stack) && (workingItems == null || CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(workingItems, stack) != null)) {
                                    filtered.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
                                }
                                start[0] = start[0] + 1;
                            }
                            return filtered;
                        }));
                    }
                    try {
                        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        e.printStackTrace();
                    }
                    for (CompletableFuture future : completableFutures) {
                        List now = future.getNow(null);
                        if (now == null) continue;
                        list.addAll(now);
                    }
                } else {
                    for (EntryStack stack : stacks) {
                        if (!this.canLastSearchTermsBeAppliedTo(stack) || workingItems != null && CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(workingItems, stack) == null) continue;
                        list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
                    }
                }
            }
            if ((ordering = ConfigObject.getInstance().getItemListOrdering()) == ItemListOrdering.name) {
                list.sort(ENTRY_NAME_COMPARER);
            }
            if (ordering == ItemListOrdering.item_groups) {
                list.sort(ENTRY_GROUP_COMPARER);
            }
            if (!ConfigObject.getInstance().isItemListAscending()) {
                Collections.reverse(list);
            }
            this.allStacks = list;
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && !ConfigObject.getInstance().doDisplayFavoritesOnTheLeft()) {
            list = Lists.newArrayList();
            checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
            workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
            for (EntryStack stack : ConfigObject.getInstance().getFavorites()) {
                if (!this.canLastSearchTermsBeAppliedTo(stack) || workingItems != null && CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(workingItems, stack) == null) continue;
                list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
            }
            ItemListOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
            if (ordering == ItemListOrdering.name) {
                list.sort(ENTRY_NAME_COMPARER);
            }
            if (ordering == ItemListOrdering.item_groups) {
                list.sort(ENTRY_GROUP_COMPARER);
            }
            if (!ConfigObject.getInstance().isItemListAscending()) {
                Collections.reverse(list);
            }
            this.favorites = list;
        } else {
            this.favorites = Collections.emptyList();
        }
        this.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateSearch(this, searchTerm);
        }
        long ended = System.nanoTime();
        long time = ended - started;
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            RoughlyEnoughItemsCore.LOGGER.info("[REI] Search Used: %.2fms", (Object)((double)time * 1.0E-6));
        }
        this.updateEntriesPosition();
    }

    public boolean canLastSearchTermsBeAppliedTo(EntryStack stack) {
        return this.lastSearchArguments.isEmpty() || SearchArgument.canSearchTermsBeAppliedTo(stack, this.lastSearchArguments);
    }

    public List<? extends Widget> children() {
        return this.widgets;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            double scrollbarPositionMinX;
            int n;
            double height = this.getMaxScroll();
            if (height > (double)(n = this.bounds.height) && double_2 >= (double)this.bounds.y && double_2 <= (double)this.bounds.getMaxY() && double_1 >= (scrollbarPositionMinX = (double)this.getScrollbarMinX()) - 1.0 & double_1 <= scrollbarPositionMinX + 8.0) {
                this.draggingScrollBar = true;
                return true;
            }
            this.draggingScrollBar = false;
        }
        if (this.containsMouse(double_1, double_2)) {
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
            for (Widget widget : this.children()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    private class EntryListEntry
    extends EntryWidget {
        private int backupY;
        private boolean isFavorites;

        private EntryListEntry(int x, int y) {
            super(new Point(x, y));
            this.backupY = y;
            this.getBounds().width = this.getBounds().height = EntryListWidget.entrySize();
        }

        @Override
        public void drawBackground(int mouseX, int mouseY, float delta) {
            super.drawBackground(mouseX, mouseY, delta);
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && EntryListWidget.this.bounds.contains(mouseX, mouseY);
        }

        @Override
        public void drawHighlighted(int mouseX, int mouseY, float delta) {
            if (this.getCurrentEntry().getType() != EntryStack.Type.EMPTY) {
                super.drawHighlighted(mouseX, mouseY, delta);
            }
        }

        @Override
        public void queueTooltip(int mouseX, int mouseY, float delta) {
            if (!ClientHelper.getInstance().isCheating() || this.minecraft.field_1724.field_7514.method_7399().method_7960()) {
                super.queueTooltip(mouseX, mouseY, delta);
            }
        }

        @Override
        protected boolean reverseFavoritesAction() {
            return this.isFavorites;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            EntryStack entry;
            if (!this.interactable) {
                return super.mouseClicked(mouseX, mouseY, button);
            }
            if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating() && !(entry = this.getCurrentEntry().copy()).isEmpty()) {
                if (entry.getType() == EntryStack.Type.ITEM) {
                    entry.setAmount(button != 1 && !class_437.hasShiftDown() ? 1 : entry.getItemStack().method_7914());
                }
                ClientHelper.getInstance().tryCheatingEntry(entry);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }
}

