/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;

public class EntryWidget
extends WidgetWithBounds {
    protected static final class_2960 RECIPE_GUI = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    protected static final class_2960 RECIPE_GUI_DARK = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer_dark.png");
    protected boolean highlight = true;
    protected boolean tooltips = true;
    protected boolean background = true;
    protected boolean interactable = true;
    protected boolean interactableFavorites = true;
    private Rectangle bounds;
    private List<EntryStack> entryStacks;

    protected EntryWidget(int x, int y) {
        this(new Point(x, y));
    }

    protected EntryWidget(Point point) {
        this.bounds = new Rectangle(point.x - 1, point.y - 1, 18, 18);
        this.entryStacks = new ArrayList<EntryStack>();
    }

    public static EntryWidget create(int x, int y) {
        return EntryWidget.create(new Point(x, y));
    }

    public static EntryWidget create(Point point) {
        return new EntryWidget(point);
    }

    public EntryWidget disableInteractions() {
        return this.interactable(false);
    }

    public EntryWidget interactable(boolean b) {
        this.interactable = b;
        this.interactableFavorites = this.interactableFavorites && this.interactable;
        return this;
    }

    public EntryWidget disableFavoritesInteractions() {
        return this.interactableFavorites(false);
    }

    public EntryWidget interactableFavorites(boolean b) {
        this.interactableFavorites = b && this.interactable;
        return this;
    }

    public EntryWidget noHighlight() {
        return this.highlight(false);
    }

    public EntryWidget highlight(boolean b) {
        this.highlight = b;
        return this;
    }

    public EntryWidget noTooltips() {
        return this.tooltips(false);
    }

    public EntryWidget tooltips(boolean b) {
        this.tooltips = b;
        return this;
    }

    public EntryWidget noBackground() {
        return this.background(false);
    }

    public EntryWidget background(boolean b) {
        this.background = b;
        return this;
    }

    public EntryWidget clearStacks() {
        this.entryStacks.clear();
        return this;
    }

    public EntryWidget entry(EntryStack stack) {
        this.entryStacks.add(stack);
        return this;
    }

    public EntryWidget entries(Collection<EntryStack> stacks) {
        this.entryStacks.addAll(stacks);
        return this;
    }

    protected EntryStack getCurrentEntry() {
        if (this.entryStacks.isEmpty()) {
            return EntryStack.empty();
        }
        if (this.entryStacks.size() == 1) {
            return this.entryStacks.get(0);
        }
        return this.entryStacks.get(class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)this.entryStacks.size() / 1.0)));
    }

    public List<EntryStack> entries() {
        return this.entryStacks;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    protected Rectangle getInnerBounds() {
        return new Rectangle(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 2, this.bounds.height - 2);
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.drawBackground(mouseX, mouseY, delta);
        this.drawCurrentEntry(mouseX, mouseY, delta);
        boolean highlighted = this.containsMouse(mouseX, mouseY);
        if (this.hasTooltips() && highlighted) {
            this.queueTooltip(mouseX, mouseY, delta);
        }
        if (this.hasHighlight() && highlighted) {
            this.drawHighlighted(mouseX, mouseY, delta);
        }
    }

    public final boolean hasTooltips() {
        return this.tooltips;
    }

    public final boolean hasHighlight() {
        return this.highlight;
    }

    protected void drawBackground(int mouseX, int mouseY, float delta) {
        if (this.background) {
            this.minecraft.method_1531().method_22813(ScreenHelper.isDarkModeEnabled() ? RECIPE_GUI_DARK : RECIPE_GUI);
            this.blit(this.bounds.x, this.bounds.y, 0, 222, this.bounds.width, this.bounds.height);
        }
    }

    protected void drawCurrentEntry(int mouseX, int mouseY, float delta) {
        EntryStack entry = this.getCurrentEntry();
        entry.setZ(100);
        entry.render(this.getInnerBounds(), mouseX, mouseY, delta);
    }

    protected void queueTooltip(int mouseX, int mouseY, float delta) {
        QueuedTooltip tooltip = this.getCurrentTooltip(mouseX, mouseY);
        if (tooltip != null) {
            if (this.interactableFavorites && ConfigObject.getInstance().doDisplayFavoritesTooltip() && !ConfigObject.getInstance().getFavoriteKeyCode().isUnknown()) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName();
                if (this.reverseFavoritesAction()) {
                    tooltip.getText().addAll(Arrays.asList(class_1074.method_4662((String)"text.rei.remove_favorites_tooltip", (Object[])new Object[]{name}).split("\n")));
                } else {
                    tooltip.getText().addAll(Arrays.asList(class_1074.method_4662((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")));
                }
            }
            ScreenHelper.getLastOverlay().addTooltip(tooltip);
        }
    }

    public QueuedTooltip getCurrentTooltip(int mouseX, int mouseY) {
        return this.getCurrentEntry().getTooltip(mouseX, mouseY);
    }

    protected void drawHighlighted(int mouseX, int mouseY, float delta) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        int color = ScreenHelper.isDarkModeEnabled() ? -1877929711 : -2130706433;
        this.setZ(300);
        Rectangle bounds = this.getInnerBounds();
        this.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), color, color);
        this.setZ(0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public List<? extends class_364> children() {
        return Collections.emptyList();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.interactable) {
            return false;
        }
        if (this.containsMouse(mouseX, mouseY)) {
            if (button == 0) {
                return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentEntry());
            }
            if (button == 1) {
                return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentEntry());
            }
        }
        return false;
    }

    protected boolean reverseFavoritesAction() {
        return false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (!this.interactable) {
            return false;
        }
        if (this.containsMouse(PointHelper.fromMouse())) {
            if (this.interactableFavorites && ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(PointHelper.fromMouse()) && !this.getCurrentEntry().isEmpty()) {
                ModifierKeyCode keyCode = ConfigObject.getInstance().getFavoriteKeyCode();
                EntryStack entry = this.getCurrentEntry().copy();
                entry.setAmount(127);
                if (keyCode.matchesKey(int_1, int_2)) {
                    if (this.reverseFavoritesAction()) {
                        ConfigObject.getInstance().getFavorites().remove(entry);
                    } else if (!CollectionUtils.anyMatchEqualsEntryIgnoreAmount(ConfigObject.getInstance().getFavorites(), entry)) {
                        ConfigObject.getInstance().getFavorites().add(entry);
                    }
                    ConfigManager.getInstance().saveConfig();
                    FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
                    if (favoritesListWidget != null) {
                        favoritesListWidget.updateSearch(ContainerScreenOverlay.getEntryListWidget(), ScreenHelper.getSearchField().getText());
                    }
                    this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                    return true;
                }
            }
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(int_1, int_2)) {
                return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentEntry());
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(int_1, int_2)) {
                return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentEntry());
            }
        }
        return false;
    }
}

