/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import me.sargunvohra.mcmods.autoconfig1u.ConfigData;
import me.sargunvohra.mcmods.autoconfig1u.annotation.Config;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.gui.config.ItemListOrderingConfig;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.shedaniel.rei.gui.config.SearchFieldLocation;
import net.minecraft.class_3675;
import org.jetbrains.annotations.ApiStatus;

@Config(name="roughlyenoughitems/config")
@ApiStatus.Internal
public class ConfigObjectImpl
implements ConfigObject,
ConfigData {
    @ConfigEntry.Category(value="!general")
    @ConfigEntry.Gui.TransitiveObject
    @DontApplyFieldName
    public General general = new General();
    @ConfigEntry.Category(value="appearance")
    @ConfigEntry.Gui.TransitiveObject
    @DontApplyFieldName
    private Appearance appearance = new Appearance();
    @ConfigEntry.Category(value="modules")
    @ConfigEntry.Gui.TransitiveObject
    @DontApplyFieldName
    private Modules modules = new Modules();
    @ConfigEntry.Category(value="technical")
    @ConfigEntry.Gui.TransitiveObject
    @DontApplyFieldName
    private Technical technical = new Technical();
    @ConfigEntry.Category(value="performance")
    @ConfigEntry.Gui.TransitiveObject
    @DontApplyFieldName
    private Performance performance = new Performance();
    @ConfigEntry.Category(value="filtering")
    @ConfigEntry.Gui.TransitiveObject
    @DontApplyFieldName
    private Filtering filtering = new Filtering();

    @Override
    public boolean isOverlayVisible() {
        return this.general.overlayVisible;
    }

    @Override
    public void setOverlayVisible(boolean overlayVisible) {
        this.general.overlayVisible = overlayVisible;
    }

    @Override
    public boolean isCheating() {
        return this.general.cheating;
    }

    @Override
    public void setCheating(boolean cheating) {
        this.general.cheating = cheating;
    }

    @Override
    public ItemListOrdering getItemListOrdering() {
        return this.appearance.itemListOrdering.getOrdering();
    }

    @Override
    public boolean isItemListAscending() {
        return this.appearance.itemListOrdering.isAscending();
    }

    @Override
    public boolean isUsingDarkTheme() {
        return this.appearance.darkTheme;
    }

    @Override
    public boolean isToastDisplayedOnCopyIdentifier() {
        return this.modules.toastDisplayedOnCopyIdentifier;
    }

    @Override
    public boolean doesRenderEntryEnchantmentGlint() {
        return this.performance.renderEntryEnchantmentGlint;
    }

    @Override
    public boolean isEntryListWidgetScrolled() {
        return this.appearance.scrollingEntryListWidget;
    }

    @Override
    public boolean shouldAppendModNames() {
        return this.appearance.appendModNames;
    }

    @Override
    public RecipeScreenType getRecipeScreenType() {
        return this.appearance.recipeScreenType;
    }

    @Override
    public void setRecipeScreenType(RecipeScreenType recipeScreenType) {
        this.appearance.recipeScreenType = recipeScreenType;
    }

    @Override
    public boolean isLoadingDefaultPlugin() {
        return this.technical.loadDefaultPlugin;
    }

    @Override
    public SearchFieldLocation getSearchFieldLocation() {
        return this.appearance.searchFieldLocation;
    }

    @Override
    public boolean isLeftHandSidePanel() {
        return this.appearance.mirrorItemPanel;
    }

    @Override
    public boolean isCraftableFilterEnabled() {
        return this.modules.enableCraftableOnlyButton;
    }

    @Override
    public String getGamemodeCommand() {
        return this.technical.gamemodeCommand;
    }

    @Override
    public String getGiveCommand() {
        return this.technical.giveCommand;
    }

    @Override
    public String getWeatherCommand() {
        return this.technical.weatherCommand;
    }

    @Override
    public int getMaxRecipePerPage() {
        return this.appearance.maxRecipePerPage;
    }

    @Override
    public boolean doesShowUtilsButtons() {
        return this.modules.showUtilsButtons;
    }

    @Override
    public boolean doesDisableRecipeBook() {
        return this.modules.disableRecipeBook;
    }

    @Override
    public boolean doesFixTabCloseContainer() {
        return this.modules.fixTabCloseContainer;
    }

    @Override
    public boolean areClickableRecipeArrowsEnabled() {
        return this.appearance.clickableRecipeArrows;
    }

    @Override
    public boolean isUsingLightGrayRecipeBorder() {
        return this.appearance.lightGrayRecipeBorder;
    }

    @Override
    public boolean doesVillagerScreenHavePermanentScrollBar() {
        return this.appearance.villagerScreenPermanentScrollBar;
    }

    @Override
    public boolean doesRegisterRecipesInAnotherThread() {
        return this.technical.registerRecipesInAnotherThread;
    }

    @Override
    public boolean doesSnapToRows() {
        return this.appearance.snapToRows;
    }

    @Override
    public boolean isFavoritesEnabled() {
        return this.general.favoritesEnabled;
    }

    @Override
    public boolean doDisplayFavoritesTooltip() {
        return this.isFavoritesEnabled() && this.appearance.displayFavoritesTooltip;
    }

    @Override
    public boolean doDisplayFavoritesOnTheLeft() {
        return this.appearance.displayFavoritesOnTheLeft;
    }

    @Override
    public boolean doesFastEntryRendering() {
        return this.performance.newFastEntryRendering;
    }

    @Override
    public boolean doDebugRenderTimeRequired() {
        return this.technical.debugRenderTimeRequired;
    }

    @Override
    public boolean doSearchFavorites() {
        return this.appearance.searchFavorites;
    }

    @Override
    public ModifierKeyCode getFavoriteKeyCode() {
        return this.general.favoriteKeybind == null ? ModifierKeyCode.unknown() : this.general.favoriteKeybind;
    }

    @Override
    public ModifierKeyCode getRecipeKeybind() {
        return this.general.recipeKeybind == null ? ModifierKeyCode.unknown() : this.general.recipeKeybind;
    }

    @Override
    public ModifierKeyCode getUsageKeybind() {
        return this.general.usageKeybind == null ? ModifierKeyCode.unknown() : this.general.usageKeybind;
    }

    @Override
    public ModifierKeyCode getHideKeybind() {
        return this.general.hideKeybind == null ? ModifierKeyCode.unknown() : this.general.hideKeybind;
    }

    @Override
    public ModifierKeyCode getPreviousPageKeybind() {
        return this.general.previousPageKeybind == null ? ModifierKeyCode.unknown() : this.general.previousPageKeybind;
    }

    @Override
    public ModifierKeyCode getNextPageKeybind() {
        return this.general.nextPageKeybind == null ? ModifierKeyCode.unknown() : this.general.nextPageKeybind;
    }

    @Override
    public ModifierKeyCode getFocusSearchFieldKeybind() {
        return this.general.focusSearchFieldKeybind == null ? ModifierKeyCode.unknown() : this.general.focusSearchFieldKeybind;
    }

    @Override
    public ModifierKeyCode getCopyRecipeIdentifierKeybind() {
        return this.general.copyRecipeIdentifierKeybind == null ? ModifierKeyCode.unknown() : this.general.copyRecipeIdentifierKeybind;
    }

    @Override
    public ModifierKeyCode getExportImageKeybind() {
        return this.general.exportImageKeybind == null ? ModifierKeyCode.unknown() : this.general.exportImageKeybind;
    }

    @Override
    public double getEntrySize() {
        return this.appearance.entrySize;
    }

    @Override
    @Deprecated
    public General getGeneral() {
        return this.general;
    }

    @Override
    public boolean isUsingCompactTabs() {
        return this.appearance.useCompactTabs;
    }

    @Override
    public boolean isLowerConfigButton() {
        return this.appearance.lowerConfigButton;
    }

    @Override
    public List<EntryStack> getFavorites() {
        return this.general.favorites;
    }

    @Override
    public List<EntryStack> getFilteredStacks() {
        return this.filtering.filteredStacks;
    }

    @Override
    @ApiStatus.Experimental
    public boolean shouldAsyncSearch() {
        return this.performance.asyncSearch;
    }

    @Override
    @ApiStatus.Experimental
    public int getNumberAsyncSearch() {
        return this.performance.numberAsyncSearch;
    }

    @Override
    @ApiStatus.Experimental
    public boolean doDebugSearchTimeRequired() {
        return this.technical.debugSearchTimeRequired;
    }

    public static class Filtering {
        @UseFilteringScreen
        private List<EntryStack> filteredStacks = new ArrayList<EntryStack>();
    }

    public static class Performance {
        @Comment(value="Whether REI should render entry's enchantment glint")
        private boolean renderEntryEnchantmentGlint = true;
        private boolean newFastEntryRendering = true;
        @Comment(value="Experimental: Declares whether REI should search async.")
        private boolean asyncSearch = true;
        @Comment(value="Experimental: Declares how many entries should be grouped one async search.")
        @ConfigEntry.BoundedDiscrete(min=25L, max=400L)
        private int numberAsyncSearch = 50;
    }

    public static class Modules {
        @Comment(value="Declares whether the craftable filter button is enabled.")
        private boolean enableCraftableOnlyButton = true;
        private boolean toastDisplayedOnCopyIdentifier = true;
        @Comment(value="Declares whether the utils buttons are shown.")
        private boolean showUtilsButtons = false;
        @Comment(value="Declares whether REI should remove the recipe book.")
        private boolean disableRecipeBook = false;
        @Comment(value="Declares whether REI should fix closing container with tab.")
        private boolean fixTabCloseContainer = false;
    }

    public static class Technical {
        @Comment(value="To disable REI's default plugin.\nDon't change this unless you understand what you are doing!")
        private boolean loadDefaultPlugin = true;
        @Comment(value="Declares the command used to change gamemode.")
        private String gamemodeCommand = "/gamemode {gamemode}";
        @Comment(value="Declares the command used in servers to cheat items.")
        private String giveCommand = "/give {player_name} {item_identifier}{nbt} {count}";
        @Comment(value="Declares the command used to change weather.")
        private String weatherCommand = "/weather {weather}";
        private boolean registerRecipesInAnotherThread = true;
        private boolean debugRenderTimeRequired = false;
        @Comment(value="Experimental: Declares whether search time should be debugged.")
        private boolean debugSearchTimeRequired = false;
    }

    public static class Appearance {
        @UseSpecialRecipeTypeScreen
        private RecipeScreenType recipeScreenType = RecipeScreenType.UNSET;
        @Comment(value="The ordering of the items on the item panel.")
        @UseEnumSelectorInstead
        private ItemListOrderingConfig itemListOrdering = ItemListOrderingConfig.REGISTRY_ASCENDING;
        @Comment(value="Declares the appearance of REI windows.")
        private boolean darkTheme = false;
        @Comment(value="Declares the position of the search field.")
        @UseEnumSelectorInstead
        private SearchFieldLocation searchFieldLocation = SearchFieldLocation.CENTER;
        @Comment(value="Declares the position of the item list panel.")
        private boolean mirrorItemPanel = false;
        @Comment(value="Declares the maximum amount of recipes displayed in a page if possible.")
        @ConfigEntry.BoundedDiscrete(min=2L, max=99L)
        private int maxRecipePerPage = 3;
        private boolean clickableRecipeArrows = true;
        @Comment(value="Declares the appearance of recipe's border.")
        private boolean lightGrayRecipeBorder = false;
        @Comment(value="Declares whether REI should append mod names to item stacks.")
        private boolean appendModNames = true;
        @Comment(value="Declares how the scrollbar in villager screen should act.")
        private boolean villagerScreenPermanentScrollBar = false;
        @Comment(value="Declares whether entry list widget is scrolled.")
        private boolean scrollingEntryListWidget = false;
        @Comment(value="Declares whether scrolled entry list widget should snap to rows.")
        private boolean snapToRows = false;
        @Comment(value="Declares the location of the favorites list.")
        private boolean displayFavoritesOnTheLeft = true;
        @Comment(value="Declares whether favorites tooltip should be displayed.")
        private boolean displayFavoritesTooltip = false;
        @Comment(value="Declares whether favorites will be searched.")
        private boolean searchFavorites = true;
        @UsePercentage(min=0.25, max=4.0)
        private double entrySize = 1.0;
        private boolean useCompactTabs = true;
        private boolean lowerConfigButton = false;
    }

    public static class General {
        @ConfigEntry.Gui.Excluded
        public List<EntryStack> favorites = new ArrayList<EntryStack>();
        @Comment(value="Declares whether cheating mode is on.")
        private boolean cheating = false;
        @Comment(value="Declares whether REI is visible.")
        @ConfigEntry.Gui.Excluded
        private boolean overlayVisible = true;
        private boolean favoritesEnabled = true;
        private ModifierKeyCode recipeKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1668.method_1447(82), (Modifier)Modifier.none());
        private ModifierKeyCode usageKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1668.method_1447(85), (Modifier)Modifier.none());
        private ModifierKeyCode hideKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1668.method_1447(79), (Modifier)Modifier.of((boolean)false, (boolean)true, (boolean)false));
        private ModifierKeyCode previousPageKeybind = ModifierKeyCode.unknown();
        private ModifierKeyCode nextPageKeybind = ModifierKeyCode.unknown();
        private ModifierKeyCode focusSearchFieldKeybind = ModifierKeyCode.unknown();
        private ModifierKeyCode copyRecipeIdentifierKeybind = ModifierKeyCode.unknown();
        private ModifierKeyCode favoriteKeybind = ModifierKeyCode.of((class_3675.class_306)class_3675.class_307.field_1668.method_1447(65), (Modifier)Modifier.none());
        @ConfigEntry.Gui.Excluded
        private ModifierKeyCode exportImageKeybind = ModifierKeyCode.unknown();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface UsePercentage {
        public double min();

        public double max();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface UseFilteringScreen {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface UseSpecialRecipeTypeScreen {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface UseEnumSelectorInstead {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface DontApplyFieldName {
    }
}

