/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3545;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EntryRegistryImpl
implements EntryRegistry {
    private final CopyOnWriteArrayList<EntryStack> preFilteredList = Lists.newCopyOnWriteArrayList();
    private final CopyOnWriteArrayList<EntryStack> entries = Lists.newCopyOnWriteArrayList();
    private final Queue<class_3545<EntryStack, Collection<? extends EntryStack>>> queueRegisterEntryStackAfter = Queues.newConcurrentLinkedQueue();
    private List<EntryStack> reloadList;
    private boolean doingDistinct = false;

    private static EntryStack findFirstOrNullEqualsEntryIgnoreAmount(Collection<EntryStack> list, EntryStack obj) {
        for (EntryStack t : list) {
            if (!t.equalsIgnoreAmount(obj)) continue;
            return t;
        }
        return null;
    }

    public void distinct() {
        class_3545<EntryStack, Collection<? extends EntryStack>> pair;
        this.preFilteredList.clear();
        this.doingDistinct = true;
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.addAll(this.reloadList);
        this.entries.clear();
        this.entries.addAll(set);
        this.entries.removeIf(EntryStack::isEmpty);
        this.reloadList.clear();
        while ((pair = this.queueRegisterEntryStackAfter.poll()) != null) {
            this.registerEntriesAfter((EntryStack)pair.method_15442(), (Collection)pair.method_15441());
        }
        set.clear();
        set.addAll(this.entries);
        set.removeIf(EntryStack::isEmpty);
        this.entries.clear();
        this.entries.addAll(set);
        set.clear();
        this.doingDistinct = false;
    }

    @Override
    public List<EntryStack> getStacksList() {
        return RecipeHelper.getInstance().arePluginsLoading() && !this.doingDistinct ? this.reloadList : this.entries;
    }

    @Override
    public List<EntryStack> getPreFilteredList() {
        return this.preFilteredList;
    }

    public void refilter() {
        long started = System.currentTimeMillis();
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.addAll(ConfigObject.getInstance().getFilteredStacks());
        this.preFilteredList.clear();
        for (EntryStack stack : this.getStacksList()) {
            if (EntryRegistryImpl.findFirstOrNullEqualsEntryIgnoreAmount(set, stack) != null) continue;
            this.preFilteredList.add(stack);
        }
        long time = System.currentTimeMillis() - started;
        RoughlyEnoughItemsCore.LOGGER.info("[REI] Refiltered %d entries in %dms.", (Object)set.size(), (Object)time);
    }

    public void reset() {
        this.doingDistinct = false;
        this.reloadList = Lists.newArrayList();
        this.queueRegisterEntryStackAfter.clear();
        this.entries.clear();
        this.reloadList.clear();
        this.preFilteredList.clear();
    }

    @Override
    public List<class_1799> appendStacksForItem(class_1792 item) {
        DefaultedLinkedList<Object> list = new DefaultedLinkedList<Object>(Lists.newLinkedList(), null);
        item.method_7850(item.method_7859(), list);
        if (list.isEmpty()) {
            list.add(item.method_7854());
        }
        return list;
    }

    @Override
    public class_1799[] getAllStacksFromItem(class_1792 item) {
        List<class_1799> list = this.appendStacksForItem(item);
        class_1799[] array = list.toArray(new class_1799[0]);
        Arrays.sort(array, (a, b) -> class_1799.method_7973((class_1799)a, (class_1799)b) ? 0 : 1);
        return array;
    }

    @Override
    @Deprecated
    @ApiStatus.Internal
    public void registerEntryAfter(EntryStack afterEntry, EntryStack stack, boolean checkAlreadyContains) {
        if (stack.isEmpty()) {
            return;
        }
        if (afterEntry == null) {
            this.getStacksList().add(stack);
        } else {
            int last = this.getStacksList().size();
            for (int i = last - 1; i >= 0; --i) {
                if (!this.getStacksList().get(i).equalsAll(afterEntry)) continue;
                last = i + 1;
                break;
            }
            this.getStacksList().add(last, stack);
        }
    }

    @Override
    public void queueRegisterEntryAfter(EntryStack afterEntry, Collection<? extends EntryStack> stacks) {
        if (RecipeHelper.getInstance().arePluginsLoading()) {
            this.queueRegisterEntryStackAfter.add((class_3545<EntryStack, Collection<? extends EntryStack>>)new class_3545((Object)afterEntry, stacks));
        } else {
            this.registerEntriesAfter(afterEntry, stacks);
        }
    }

    @Override
    public void registerEntriesAfter(EntryStack afterStack, Collection<? extends EntryStack> stacks) {
        if (afterStack != null) {
            int index = this.getStacksList().size();
            for (int i = index - 1; i >= 0; --i) {
                if (!this.getStacksList().get(i).equalsAll(afterStack)) continue;
                index = i + 1;
                break;
            }
            this.getStacksList().addAll(index, stacks);
        } else {
            this.getStacksList().addAll(stacks);
        }
    }

    private static class DefaultedLinkedList<E>
    extends class_2371<E> {
        public DefaultedLinkedList(List<E> delegate, @Nullable E initialElement) {
            super(delegate, initialElement);
        }
    }
}

