/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.beacon;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.SlotBaseWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.plugin.DefaultPlugin;
import me.shedaniel.rei.plugin.beacon.DefaultBeaconBaseDisplay;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import org.jetbrains.annotations.Nullable;

public class DefaultBeaconBaseCategory
implements RecipeCategory<DefaultBeaconBaseDisplay> {
    @Override
    public class_2960 getIdentifier() {
        return DefaultPlugin.BEACON;
    }

    @Override
    public String getCategoryName() {
        return class_1074.method_4662((String)"category.rei.beacon_base", (Object[])new Object[0]);
    }

    @Override
    public EntryStack getLogo() {
        return EntryStack.create((class_1935)class_2246.field_10327);
    }

    @Override
    public RecipeEntry getSimpleRenderer(DefaultBeaconBaseDisplay recipe) {
        final String name = this.getCategoryName();
        return new RecipeEntry(){

            @Override
            public int getHeight() {
                class_310.method_1551().field_1772.getClass();
                return 10 + 9;
            }

            @Override
            @Nullable
            public QueuedTooltip getTooltip(int mouseX, int mouseY) {
                return null;
            }

            @Override
            public void render(Rectangle rectangle, int mouseX, int mouseY, float delta) {
                class_310.method_1551().field_1772.method_1729(name, (float)(rectangle.x + 5), (float)(rectangle.y + 6), -1);
            }
        };
    }

    @Override
    public List<Widget> setupDisplay(Supplier<DefaultBeaconBaseDisplay> recipeDisplaySupplier, Rectangle bounds) {
        DefaultBeaconBaseDisplay display = recipeDisplaySupplier.get();
        ArrayList widgets = Lists.newArrayList();
        widgets.add(EntryWidget.create(bounds.getCenterX() - 8, bounds.y + 3).entry(this.getLogo()));
        Rectangle rectangle = new Rectangle(bounds.getCenterX() - bounds.width / 2 - 1, bounds.y + 23, bounds.width + 2, bounds.height - 28);
        widgets.add(new SlotBaseWidget(rectangle));
        widgets.add(new ScrollableSlotsWidget(rectangle, CollectionUtils.map(display.getEntries(), t -> EntryWidget.create(0, 0).noBackground().entry((EntryStack)t))));
        return widgets;
    }

    @Override
    public int getDisplayHeight() {
        return 140;
    }

    @Override
    public int getFixedRecipesPerPage() {
        return 1;
    }

    private static class ScrollableSlotsWidget
    extends WidgetWithBounds {
        private Rectangle bounds;
        private List<EntryWidget> widgets;
        private double target;
        private double scroll;
        private long start;
        private long duration;

        public ScrollableSlotsWidget(Rectangle bounds, List<EntryWidget> widgets) {
            this.bounds = bounds;
            this.widgets = Lists.newArrayList(widgets);
        }

        public boolean mouseScrolled(double double_1, double double_2, double double_3) {
            if (this.containsMouse(double_1, double_2)) {
                this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
                return true;
            }
            return false;
        }

        public void offset(double value, boolean animated) {
            this.scrollTo(this.target + value, animated);
        }

        public void scrollTo(double value, boolean animated) {
            this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
        }

        public void scrollTo(double value, boolean animated, long duration) {
            this.target = this.clamp(value);
            if (animated) {
                this.start = System.currentTimeMillis();
                this.duration = duration;
            } else {
                this.scroll = this.target;
            }
        }

        public final double clamp(double v) {
            return this.clamp(v, 200.0);
        }

        public final double clamp(double v, double clampExtension) {
            return class_3532.method_15350((double)v, (double)(-clampExtension), (double)((double)this.getMaxScroll() + clampExtension));
        }

        protected int getMaxScroll() {
            return Math.max(0, this.getMaxScrollPosition() - this.getBounds().height + 1);
        }

        protected int getMaxScrollPosition() {
            return class_3532.method_15386((float)((float)this.widgets.size() / 8.0f)) * 18;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public void render(int mouseX, int mouseY, float delta) {
            this.updatePosition(delta);
            Rectangle innerBounds = new Rectangle(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 7, this.bounds.height - 2);
            ScissorsHandler.INSTANCE.scissor(innerBounds);
            block0: for (int y = 0; y < class_3532.method_15386((float)((float)this.widgets.size() / 8.0f)); ++y) {
                for (int x = 0; x < 8; ++x) {
                    int index = y * 8 + x;
                    if (this.widgets.size() <= index) continue block0;
                    EntryWidget widget = this.widgets.get(index);
                    widget.getBounds().setLocation(this.bounds.x + 1 + x * 18, (int)((double)(this.bounds.y + 1 + y * 18) - this.scroll));
                    widget.render(mouseX, mouseY, delta);
                }
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            ScissorsHandler.INSTANCE.scissor(this.bounds);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            this.renderScrollBar();
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
            ScissorsHandler.INSTANCE.removeLastScissor();
        }

        private void renderScrollBar() {
            int maxScroll = this.getMaxScroll();
            int scrollbarPositionMinX = this.getBounds().getMaxX() - 7;
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            if (maxScroll > 0) {
                int height = (int)(((float)this.getBounds().height - 2.0f) * ((float)this.getBounds().height - 2.0f) / (float)this.getMaxScrollPosition());
                height = class_3532.method_15340((int)height, (int)32, (int)(this.getBounds().height - 2));
                height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)maxScroll ? (int)this.scroll - maxScroll : 0)), (double)height * 0.95));
                height = Math.max(10, height);
                int minY = Math.min(Math.max((int)this.scroll * (this.getBounds().height - 2 - height) / maxScroll + this.getBounds().y + 1, this.getBounds().y + 1), this.getBounds().getMaxY() - 1 - height);
                boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse());
                int bottomC = hovered ? 168 : 128;
                int topC = hovered ? 222 : 172;
                buffer.method_1328(7, class_290.field_1575);
                buffer.method_22912((double)scrollbarPositionMinX, (double)(this.getBounds().y + 1), 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMaxX, (double)(this.getBounds().y + 1), 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMaxX, (double)(this.getBounds().getMaxY() - 1), 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMinX, (double)(this.getBounds().getMaxY() - 1), 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
                tessellator.method_1350();
                buffer.method_1328(7, class_290.field_1575);
                buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height), 0.0).method_22913(0.0f, 1.0f).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).method_22913(1.0f, 1.0f).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 0.0).method_22913(1.0f, 0.0f).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22913(0.0f, 0.0f).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                tessellator.method_1350();
                buffer.method_1328(7, class_290.field_1575);
                buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).method_22913(0.0f, 1.0f).method_1336(topC, topC, topC, 255).method_1344();
                buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).method_22913(1.0f, 1.0f).method_1336(topC, topC, topC, 255).method_1344();
                buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).method_22913(1.0f, 0.0f).method_1336(topC, topC, topC, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22913(0.0f, 0.0f).method_1336(topC, topC, topC, 255).method_1344();
                tessellator.method_1350();
            }
        }

        private void updatePosition(float delta) {
            double[] target = new double[]{this.target};
            this.scroll = ClothConfigInitializer.handleScrollingPosition((double[])target, (double)this.scroll, (double)this.getMaxScroll(), (float)delta, (double)this.start, (double)this.duration);
            this.target = target[0];
        }

        public List<? extends class_364> children() {
            return this.widgets;
        }
    }
}

