/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PreRecipeViewingScreen
extends class_437 {
    private static final class_2960 IDENTIFIER = new class_2960("roughlyenoughitems", "textures/gui/screenshot.png");
    private final List<Widget> widgets = Lists.newArrayList();
    protected long start;
    protected long duration;
    private boolean isSet;
    private boolean original;
    private double frame = 0.0;
    private double target = 0.0;
    private BooleanConsumer callback;
    private class_437 parent;
    private boolean showTips;

    public PreRecipeViewingScreen(class_437 parent, RecipeScreenType type, boolean showTips, BooleanConsumer callback) {
        super((class_2561)new class_2588("text.rei.recipe_screen_type.selection", new Object[0]));
        if (type == RecipeScreenType.UNSET) {
            this.isSet = false;
            this.original = true;
        } else {
            this.isSet = true;
            this.original = type == RecipeScreenType.ORIGINAL;
            this.moveFrameTo(this.original ? 0.0 : 1.0, false, 0L);
        }
        this.callback = callback;
        this.parent = parent;
        this.showTips = showTips;
    }

    public final double clamp(double v) {
        return this.clamp(v, 30.0);
    }

    public final double clamp(double v, double clampExtension) {
        return class_3532.method_15350((double)v, (double)(-clampExtension), (double)(1.0 + clampExtension));
    }

    private void moveFrameTo(double value, boolean animated, long duration) {
        this.target = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.frame = this.target;
        }
    }

    protected void init() {
        this.children.clear();
        this.widgets.clear();
        this.widgets.add(new ButtonWidget(new Rectangle(this.width / 2 - 100, this.height - 40, 200, 20), class_333.field_18967){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                this.enabled = PreRecipeViewingScreen.this.isSet;
                this.setText(this.enabled ? class_1074.method_4662((String)"text.rei.select", (Object[])new Object[0]) : class_1074.method_4662((String)"config.roughlyenoughitems.recipeScreenType.unset", (Object[])new Object[0]));
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public void onPressed() {
                PreRecipeViewingScreen.this.callback.accept(PreRecipeViewingScreen.this.original);
            }
        });
        this.widgets.add(new ScreenTypeSelection(this.width / 2 - 200 - 5, this.height / 2 - 56 - 10, 0));
        this.widgets.add(LabelWidget.create(new Point(this.width / 2 - 200 - 5 + 104, this.height / 2 - 56 + 115), class_1074.method_4662((String)"config.roughlyenoughitems.recipeScreenType.original", (Object[])new Object[0])).noShadow().color(-1124073473));
        this.widgets.add(new ScreenTypeSelection(this.width / 2 + 5, this.height / 2 - 56 - 10, 112));
        this.widgets.add(LabelWidget.create(new Point(this.width / 2 + 5 + 104, this.height / 2 - 56 + 115), class_1074.method_4662((String)"config.roughlyenoughitems.recipeScreenType.villager", (Object[])new Object[0])).noShadow().color(-1124073473));
        this.children.addAll(this.widgets);
    }

    public void render(int int_1, int int_2, float float_1) {
        if (this.minecraft.field_1687 != null) {
            this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.fillGradient(0, 0, this.width, this.height, -16777216, -16777216);
        }
        this.drawCenteredString(this.font, this.title.method_10863(), this.width / 2, 20, 0xFFFFFF);
        if (this.showTips) {
            int i = 30;
            for (String s : this.font.method_1728(class_1074.method_4662((String)"text.rei.recipe_screen_type.selection.sub", (Object[])new Object[0]), this.width - 30)) {
                this.drawCenteredString(this.font, class_124.field_1080.toString() + s, this.width / 2, i, -1);
                i += 10;
            }
        }
        super.render(int_1, int_2, float_1);
        for (Widget widget : this.widgets) {
            widget.render(int_1, int_2, float_1);
        }
        if (this.isSet) {
            this.updateFramePosition(float_1);
            int x = (int)((double)(this.width / 2 - 205) + 210.0 * this.frame);
            int y = this.height / 2 - 56 - 10;
            this.fillGradient(x - 2, y - 4, x - 6 + 208, y - 4 + 2, -1778384897, -1778384897);
            this.fillGradient(x - 2, y - 4 + 120 - 2, x - 6 + 208, y - 4 + 120, -1778384897, -1778384897);
            this.fillGradient(x - 4, y - 4, x - 4 + 2, y - 4 + 120, -1778384897, -1778384897);
            this.fillGradient(x - 4 + 208 - 2, y - 4, x - 4 + 208, y - 4 + 120, -1778384897, -1778384897);
        }
    }

    private void updateFramePosition(float delta) {
        this.target = this.clamp(this.target);
        this.frame = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.frame, (double)this.target, (double)0.001f) ? this.ease(this.frame, this.target, Math.min((double)(System.currentTimeMillis() - this.start) / (double)this.duration * (double)delta * 3.0, 1.0)) : this.target;
    }

    private double ease(double start, double end, double amount) {
        return start + (end - start) * EasingMethod.EasingMethodImpl.LINEAR.apply(amount);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 256 || this.minecraft.field_1690.field_1822.method_1417(int_1, int_2)) {
            class_310.method_1551().method_1507(this.parent);
            if (this.parent instanceof class_465) {
                ScreenHelper.getLastOverlay().init();
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public class ScreenTypeSelection
    extends WidgetWithBounds {
        private Rectangle bounds;
        private int u;
        private int v;

        public ScreenTypeSelection(int x, int y, int v) {
            this.bounds = new Rectangle(x - 4, y - 4, 208, 120);
            this.u = 0;
            this.v = v;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public void render(int i, int i1, float delta) {
            class_310.method_1551().method_1531().method_22813(IDENTIFIER);
            this.blit(this.bounds.x + 4, this.bounds.y + 4, this.u, this.v, 200, 112);
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            if (this.containsMouse(double_1, double_2)) {
                PreRecipeViewingScreen.this.original = this.v == 0;
                if (!PreRecipeViewingScreen.this.isSet) {
                    PreRecipeViewingScreen.this.moveFrameTo(!PreRecipeViewingScreen.this.original ? 0.0 : 1.0, false, 0L);
                }
                PreRecipeViewingScreen.this.isSet = true;
                PreRecipeViewingScreen.this.moveFrameTo(PreRecipeViewingScreen.this.original ? 0.0 : 1.0, true, 1000L);
                return true;
            }
            return false;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }
}

