/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.crafting;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.TransferRecipeCategory;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.plugin.DefaultPlugin;
import me.shedaniel.rei.plugin.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.server.ContainerInfo;
import me.shedaniel.rei.server.ContainerInfoHandler;
import net.minecraft.class_1074;
import net.minecraft.class_1703;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class DefaultCraftingCategory
implements TransferRecipeCategory<DefaultCraftingDisplay> {
    public static int getSlotWithSize(DefaultCraftingDisplay recipeDisplay, int num, int craftingGridWidth) {
        int x = num % recipeDisplay.getWidth();
        int y = (num - x) / recipeDisplay.getWidth();
        return craftingGridWidth * y + x;
    }

    @Override
    public class_2960 getIdentifier() {
        return DefaultPlugin.CRAFTING;
    }

    @Override
    public EntryStack getLogo() {
        return EntryStack.create((class_1935)class_2246.field_9980);
    }

    @Override
    public String getCategoryName() {
        return class_1074.method_4662((String)"category.rei.crafting", (Object[])new Object[0]);
    }

    @Override
    public List<Widget> setupDisplay(Supplier<DefaultCraftingDisplay> recipeDisplaySupplier, Rectangle bounds) {
        final Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - 27);
        LinkedList widgets = Lists.newLinkedList(Collections.singletonList(new RecipeBaseWidget(bounds){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                super.render(mouseX, mouseY, delta);
                class_310.method_1551().method_1531().method_22813(DefaultPlugin.getDisplayTexture());
                this.blit(startPoint.x, startPoint.y, 0, 0, 116, 54);
            }
        }));
        List<List<EntryStack>> input = recipeDisplaySupplier.get().getInputEntries();
        ArrayList slots = Lists.newArrayList();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                slots.add(EntryWidget.create(startPoint.x + 1 + x * 18, startPoint.y + 1 + y * 18).markIsInput());
            }
        }
        for (int i = 0; i < input.size(); ++i) {
            if (recipeDisplaySupplier.get() instanceof DefaultShapedDisplay) {
                if (input.get(i).isEmpty()) continue;
                ((EntryWidget)((Object)slots.get(DefaultCraftingCategory.getSlotWithSize(recipeDisplaySupplier.get(), i, 3)))).entries((Collection<EntryStack>)input.get(i));
                continue;
            }
            if (input.get(i).isEmpty()) continue;
            ((EntryWidget)((Object)slots.get(i))).entries((Collection<EntryStack>)input.get(i));
        }
        widgets.addAll(slots);
        widgets.add(EntryWidget.create(startPoint.x + 95, startPoint.y + 19).entries(recipeDisplaySupplier.get().getOutputEntries()).noBackground().markIsOutput());
        return widgets;
    }

    @Override
    public void renderRedSlots(List<Widget> widgets, Rectangle bounds, DefaultCraftingDisplay display, IntList redSlots) {
        ContainerInfo<? extends class_1703> info = ContainerInfoHandler.getContainerInfo(this.getIdentifier(), ScreenHelper.getLastContainerScreen().method_17577().getClass());
        if (info == null) {
            return;
        }
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)400.0f);
        Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - 27);
        int width = info.getCraftingWidth((class_1703)ScreenHelper.getLastContainerScreen().method_17577());
        for (Integer slot : redSlots) {
            int i = slot;
            int x = i % width;
            int y = class_3532.method_15375((float)((float)i / (float)width));
            class_332.fill((int)(startPoint.x + 1 + x * 18), (int)(startPoint.y + 1 + y * 18), (int)(startPoint.x + 1 + x * 18 + 16), (int)(startPoint.y + 1 + y * 18 + 16), (int)0x60FF0000);
        }
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-400.0f);
    }
}

