/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.shedaniel.clothconfig2.api.FakeModifierKeyCodeAdder;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.*;
import me.shedaniel.rei.gui.PreRecipeViewingScreen;
import me.shedaniel.rei.gui.RecipeScreen;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.shedaniel.rei.utils.CollectionUtils;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.impl.client.keybinding.KeyBindingRegistryImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3528;
import net.minecraft.class_437;
import net.minecraft.class_481;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@ApiStatus.Internal
public class ClientHelperImpl implements ClientHelper, ClientModInitializer {
    
    private static ClientHelperImpl instance;
    @ApiStatus.Internal public final class_3528<Boolean> isYog = new class_3528<>(() -> {
        try {
            if (class_310.method_1551().method_1548().method_1677().getId().equals(UUID.fromString("f9546389-9415-4358-9c29-2c26b25bff5b")))
                return true;
        } catch (Throwable ignored) {
        }
        return false;
    });
    @ApiStatus.Internal public final class_3528<Boolean> ok = new class_3528<>(() -> {
        try {
            if (isYog.method_15332())
                return true;
            LocalDateTime now = LocalDateTime.now();
            return now.getMonthValue() == 4 && now.getDayOfMonth() == 1;
        } catch (Throwable ignored) {
        }
        return false;
    });
    private final Map<String, String> modNameCache = Maps.newHashMap();
    
    /**
     * @return the instance of {@link ClientHelperImpl}
     * @see ClientHelper#getInstance()
     */
    @ApiStatus.Internal
    public static ClientHelperImpl getInstance() {
        return instance;
    }
    
    @Override
    public String getFormattedModFromItem(class_1792 item) {
        String mod = getModFromItem(item);
        if (mod.isEmpty())
            return "";
        return class_124.field_1078.toString() + class_124.field_1056.toString() + mod;
    }
    
    @Override
    public String getFormattedModFromIdentifier(class_2960 identifier) {
        String mod = getModFromIdentifier(identifier);
        if (mod.isEmpty())
            return "";
        return class_124.field_1078.toString() + class_124.field_1056.toString() + mod;
    }
    
    @Override
    public String getModFromItem(class_1792 item) {
        if (item.equals(class_1802.field_8162))
            return "";
        return getModFromIdentifier(class_2378.field_11142.method_10221(item));
    }
    
    @Override
    public String getModFromModId(String modid) {
        if (modid == null)
            return "";
        String any = modNameCache.getOrDefault(modid, null);
        if (any != null)
            return any;
        String s = FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modid);
        modNameCache.put(modid, s);
        return s;
    }
    
    @Override
    public boolean isCheating() {
        return ConfigObject.getInstance().isCheating();
    }
    
    @Override
    public void setCheating(boolean cheating) {
        ConfigObject.getInstance().setCheating(cheating);
        ConfigManager.getInstance().saveConfig();
    }
    
    @Override
    public void sendDeletePacket() {
        if (ScreenHelper.getLastContainerScreen() instanceof class_481) {
            class_310.method_1551().field_1724.field_7514.method_7396(class_1799.field_8037);
            return;
        }
        ClientSidePacketRegistry.INSTANCE.sendToServer(RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET, new class_2540(Unpooled.buffer()));
    }
    
    @Override
    public boolean tryCheatingEntry(EntryStack entry) {
        if (entry.getType() != EntryStack.Type.ITEM)
            return false;
        class_1799 cheatedStack = entry.getItemStack().method_7972();
        if (RoughlyEnoughItemsCore.canUsePackets()) {
            try {
                ClientSidePacketRegistry.INSTANCE.sendToServer(RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET, new class_2540(Unpooled.buffer()).method_10793(cheatedStack));
                return true;
            } catch (Exception e) {
                return false;
            }
        } else {
            class_2960 identifier = entry.getIdentifier().orElse(null);
            if (identifier == null)
                return false;
            String tagMessage = cheatedStack.method_7972().method_7969() != null && !cheatedStack.method_7972().method_7969().isEmpty() ? cheatedStack.method_7972().method_7969().method_10714() : "";
            String og = cheatedStack.method_7947() == 1 ? ConfigObject.getInstance().getGiveCommand().replaceAll(" \\{count}", "") : ConfigObject.getInstance().getGiveCommand();
            String madeUpCommand = og.replaceAll("\\{player_name}", class_310.method_1551().field_1724.method_5820()).replaceAll("\\{item_name}", identifier.method_12832()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", tagMessage).replaceAll("\\{count}", String.valueOf(cheatedStack.method_7947()));
            if (madeUpCommand.length() > 256) {
                madeUpCommand = og.replaceAll("\\{player_name}", class_310.method_1551().field_1724.method_5820()).replaceAll("\\{item_name}", identifier.method_12832()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", "").replaceAll("\\{count}", String.valueOf(cheatedStack.method_7947()));
                class_310.method_1551().field_1724.method_7353(new class_2588("text.rei.too_long_nbt"), false);
            }
            class_310.method_1551().field_1724.method_3142(madeUpCommand);
            return true;
        }
    }
    
    @Override
    public boolean executeRecipeKeyBind(EntryStack stack) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = RecipeHelper.getInstance().getRecipesFor(stack);
        if (map.keySet().size() > 0)
            openRecipeViewingScreen(map, null, null, stack);
        return map.keySet().size() > 0;
    }
    
    @Override
    public boolean executeUsageKeyBind(EntryStack stack) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = RecipeHelper.getInstance().getUsagesFor(stack);
        if (map.keySet().size() > 0)
            openRecipeViewingScreen(map, null, stack, null);
        return map.keySet().size() > 0;
    }
    
    @Override
    public List<class_1799> getInventoryItemsTypes() {
        List<class_1799> inventoryStacks = new ArrayList<>(class_310.method_1551().field_1724.field_7514.field_7547);
        inventoryStacks.addAll(class_310.method_1551().field_1724.field_7514.field_7548);
        inventoryStacks.addAll(class_310.method_1551().field_1724.field_7514.field_7544);
        return inventoryStacks;
    }
    
    @Override
    public boolean executeViewAllRecipesKeyBind() {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = RecipeHelper.getInstance().getAllRecipes();
        if (map.keySet().size() > 0)
            openRecipeViewingScreen(map, null, null, null);
        return map.keySet().size() > 0;
    }
    
    @Override
    public boolean executeViewAllRecipesFromCategory(class_2960 category) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = Maps.newLinkedHashMap();
        RecipeCategory<?> recipeCategory = CollectionUtils.findFirstOrNull(RecipeHelper.getInstance().getAllCategories(), c -> c.getIdentifier().equals(category));
        if (recipeCategory == null)
            return false;
        map.put(recipeCategory, RecipeHelper.getInstance().getAllRecipesFromCategory(recipeCategory));
        if (map.keySet().size() > 0)
            openRecipeViewingScreen(map);
        return map.keySet().size() > 0;
    }
    
    @Override
    public boolean executeViewAllRecipesFromCategories(List<class_2960> categories) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = Maps.newLinkedHashMap();
        for (class_2960 category : categories) {
            RecipeCategory<?> recipeCategory = CollectionUtils.findFirstOrNull(RecipeHelper.getInstance().getAllCategories(), c -> c.getIdentifier().equals(category));
            if (recipeCategory == null)
                continue;
            map.put(recipeCategory, RecipeHelper.getInstance().getAllRecipesFromCategory(recipeCategory));
        }
        if (map.keySet().size() > 0)
            openRecipeViewingScreen(map);
        return map.keySet().size() > 0;
    }
    
    @Override
    public void openRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> map) {
        openRecipeViewingScreen(map, null, null, null);
    }
    
    @ApiStatus.Internal
    public void openRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> map, @Nullable class_2960 category, @Nullable EntryStack ingredientNotice, @Nullable EntryStack resultNotice) {
        if (category == null) {
            class_437 currentScreen = class_310.method_1551().field_1755;
            if (currentScreen instanceof RecipeScreen) {
                category = ((RecipeScreen) currentScreen).getCurrentCategory();
            }
        }
        class_437 screen;
        if (ConfigObject.getInstance().getRecipeScreenType() == RecipeScreenType.VILLAGER) {
            screen = new VillagerRecipeViewingScreen(map, category);
        } else if (ConfigObject.getInstance().getRecipeScreenType() == RecipeScreenType.UNSET) {
            @Nullable class_2960 finalCategory = category;
            screen = new PreRecipeViewingScreen(ScreenHelper.getLastContainerScreen(), RecipeScreenType.UNSET, true, original -> {
                ConfigObject.getInstance().setRecipeScreenType(original ? RecipeScreenType.ORIGINAL : RecipeScreenType.VILLAGER);
                ConfigManager.getInstance().saveConfig();
                openRecipeViewingScreen(map, finalCategory, ingredientNotice, resultNotice);
            });
        } else {
            screen = new RecipeViewingScreen(map, category);
        }
        if (screen instanceof RecipeScreen) {
            if (ingredientNotice != null)
                ((RecipeScreen) screen).addIngredientStackToNotice(ingredientNotice);
            if (resultNotice != null)
                ((RecipeScreen) screen).addResultStackToNotice(resultNotice);
        }
        if (class_310.method_1551().field_1755 instanceof RecipeScreen)
            ScreenHelper.storeRecipeScreen((RecipeScreen) class_310.method_1551().field_1755);
        class_310.method_1551().method_1507(screen);
    }
    
    @Override
    public void onInitializeClient() {
        ClientHelperImpl.instance = this;
        registerFabricKeyBinds();
        modNameCache.put("minecraft", "Minecraft");
        modNameCache.put("c", "Global");
        modNameCache.put("global", "Global");
    }
    
    @Override
    public void registerFabricKeyBinds() {
        String category = "key.rei.category";
        if (!FabricLoader.getInstance().isModLoaded("amecs")) {
            try {
                ConfigObjectImpl.General general = ConfigObject.getInstance().getGeneral();
                ConfigObjectImpl.General instance = general.getClass().getConstructor().newInstance();
                for (Field declaredField : general.getClass().getDeclaredFields()) {
                    if (declaredField.getType() == ModifierKeyCode.class && !declaredField.isAnnotationPresent(ConfigEntry.Gui.Excluded.class)) {
                        declaredField.setAccessible(true);
                        FakeModifierKeyCodeAdder.INSTANCE.registerModifierKeyCode(category, "config.roughlyenoughitems." + declaredField.getName(), () -> {
                            try {
                                ModifierKeyCode code = (ModifierKeyCode) declaredField.get(general);
                                return code == null ? ModifierKeyCode.unknown() : code;
                            } catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }, () -> {
                            try {
                                return (ModifierKeyCode) declaredField.get(instance);
                            } catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }, keyCode -> {
                            try {
                                declaredField.set(general, keyCode);
                            } catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                }
                KeyBindingRegistryImpl.INSTANCE.addCategory(category);
            } catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
    
}
