/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.RecipeScreen;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.widget.AutoCraftingButtonWidget;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.CategoryBaseWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.SlotBaseWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ClientHelperImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class VillagerRecipeViewingScreen
extends class_437
implements RecipeScreen {
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoryMap;
    private final List<RecipeCategory<?>> categories;
    private final List<Widget> widgets = Lists.newArrayList();
    private final List<ButtonWidget> buttonWidgets = Lists.newArrayList();
    private final List<RecipeEntry> recipeRenderers = Lists.newArrayList();
    private final List<TabWidget> tabs = Lists.newArrayList();
    public Rectangle bounds;
    public Rectangle scrollListBounds;
    private int tabsPerPage = 8;
    private int selectedCategoryIndex = 0;
    private int selectedRecipeIndex = 0;
    private double scrollAmount = 0.0;
    private double target;
    private long start;
    private long duration;
    private float scrollBarAlpha = 0.0f;
    private float scrollBarAlphaFuture = 0.0f;
    private long scrollBarAlphaFutureTime = -1L;
    private boolean draggingScrollBar = false;
    private int tabsPage = -1;
    private EntryStack ingredientStackToNotice = EntryStack.empty();
    private EntryStack resultStackToNotice = EntryStack.empty();

    public VillagerRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> categoryMap, @Nullable class_2960 category) {
        super(class_333.field_18967);
        this.categoryMap = categoryMap;
        this.categories = Lists.newArrayList(categoryMap.keySet());
        if (category != null) {
            for (int i = 0; i < this.categories.size(); ++i) {
                if (!this.categories.get(i).getIdentifier().equals((Object)category)) continue;
                this.selectedCategoryIndex = i;
                break;
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public void addIngredientStackToNotice(EntryStack stack) {
        this.ingredientStackToNotice = stack;
    }

    @Override
    public void addResultStackToNotice(EntryStack stack) {
        this.resultStackToNotice = stack;
    }

    @Override
    public class_2960 getCurrentCategory() {
        return this.categories.get(this.selectedCategoryIndex).getIdentifier();
    }

    @Override
    public void recalculateCategoryPage() {
        this.tabsPage = -1;
    }

    protected void method_25426() {
        super.method_25426();
        boolean isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        int tabSize = isCompactTabs ? 24 : 28;
        this.draggingScrollBar = false;
        this.field_22786.clear();
        this.widgets.clear();
        this.buttonWidgets.clear();
        this.recipeRenderers.clear();
        this.tabs.clear();
        int largestWidth = this.field_22789 - 100;
        int largestHeight = this.field_22790 - 40;
        RecipeCategory<?> category = this.categories.get(this.selectedCategoryIndex);
        RecipeDisplay display = this.categoryMap.get(category).get(this.selectedRecipeIndex);
        int guiWidth = class_3532.method_15340((int)(category.getDisplayWidth(display) + 30), (int)0, (int)largestWidth) + 100;
        int guiHeight = class_3532.method_15340((int)(category.getDisplayHeight() + 40), (int)166, (int)largestHeight);
        this.tabsPerPage = Math.max(5, class_3532.method_15357((double)(((double)guiWidth - 20.0) / (double)tabSize)));
        if (this.tabsPage == -1) {
            this.tabsPage = this.selectedCategoryIndex / this.tabsPerPage;
        }
        this.bounds = new Rectangle(this.field_22789 / 2 - guiWidth / 2, this.field_22790 / 2 - guiHeight / 2, guiWidth, guiHeight);
        List<List<EntryStack>> workingStations = RecipeHelper.getInstance().getWorkingStations(category.getIdentifier());
        if (!workingStations.isEmpty()) {
            int ww = class_3532.method_15375((float)((float)(this.bounds.width - 16) / 18.0f));
            int w = Math.min(ww, workingStations.size());
            int h = class_3532.method_15386((float)((float)workingStations.size() / (float)ww));
            int xx = this.bounds.x + 16;
            int yy = this.bounds.y + this.bounds.height + 2;
            this.widgets.add(new CategoryBaseWidget(new Rectangle(xx - 5, this.bounds.y + this.bounds.height - 5, 10 + w * 16, 12 + h * 16)));
            this.widgets.add(new SlotBaseWidget(new Rectangle(xx - 1, yy - 1, 2 + w * 16, 2 + h * 16)));
            int index = 0;
            List<String> list = Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662((String)"text.rei.working_station", (Object[])new Object[0]));
            for (List<EntryStack> workingStation : workingStations) {
                this.widgets.add(new RecipeViewingScreen.WorkstationSlotWidget(xx, yy, CollectionUtils.map(workingStation, stack -> stack.copy().setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> list))));
                xx += 16;
                if (++index < ww) continue;
                index = 0;
                xx = this.bounds.x + 16;
                yy += 16;
            }
        }
        this.widgets.add(new CategoryBaseWidget(this.bounds));
        this.scrollListBounds = new Rectangle(this.bounds.x + 4, this.bounds.y + 17, 102, guiHeight - 17 - 7);
        this.widgets.add(new SlotBaseWidget(this.scrollListBounds));
        Rectangle recipeBounds = new Rectangle(this.bounds.x + 100 + (guiWidth - 100) / 2 - category.getDisplayWidth(display) / 2, this.bounds.y + this.bounds.height / 2 - category.getDisplayHeight() / 2, category.getDisplayWidth(display), category.getDisplayHeight());
        List<Widget> setupDisplay = category.setupDisplay(() -> display, recipeBounds);
        RecipeViewingScreen.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
        RecipeViewingScreen.transformResultNotice(setupDisplay, this.resultStackToNotice);
        this.widgets.addAll(setupDisplay);
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getAutoCraftButtonArea(category);
        if (supplier.isPresent() && supplier.get().get(recipeBounds) != null) {
            this.widgets.add(new AutoCraftingButtonWidget(recipeBounds, supplier.get().get(recipeBounds), supplier.get().getButtonText(), () -> display, setupDisplay, category));
        }
        int index = 0;
        for (RecipeDisplay recipeDisplay : this.categoryMap.get(category)) {
            final int finalIndex = index++;
            RecipeEntry recipeEntry = category.getSimpleRenderer(recipeDisplay);
            this.recipeRenderers.add(recipeEntry);
            this.buttonWidgets.add(new ButtonWidget(new Rectangle(this.bounds.x + 5, 0, recipeEntry.getWidth(), recipeEntry.getHeight()), class_333.field_18967){

                @Override
                public void onPressed() {
                    VillagerRecipeViewingScreen.this.selectedRecipeIndex = finalIndex;
                    VillagerRecipeViewingScreen.this.method_25426();
                }

                @Override
                public boolean isHovered(int mouseX, int mouseY) {
                    return this.method_25405(mouseX, mouseY) && VillagerRecipeViewingScreen.this.scrollListBounds.contains(mouseX, mouseY) || this.focused;
                }

                @Override
                protected int getTextureId(boolean boolean_1) {
                    this.enabled = VillagerRecipeViewingScreen.this.selectedRecipeIndex != finalIndex;
                    return super.getTextureId(boolean_1);
                }

                @Override
                public boolean method_25402(double mouseX, double mouseY, int button) {
                    if (this.method_25405(mouseX, mouseY) && VillagerRecipeViewingScreen.this.scrollListBounds.contains(mouseX, mouseY) && this.enabled && button == 0) {
                        this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        this.onPressed();
                        return true;
                    }
                    return false;
                }
            });
        }
        int tabV = isCompactTabs ? 166 : 192;
        for (int i = 0; i < this.tabsPerPage; ++i) {
            int j = i + this.tabsPage * this.tabsPerPage;
            if (this.categories.size() <= j) continue;
            RecipeCategory<?> tabCategory = this.categories.get(j);
            TabWidget tab = TabWidget.create(i, tabSize, this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.tabsPage * this.tabsPerPage, this.tabsPerPage) * tabSize / 2, this.bounds.y, 0, tabV, widget -> {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                if (widget.selected) {
                    return false;
                }
                ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoryMap, tabCategory.getIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
                return true;
            });
            this.tabs.add(tab);
            tab.setRenderer(tabCategory, tabCategory.getLogo(), tabCategory.getCategoryName(), j == this.selectedCategoryIndex);
        }
        ButtonWidget w = ButtonWidget.create(new Rectangle(this.bounds.x + 2, this.bounds.y - 16, 10, 10), (class_2561)new class_2588("text.rei.left_arrow", new Object[0]), buttonWidget -> {
            --this.tabsPage;
            if (this.tabsPage < 0) {
                this.tabsPage = class_3532.method_15386((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1;
            }
            this.method_25426();
        });
        this.widgets.add(w);
        ButtonWidget w2 = ButtonWidget.create(new Rectangle(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10), (class_2561)new class_2588("text.rei.right_arrow", new Object[0]), buttonWidget -> {
            ++this.tabsPage;
            if (this.tabsPage > class_3532.method_15386((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1) {
                this.tabsPage = 0;
            }
            this.method_25426();
        });
        this.widgets.add(w2);
        w2.enabled = this.categories.size() > this.tabsPerPage;
        w.enabled = w2.enabled;
        this.widgets.add(new ClickableLabelWidget(new Point(this.bounds.x + 4 + this.scrollListBounds.width / 2, this.bounds.y + 6), this.categories.get(this.selectedCategoryIndex).getCategoryName()){

            @Override
            public void onLabelClicked() {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                ClientHelper.getInstance().executeViewAllRecipesKeyBind();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.view_all_categories", (Object[])new Object[0]));
            }
        });
        this.field_22786.addAll(this.buttonWidgets);
        this.widgets.addAll(this.tabs);
        this.field_22786.addAll(this.widgets);
        this.field_22786.add(ScreenHelper.getLastOverlay(true, false));
        ScreenHelper.getLastOverlay().init();
    }

    private double getMaxScroll() {
        return Math.max(0.0, this.getMaxScrollPosition() - (double)(this.scrollListBounds.height - 2));
    }

    public boolean method_25402(double mouseX, double mouseY, int int_1) {
        double scrollbarPositionMinX;
        int actualHeight;
        double height = this.getMaxScrollPosition();
        if (height > (double)(actualHeight = this.scrollListBounds.height - 2) && this.scrollBarAlpha > 0.0f && mouseY >= (double)(this.scrollListBounds.y + 1) && mouseY <= (double)(this.scrollListBounds.getMaxY() - 1) && mouseX >= (scrollbarPositionMinX = (double)(this.scrollListBounds.getMaxX() - 6)) & mouseX <= scrollbarPositionMinX + 8.0) {
            this.draggingScrollBar = true;
            this.scrollBarAlpha = 1.0f;
            return false;
        }
        this.draggingScrollBar = false;
        return super.method_25402(mouseX, mouseY, int_1);
    }

    public boolean method_25400(char char_1, int int_1) {
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25400(char_1, int_1)) continue;
            return true;
        }
        return super.method_25400(char_1, int_1);
    }

    public void offset(double value, boolean animated) {
        this.scrollTo(this.target + value, animated);
    }

    public void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public void scrollTo(double value, boolean animated, long duration) {
        this.target = ClothConfigInitializer.clamp((double)value, (double)this.getMaxScroll());
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scrollAmount = this.target;
        }
    }

    public boolean method_25401(double double_1, double double_2, double double_3) {
        double height = CollectionUtils.sumInt(this.buttonWidgets, b -> b.getBounds().getHeight());
        if (this.scrollListBounds.contains(double_1, double_2) && height > (double)(this.scrollListBounds.height - 2)) {
            this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlphaFuture = 1.0f;
            }
            if ((float)(System.currentTimeMillis() - this.scrollBarAlphaFutureTime) > 300.0f) {
                this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            }
            return true;
        }
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25401(double_1, double_2, double_3)) continue;
            return true;
        }
        if (this.bounds.contains(PointHelper.ofMouse())) {
            if (double_3 < 0.0 && this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.method_25426();
            } else if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.method_25426();
                return true;
            }
        }
        return super.method_25401(double_1, double_2, double_3);
    }

    private double getMaxScrollPosition() {
        return CollectionUtils.sumInt(this.buttonWidgets, b -> b.getBounds().getHeight());
    }

    public void method_25394(int mouseX, int mouseY, float delta) {
        if (ConfigObject.getInstance().doesVillagerScreenHavePermanentScrollBar()) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 0.0f;
            this.scrollBarAlpha = 1.0f;
        } else if (this.scrollBarAlphaFutureTime > 0L) {
            long l = System.currentTimeMillis() - this.scrollBarAlphaFutureTime;
            if ((float)l > 300.0f) {
                if (this.scrollBarAlphaFutureTime == 0L) {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                    this.scrollBarAlphaFutureTime = -1L;
                } else if ((float)l > 2000.0f && this.scrollBarAlphaFuture == 1.0f) {
                    this.scrollBarAlphaFuture = 0.0f;
                    this.scrollBarAlphaFutureTime = System.currentTimeMillis();
                } else {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                }
            } else if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlpha = Math.min(this.scrollBarAlpha, 1.0f - Math.min(1.0f, (float)l / 300.0f));
            } else if (this.scrollBarAlphaFuture == 1.0f) {
                this.scrollBarAlpha = Math.max(Math.min(1.0f, (float)l / 300.0f), this.scrollBarAlpha);
            }
        }
        this.updatePosition(delta);
        this.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        int yOffset = 0;
        for (Widget widget : this.widgets) {
            widget.method_25394(mouseX, mouseY, delta);
        }
        ScreenHelper.getLastOverlay().method_25394(mouseX, mouseY, delta);
        RenderSystem.pushMatrix();
        ScissorsHandler.INSTANCE.scissor(new Rectangle(0, this.scrollListBounds.y + 1, this.field_22789, this.scrollListBounds.height - 2));
        for (ButtonWidget buttonWidget : this.buttonWidgets) {
            buttonWidget.getBounds().y = this.scrollListBounds.y + 1 + yOffset - (int)this.scrollAmount;
            if (buttonWidget.getBounds().getMaxY() > this.scrollListBounds.getMinY() && buttonWidget.getBounds().getMinY() < this.scrollListBounds.getMaxY()) {
                buttonWidget.method_25394(mouseX, mouseY, delta);
            }
            yOffset += buttonWidget.getBounds().height;
        }
        for (int i = 0; i < this.buttonWidgets.size(); ++i) {
            if (this.buttonWidgets.get(i).getBounds().getMaxY() <= this.scrollListBounds.getMinY() || this.buttonWidgets.get(i).getBounds().getMinY() >= this.scrollListBounds.getMaxY()) continue;
            this.recipeRenderers.get(i).setZ(1);
            this.recipeRenderers.get(i).render(this.buttonWidgets.get(i).getBounds(), mouseX, mouseY, delta);
            REIHelper.getInstance().addTooltip(this.recipeRenderers.get(i).getTooltip(mouseX, mouseY));
        }
        double maxScroll = this.getMaxScrollPosition();
        if (maxScroll > (double)(this.scrollListBounds.height - 2)) {
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            int height = (int)((double)((this.scrollListBounds.height - 2) * (this.scrollListBounds.height - 2)) / this.getMaxScrollPosition());
            height = class_3532.method_15340((int)height, (int)32, (int)(this.scrollListBounds.height - 2 - 8));
            height = (int)((double)height - Math.min(this.scrollAmount < 0.0 ? (double)((int)(-this.scrollAmount)) : (this.scrollAmount > this.getMaxScroll() ? (double)((int)this.scrollAmount) - this.getMaxScroll() : 0.0), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = (int)Math.min(Math.max((double)((int)this.scrollAmount * (this.scrollListBounds.height - 2 - height)) / this.getMaxScroll() + (double)this.scrollListBounds.y + 1.0, (double)(this.scrollListBounds.y + 1)), (double)(this.scrollListBounds.getMaxY() - 1 - height));
            int scrollbarPositionMinX = this.scrollListBounds.getMaxX() - 6;
            int scrollbarPositionMaxX = this.scrollListBounds.getMaxX() - 1;
            boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse());
            float bottomC = (hovered ? 0.67f : 0.5f) * (REIHelper.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            float topC = (hovered ? 0.87f : 0.67f) * (REIHelper.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.shadeModel((int)7425);
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height), 800.0).method_22915(bottomC, bottomC, bottomC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + height), 800.0).method_22915(bottomC, bottomC, bottomC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 800.0).method_22915(bottomC, bottomC, bottomC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 800.0).method_22915(bottomC, bottomC, bottomC, this.scrollBarAlpha).method_1344();
            tessellator.method_1350();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height - 1), 800.0).method_22915(topC, topC, topC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 800.0).method_22915(topC, topC, topC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 800.0).method_22915(topC, topC, topC, this.scrollBarAlpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 800.0).method_22915(topC, topC, topC, this.scrollBarAlpha).method_1344();
            tessellator.method_1350();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        RenderSystem.popMatrix();
        ScreenHelper.getLastOverlay().lateRender(mouseX, mouseY, delta);
    }

    private void updatePosition(float delta) {
        double[] target = new double[]{this.target};
        this.scrollAmount = ClothConfigInitializer.handleScrollingPosition((double[])target, (double)this.scrollAmount, (double)this.getMaxScroll(), (float)delta, (double)this.start, (double)this.duration);
        this.target = target[0];
    }

    public boolean method_25403(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        int actualHeight;
        double height;
        if (int_1 == 0 && this.scrollBarAlpha > 0.0f && this.draggingScrollBar && (height = (double)CollectionUtils.sumInt(this.buttonWidgets, b -> b.getBounds().getHeight())) > (double)(actualHeight = this.scrollListBounds.height - 2) && mouseY >= (double)(this.scrollListBounds.y + 1) && mouseY <= (double)(this.scrollListBounds.getMaxY() - 1)) {
            int int_3 = class_3532.method_15340((int)((int)((double)(actualHeight * actualHeight) / height)), (int)32, (int)(actualHeight - 8));
            double double_6 = Math.max(1.0, Math.max(1.0, height) / (double)(actualHeight - int_3));
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 1.0f;
            this.scrollAmount = this.target = class_3532.method_15350((double)(this.scrollAmount + double_4 * double_6), (double)0.0, (double)(height - (double)this.scrollListBounds.height + 2.0));
            return true;
        }
        return super.method_25403(mouseX, mouseY, int_1, double_3, double_4);
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (int_1 == 258) {
            boolean boolean_1;
            boolean bl = boolean_1 = !VillagerRecipeViewingScreen.method_25442();
            if (!this.method_25407(boolean_1)) {
                this.method_25407(boolean_1);
            }
            return true;
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.method_25426();
                return true;
            }
            return false;
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.method_25426();
                return true;
            }
            return false;
        }
        for (class_364 element : this.method_25396()) {
            if (!element.method_25404(int_1, int_2, int_3)) continue;
            return true;
        }
        if (int_1 == 256 || this.field_22787.field_1690.field_1822.method_1417(int_1, int_2)) {
            class_310.method_1551().method_1507(ScreenHelper.getLastContainerScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (int_1 == 259) {
            if (ScreenHelper.hasLastRecipeScreen()) {
                this.field_22787.method_1507(ScreenHelper.getLastRecipeScreen());
            } else {
                this.field_22787.method_1507(ScreenHelper.getLastContainerScreen());
            }
            return true;
        }
        return super.method_25404(int_1, int_2, int_3);
    }
}

