/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui.subsets.entries;

import com.google.common.collect.Lists;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.*;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.subsets.SubsetsMenu;
import me.shedaniel.rei.gui.subsets.SubsetsMenuEntry;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.impl.EntryRegistryImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1109;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import org.jetbrains.annotations.ApiStatus;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

@ApiStatus.Experimental
@ApiStatus.Internal
public class SubMenuEntry extends SubsetsMenuEntry {
    public final String text;
    private int textWidth = -69;
    private int x, y, width;
    private boolean selected, containsMouse, rendering;
    private List<SubsetsMenuEntry> entries;
    private SubsetsMenu subsetsMenu;
    private class_3545<Integer, Integer> filteredRatio = null;
    private long lastListHash = -1;
    private boolean clickedBefore = false;
    
    public SubMenuEntry(String text) {
        this(text, Collections.emptyList());
    }
    
    public SubMenuEntry(String text, Supplier<List<SubsetsMenuEntry>> entries) {
        this(text, entries.get());
    }
    
    public SubMenuEntry(String text, List<SubsetsMenuEntry> entries) {
        this.text = text;
        this.entries = entries;
    }
    
    private int getTextWidth() {
        if (textWidth == -69) {
            this.textWidth = Math.max(0, font.method_1727(text));
        }
        return this.textWidth;
    }
    
    public SubsetsMenu getSubsetsMenu() {
        if (subsetsMenu == null) {
            this.subsetsMenu = new SubsetsMenu(new Point(getParent().getBounds().getMaxX() - 1, y - 1), entries);
        }
        return subsetsMenu;
    }
    
    @Override
    public int getEntryWidth() {
        return 12 + getTextWidth() + 4;
    }
    
    @Override
    public int getEntryHeight() {
        return 12;
    }
    
    @Override
    public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
        this.x = xPos;
        this.y = yPos;
        this.selected = selected;
        this.containsMouse = containsMouse;
        this.rendering = rendering;
        this.width = width;
    }
    
    @Override
    public void method_25394(int mouseX, int mouseY, float delta) {
        double filteredRatio = getFilteredRatio();
        if (filteredRatio > 0) {
            filteredRatio = filteredRatio * 0.85 + 0.15;
            method_25294(x, y, x + width, y + 12, (16711680 | class_3532.method_15384(filteredRatio * 255.0) << 24) + (selected ? 39321 : 0));
        } else if (selected) {
            method_25294(x, y, x + width, y + 12, -12237499);
        }
        if (selected) {
            if (!entries.isEmpty()) {
                SubsetsMenu menu = getSubsetsMenu();
                menu.menuStartPoint.x = getParent().getBounds().getMaxX() - 1;
                menu.menuStartPoint.y = y - 1;
                List<Rectangle> areas = Lists.newArrayList(ScissorsHandler.INSTANCE.getScissorsAreas());
                ScissorsHandler.INSTANCE.clearScissors();
                menu.method_25394(mouseX, mouseY, delta);
                for (Rectangle area : areas) {
                    ScissorsHandler.INSTANCE.scissor(area);
                }
            } else clickedBefore = false;
            if (clickedBefore) {
                if (rendering && mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 12 && !entries.isEmpty()) {
                    REIHelper.getInstance().queueTooltip(Tooltip.create("Click again to filter everything in this group."));
                } else clickedBefore = false;
            }
        } else clickedBefore = false;
        font.method_1729(text, x + 2, y + 2, selected ? 16777215 : 8947848);
        if (!entries.isEmpty()) {
            class_310.method_1551().method_1531().method_22813(TabWidget.CHEST_GUI_TEXTURE);
            method_25302(x + width - 15, y - 2, 0, 28, 18, 18);
        }
    }
    
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (rendering && mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 12 && !entries.isEmpty()) {
            if (clickedBefore) {
                clickedBefore = false;
                List<EntryStack> filteredStacks = ConfigObject.getInstance().getFilteredStacks();
                SubsetsMenu subsetsMenu = ScreenHelper.getLastOverlay().getSubsetsMenu();
                setFiltered(filteredStacks, subsetsMenu, this, !(getFilteredRatio() > 0));
                ConfigManager.getInstance().saveConfig();
                ((EntryRegistryImpl) EntryRegistry.getInstance()).refilter();
                if (ScreenHelper.getSearchField() != null)
                    ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText(), true);
            } else {
                clickedBefore = true;
            }
            minecraft.method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }
    
    private void setFiltered(List<EntryStack> filteredStacks, SubsetsMenu subsetsMenu, SubMenuEntry subMenuEntry, boolean filtered) {
        for (SubsetsMenuEntry entry : subMenuEntry.entries) {
            if (entry instanceof EntryStackMenuEntry) {
                if (((EntryStackMenuEntry) entry).isFiltered() != filtered) {
                    if (!filtered) {
                        filteredStacks.removeIf(next -> next.equalsIgnoreAmount(((EntryStackMenuEntry) entry).stack));
                    } else {
                        filteredStacks.add(((EntryStackMenuEntry) entry).stack.copy());
                    }
                }
                if (subsetsMenu != null)
                    ((EntryStackMenuEntry) entry).recalculateFilter(subsetsMenu);
            } else if (entry instanceof SubMenuEntry) {
                setFiltered(filteredStacks, subsetsMenu, (SubMenuEntry) entry, filtered);
            }
        }
    }
    
    public double getFilteredRatio() {
        class_3545<Integer, Integer> pair = getFilteredRatioPair();
        return pair.method_15441() == 0 ? 0 : pair.method_15442() / (double) pair.method_15441();
    }
    
    public class_3545<Integer, Integer> getFilteredRatioPair() {
        List<EntryStack> filteredStacks = ConfigObject.getInstance().getFilteredStacks();
        if (lastListHash != filteredStacks.hashCode()) {
            int size = 0;
            int filtered = 0;
            for (SubsetsMenuEntry entry : entries) {
                if (entry instanceof EntryStackMenuEntry) {
                    size++;
                    if (((EntryStackMenuEntry) entry).isFiltered())
                        filtered++;
                } else if (entry instanceof SubMenuEntry) {
                    class_3545<Integer, Integer> pair = ((SubMenuEntry) entry).getFilteredRatioPair();
                    filtered += pair.method_15442();
                    size += pair.method_15441();
                }
            }
            filteredRatio = new class_3545<>(filtered, size);
            lastListHash = filteredStacks.hashCode();
        }
        return filteredRatio;
    }
    
    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY))
            return true;
        if (subsetsMenu != null && !subsetsMenu.method_25396().isEmpty() && selected)
            return subsetsMenu.containsMouse(mouseX, mouseY);
        return false;
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return subsetsMenu != null && !subsetsMenu.method_25396().isEmpty() && selected && subsetsMenu.method_25401(mouseX, mouseY, amount);
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        if (subsetsMenu != null && !subsetsMenu.method_25396().isEmpty() && selected) {
            return Collections.singletonList(subsetsMenu);
        }
        return Collections.emptyList();
    }
}
