/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.class_1011;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_276;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3306;
import net.minecraft.class_364;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class RecipeDisplayExporter
extends Widget {
    private static final RecipeDisplayExporter INSTANCE = new RecipeDisplayExporter();

    private RecipeDisplayExporter() {
    }

    public static void exportRecipeDisplay(Rectangle rectangle, List<Widget> widgets) {
        INSTANCE.exportRecipe(rectangle, widgets);
    }

    private static File getExportFilename(File directory) {
        String string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        int i = 1;
        File file;
        while ((file = new File(directory, "REI_" + string + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file;
    }

    private void exportRecipe(Rectangle rectangle, List<Widget> widgets) {
        boolean disableGuiLight;
        class_276 framebuffer = new class_276(rectangle.width * 8, rectangle.height * 8, true, class_310.field_1703);
        framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        framebuffer.method_1230(class_310.field_1703);
        RenderSystem.pushMatrix();
        framebuffer.method_1235(true);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.scalef((float)(2.0f / (float)rectangle.width), (float)(-2.0f / (float)rectangle.height), (float)0.0f);
        RenderSystem.translatef((float)(-rectangle.x), (float)(-rectangle.y), (float)0.0f);
        RenderSystem.translatef((float)((float)(-rectangle.width) / 2.0f), (float)((float)(-rectangle.height) / 2.0f), (float)0.0f);
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        RenderSystem.pushLightingAttributes();
        for (Widget widget : widgets) {
            widget.method_25394(-1, -1, this.minecraft.method_1488());
        }
        class_1799 stack = new class_1799((class_1935)class_1802.field_8212);
        class_1087 model = this.minecraft.method_1480().method_4019(stack, (class_1937)this.minecraft.field_1687, (class_1309)this.minecraft.field_1724);
        this.minecraft.method_1531().method_22813(class_1059.field_5275);
        this.minecraft.method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22904((double)(rectangle.x + 8), (double)(rectangle.y + 8), 0.0);
        matrixStack.method_22905(16.0f, -16.0f, 1.0f);
        boolean bl = disableGuiLight = !model.method_24304();
        if (disableGuiLight) {
            class_308.method_24210();
        }
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        this.minecraft.method_1480().method_23179(stack, class_809.class_811.field_4317, false, matrixStack, (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
        immediate.method_22993();
        RenderSystem.enableDepthTest();
        if (disableGuiLight) {
            class_308.method_24211();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
        RenderSystem.popMatrix();
        framebuffer.method_1240();
        RenderSystem.popMatrix();
        RenderSystem.viewport((int)0, (int)0, (int)this.minecraft.method_22683().method_4489(), (int)this.minecraft.method_22683().method_4506());
        class_1011 nativeImage = new class_1011(rectangle.width * 8, rectangle.height * 8, false);
        RenderSystem.bindTexture((int)framebuffer.field_1475);
        nativeImage.method_4327(0, false);
        int width = rectangle.width * 8;
        int height = rectangle.height * 8;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (x <= 24 || x >= width - 24 || y <= 24 || y >= height - 24) continue;
                nativeImage.method_4305(x, y, nativeImage.method_4315(x, y) | 255 << class_1011.class_1012.field_4997.method_4332());
            }
        }
        nativeImage.method_4319();
        class_3306.field_14301.execute(() -> {
            try {
                File export = new File(this.minecraft.field_1697, "export");
                export.mkdirs();
                nativeImage.method_4325(RecipeDisplayExporter.getExportFilename(export));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                nativeImage.close();
                RenderSystem.recordRenderCall(() -> ((class_276)framebuffer).method_1238());
            }
        });
    }

    public void method_25394(int mouseX, int mouseY, float delta) {
    }

    public List<? extends class_364> method_25396() {
        return null;
    }
}

