/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.OverlayDecider;
import me.shedaniel.rei.utils.CollectionUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DisplayHelperImpl
implements DisplayHelper {
    private static final Comparator<OverlayDecider> BOUNDS_HANDLER_COMPARATOR;
    private static final DisplayHelper.DisplayBoundsHandler<Object> EMPTY;
    private List<OverlayDecider> screenDisplayBoundsHandlers = Lists.newArrayList();
    private Map<Class<?>, DisplayHelper.DisplayBoundsHandler<?>> handlerCache = Maps.newHashMap();
    private Map<Class<?>, List<DisplayHelper.DisplayBoundsHandler<?>>> handlerSortedCache = Maps.newHashMap();
    private BaseBoundsHandler baseBoundsHandler;
    private Class<?> tempScreen;

    @Override
    public List<DisplayHelper.DisplayBoundsHandler<?>> getSortedBoundsHandlers(Class<?> screenClass) {
        List<DisplayHelper.DisplayBoundsHandler<?>> possibleCached = this.handlerSortedCache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        this.tempScreen = screenClass;
        this.handlerSortedCache.put(screenClass, CollectionUtils.castAndMap(CollectionUtils.filter(this.screenDisplayBoundsHandlers, this::filterResponsible), DisplayHelper.DisplayBoundsHandler.class));
        return this.handlerSortedCache.get(screenClass);
    }

    @Override
    public List<OverlayDecider> getAllOverlayDeciders() {
        return Collections.unmodifiableList(this.screenDisplayBoundsHandlers);
    }

    @Override
    public DisplayHelper.DisplayBoundsHandler<?> getResponsibleBoundsHandler(Class<?> screenClass) {
        DisplayHelper.DisplayBoundsHandler<?> possibleCached = this.handlerCache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        List<DisplayHelper.DisplayBoundsHandler<?>> handlers = this.getSortedBoundsHandlers(screenClass);
        this.handlerCache.put(screenClass, handlers.isEmpty() ? EMPTY : handlers.get(0));
        return this.handlerCache.get(screenClass);
    }

    private boolean filterResponsible(OverlayDecider handler) {
        return handler.isHandingScreen(this.tempScreen);
    }

    @Override
    public void registerHandler(OverlayDecider decider) {
        this.screenDisplayBoundsHandlers.add(decider);
        this.screenDisplayBoundsHandlers.sort(BOUNDS_HANDLER_COMPARATOR);
    }

    @ApiStatus.Internal
    public BaseBoundsHandler getBaseBoundsHandler() {
        return this.baseBoundsHandler;
    }

    @ApiStatus.Internal
    public void setBaseBoundsHandler(BaseBoundsHandler baseBoundsHandler) {
        this.baseBoundsHandler = baseBoundsHandler;
    }

    @ApiStatus.Internal
    public void resetData() {
        this.screenDisplayBoundsHandlers.clear();
    }

    @ApiStatus.Internal
    public void resetCache() {
        this.handlerCache.clear();
        this.handlerSortedCache.clear();
    }

    static {
        EMPTY = new DisplayHelper.DisplayBoundsHandler<Object>(){

            @Override
            public Class<Object> getBaseSupportedClass() {
                return null;
            }

            @Override
            public Rectangle getLeftBounds(Object screen) {
                return new Rectangle();
            }

            @Override
            public Rectangle getRightBounds(Object screen) {
                return new Rectangle();
            }

            @Override
            public float getPriority() {
                return -10.0f;
            }
        };
        Comparator<OverlayDecider> comparator = Comparator.comparingDouble(OverlayDecider::getPriority);
        BOUNDS_HANDLER_COMPARATOR = comparator.reversed();
    }
}

