/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.subsets;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.subsets.SubsetsRegistry;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public class SubsetsRegistryImpl
implements SubsetsRegistry {
    private final Map<String, Set<EntryStack>> entryPaths = Maps.newHashMap();

    public void reset() {
        this.entryPaths.clear();
    }

    @Override
    @NotNull
    public List<String> getEntryPaths(@NotNull EntryStack stack) {
        ArrayList strings = null;
        for (Map.Entry<String, Set<EntryStack>> entry : this.entryPaths.entrySet()) {
            if (CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount((Collection<EntryStack>)entry.getValue(), stack) == null) continue;
            if (strings == null) {
                strings = Lists.newArrayList();
            }
            strings.add(entry.getKey());
        }
        return strings == null ? Collections.emptyList() : strings;
    }

    @Override
    public void registerPathEntry(@NotNull String path, @NotNull EntryStack stack) {
        this.getOrCreatePathEntries(path).add(stack.copy().setting(EntryStack.Settings.CHECK_AMOUNT, EntryStack.Settings.FALSE).setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
    }

    @Override
    public void registerPathEntries(@NotNull String path, @NotNull Collection<EntryStack> stacks) {
        Set<EntryStack> entries = this.getOrCreatePathEntries(path);
        for (EntryStack stack : stacks) {
            entries.add(stack.copy().setting(EntryStack.Settings.CHECK_AMOUNT, EntryStack.Settings.FALSE).setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
        }
    }

    @Override
    @Nullable
    public Set<EntryStack> getPathEntries(@NotNull String path) {
        if (!this.isPathValid(path)) {
            throw new IllegalArgumentException("Illegal path: " + path);
        }
        return this.entryPaths.get(path);
    }

    @Override
    @NotNull
    public Set<String> getPaths() {
        return this.entryPaths.keySet();
    }

    @Override
    @NotNull
    public Set<EntryStack> getOrCreatePathEntries(@NotNull String path) {
        Set<EntryStack> paths = this.getPathEntries(path);
        if (paths == null) {
            this.entryPaths.put(path, Sets.newLinkedHashSet());
            paths = Objects.requireNonNull(this.getPathEntries(path));
        }
        return paths;
    }

    private boolean isPathValid(String path) {
        String[] pathSegments;
        for (String pathSegment : pathSegments = path.split("/")) {
            if (class_2960.method_20207((String)pathSegment)) continue;
            return false;
        }
        return true;
    }
}

