/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.widgets;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.widgets.Label;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import net.minecraft.class_364;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LabelWidget
extends Label {
    private boolean focused = false;
    private boolean clickable = false;
    private int horizontalAlignment = 0;
    private boolean hasShadow = true;
    private boolean focusable = true;
    private int color = REIHelper.getInstance().isDarkThemeEnabled() ? -4473925 : -1;
    private int hoveredColor = REIHelper.getInstance().isDarkThemeEnabled() ? -1 : -10027060;
    @NotNull
    private Point point;
    @Nullable
    private @Nullable Function<Label, @Nullable String> tooltip;
    @Nullable
    private Consumer<Label> onClick;
    @Nullable
    private Consumer<Label> onRender;
    @NotNull
    private String text;

    public LabelWidget(@NotNull Point point, @NotNull String text) {
        this.point = point;
        Objects.requireNonNull(this.point);
        this.text = text;
        Objects.requireNonNull(this.text);
    }

    @Override
    public boolean isClickable() {
        return this.clickable;
    }

    @Override
    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    @Override
    @Nullable
    public Consumer<Label> getOnClick() {
        return this.onClick;
    }

    @Override
    public void setOnClick(@Nullable Consumer<Label> onClick) {
        this.onClick = onClick;
    }

    @Override
    @Nullable
    public Consumer<Label> getOnRender() {
        return this.onRender;
    }

    @Override
    public void setOnRender(@Nullable Consumer<Label> onRender) {
        this.onRender = onRender;
    }

    @Override
    public boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    @Nullable
    public String getTooltip() {
        if (this.tooltip == null) {
            return null;
        }
        return this.tooltip.apply(this);
    }

    @Override
    public void setTooltip(@Nullable @Nullable Function<Label, @Nullable String> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public boolean hasShadow() {
        return this.hasShadow;
    }

    @Override
    public void setShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getHoveredColor() {
        return this.hoveredColor;
    }

    @Override
    public void setHoveredColor(int hoveredColor) {
        this.hoveredColor = hoveredColor;
    }

    @Override
    @NotNull
    public Point getPoint() {
        return this.point;
    }

    @Override
    public void setPoint(@NotNull Point point) {
        this.point = Objects.requireNonNull(point);
    }

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(@NotNull String text) {
        this.text = Objects.requireNonNull(text);
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        int width = this.font.method_1727(this.text);
        Point point = this.getPoint();
        if (this.getHorizontalAlignment() == -1) {
            return new Rectangle(point.x - 1, point.y - 5, width + 2, 14);
        }
        if (this.getHorizontalAlignment() == 1) {
            return new Rectangle(point.x - width - 1, point.y - 5, width + 2, 14);
        }
        return new Rectangle(point.x - width / 2 - 1, point.y - 5, width + 2, 14);
    }

    public void method_25394(int mouseX, int mouseY, float delta) {
        String tooltip;
        if (this.getOnRender() != null) {
            this.getOnRender().accept(this);
        }
        int color = this.getColor();
        if (this.isClickable() && this.isHovered(mouseX, mouseY)) {
            color = this.getHoveredColor();
        }
        Point pos = this.getPoint();
        int width = this.font.method_1727(this.getText());
        switch (this.getHorizontalAlignment()) {
            case -1: {
                if (this.hasShadow()) {
                    this.font.method_1720(this.getText(), (float)pos.x, (float)pos.y, color);
                    break;
                }
                this.font.method_1729(this.getText(), (float)pos.x, (float)pos.y, color);
                break;
            }
            case 1: {
                if (this.hasShadow()) {
                    this.font.method_1720(this.getText(), (float)(pos.x - width), (float)pos.y, color);
                    break;
                }
                this.font.method_1729(this.getText(), (float)(pos.x - width), (float)pos.y, color);
                break;
            }
            default: {
                if (this.hasShadow()) {
                    this.font.method_1720(this.getText(), (float)pos.x - (float)width / 2.0f, (float)pos.y, color);
                    break;
                }
                this.font.method_1729(this.getText(), (float)pos.x - (float)width / 2.0f, (float)pos.y, color);
            }
        }
        if (this.isHovered(mouseX, mouseY) && (tooltip = this.getTooltip()) != null) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(tooltip.split("\n")).queue();
            } else if (this.focused) {
                Tooltip.create(this.point, tooltip.split("\n")).queue();
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isClickable() && this.containsMouse(mouseX, mouseY)) {
            Widgets.produceClickSound();
            if (this.onClick != null) {
                this.onClick.accept(this);
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (!(this.isClickable() && this.isFocusable() && this.focused)) {
            return false;
        }
        if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
            return false;
        }
        Widgets.produceClickSound();
        if (this.onClick != null) {
            this.onClick.accept(this);
        }
        return true;
    }

    public boolean method_25407(boolean boolean_1) {
        if (!this.isClickable() || !this.isFocusable()) {
            return false;
        }
        this.focused = !this.focused;
        return true;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.containsMouse(mouseX, mouseY) || this.focused;
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }
}

