/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.fuel;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.plugin.DefaultPlugin;
import me.shedaniel.rei.plugin.fuel.DefaultFuelDisplay;
import net.minecraft.class_1074;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class DefaultFuelCategory
implements RecipeCategory<DefaultFuelDisplay> {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    @Override
    public class_2960 getIdentifier() {
        return DefaultPlugin.FUEL;
    }

    @Override
    public String getCategoryName() {
        return class_1074.method_4662((String)"category.rei.fuel", (Object[])new Object[0]);
    }

    @Override
    public int getDisplayHeight() {
        return 49;
    }

    @Override
    public EntryStack getLogo() {
        return EntryStack.create((class_1935)class_1802.field_8713);
    }

    @Override
    public List<Widget> setupDisplay(DefaultFuelDisplay recipeDisplay, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 17);
        String burnItems = DECIMAL_FORMAT.format((double)recipeDisplay.getFuelTime() / 200.0);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createLabel(new Point(bounds.x + 26, bounds.getMaxY() - 15), class_1074.method_4662((String)"category.rei.fuel.time.items", (Object[])new Object[]{burnItems})).color(-12566464, -4473925).noShadow().leftAligned());
        widgets.add(Widgets.createBurningFire(new Point(bounds.x + 6, startPoint.y + 1)).animationDurationTicks(recipeDisplay.getFuelTime()));
        widgets.add(Widgets.createSlot(new Point(bounds.x + 6, startPoint.y + 18)).entries((Collection<EntryStack>)recipeDisplay.getInputEntries().get(0)).markInput());
        return widgets;
    }

    @Override
    public RecipeEntry getSimpleRenderer(DefaultFuelDisplay recipe) {
        final Slot slot = Widgets.createSlot(new Point(0, 0)).entries((Collection<EntryStack>)recipe.getInputEntries().get(0)).disableBackground().disableHighlight();
        final String burnItems = DECIMAL_FORMAT.format((double)recipe.getFuelTime() / 200.0);
        return new RecipeEntry(){

            @Override
            public int getHeight() {
                return 22;
            }

            @Override
            @Nullable
            public Tooltip getTooltip(Point point) {
                if (slot.containsMouse(point)) {
                    return slot.getCurrentTooltip(point);
                }
                return null;
            }

            @Override
            public void render(Rectangle bounds, int mouseX, int mouseY, float delta) {
                slot.setZ(this.getZ() + 50);
                slot.getBounds().setLocation(bounds.x + 4, bounds.y + 2);
                slot.method_25394(mouseX, mouseY, delta);
                class_310.method_1551().field_1772.method_1720(class_1074.method_4662((String)"category.rei.fuel.time_short.items", (Object[])new Object[]{burnItems}), (float)(bounds.x + 25), (float)(bounds.y + 8), -1);
            }
        };
    }
}

