/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.widgets;

import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Label
extends WidgetWithBounds {
    public static final int LEFT_ALIGNED = -1;
    public static final int CENTER = 0;
    public static final int RIGHT_ALIGNED = 1;

    public abstract boolean isClickable();

    public abstract void setClickable(boolean var1);

    @NotNull
    public final Label clickable() {
        return this.clickable(true);
    }

    @NotNull
    public final Label clickable(boolean clickable) {
        this.setClickable(clickable);
        return this;
    }

    @Nullable
    public abstract Consumer<Label> getOnClick();

    public abstract void setOnClick(@Nullable Consumer<Label> var1);

    @NotNull
    public final Label onClick(@Nullable Consumer<Label> onClick) {
        this.setOnClick(onClick);
        return this;
    }

    @Nullable
    public abstract Consumer<Label> getOnRender();

    public abstract void setOnRender(@Nullable Consumer<Label> var1);

    @NotNull
    public final Label onRender(@Nullable Consumer<Label> onRender) {
        this.setOnRender(onRender);
        return this;
    }

    public abstract boolean isFocusable();

    public abstract void setFocusable(boolean var1);

    @NotNull
    public final Label focusable(boolean focusable) {
        this.setFocusable(focusable);
        return this;
    }

    @Nullable
    public abstract String getTooltip();

    public abstract void setTooltip(@Nullable @Nullable Function<Label, @Nullable String> var1);

    @NotNull
    public final Label tooltipLines(String ... tooltip) {
        return this.tooltipLine(String.join((CharSequence)"\n", tooltip));
    }

    @NotNull
    public final Label tooltipLine(@Nullable String tooltip) {
        return this.tooltipSupplier(label -> tooltip);
    }

    @NotNull
    public final Label tooltipSupplier(@Nullable @Nullable Function<Label, @Nullable String> tooltip) {
        this.setTooltip(tooltip);
        return this;
    }

    public abstract int getHorizontalAlignment();

    @NotNull
    public final Label centered() {
        return this.horizontalAlignment(0);
    }

    @NotNull
    public final Label leftAligned() {
        return this.horizontalAlignment(-1);
    }

    @NotNull
    public final Label rightAligned() {
        return this.horizontalAlignment(1);
    }

    public abstract void setHorizontalAlignment(int var1);

    public final Label horizontalAlignment(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
        return this;
    }

    public abstract boolean hasShadow();

    @NotNull
    public final Label noShadow() {
        return this.shadow(false);
    }

    @NotNull
    public final Label shadow() {
        return this.shadow(true);
    }

    public abstract void setShadow(boolean var1);

    @NotNull
    public final Label shadow(boolean hasShadow) {
        this.setShadow(hasShadow);
        return this;
    }

    public abstract int getColor();

    public abstract void setColor(int var1);

    @NotNull
    public final Label color(int lightModeColor, int darkModeColor) {
        return this.color(REIHelper.getInstance().isDarkThemeEnabled() ? darkModeColor : lightModeColor);
    }

    @NotNull
    public final Label color(int color) {
        this.setColor(color);
        return this;
    }

    public abstract int getHoveredColor();

    public abstract void setHoveredColor(int var1);

    @NotNull
    public final Label hoveredColor(int lightModeColor, int darkModeColor) {
        return this.hoveredColor(REIHelper.getInstance().isDarkThemeEnabled() ? darkModeColor : lightModeColor);
    }

    @NotNull
    public final Label hoveredColor(int color) {
        this.setHoveredColor(color);
        return this;
    }

    @NotNull
    public abstract Point getPoint();

    public final int getX() {
        return this.getPoint().getX();
    }

    public final int getY() {
        return this.getPoint().getY();
    }

    public abstract void setPoint(@NotNull Point var1);

    @NotNull
    public final Label point(@NotNull Point point) {
        this.setPoint(point);
        return this;
    }

    @NotNull
    public abstract String getText();

    public abstract void setText(@NotNull String var1);

    @NotNull
    public final Label text(@NotNull String text) {
        this.setText(text);
        return this;
    }
}

