/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.widgets;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.shedaniel.math.Dimension;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DrawableConsumer;
import me.shedaniel.rei.api.widgets.Arrow;
import me.shedaniel.rei.api.widgets.BurningFire;
import me.shedaniel.rei.api.widgets.Button;
import me.shedaniel.rei.api.widgets.Label;
import me.shedaniel.rei.api.widgets.Panel;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.widgets.ArrowWidget;
import me.shedaniel.rei.impl.widgets.BurningFireWidget;
import me.shedaniel.rei.impl.widgets.ButtonWidget;
import me.shedaniel.rei.impl.widgets.DrawableWidget;
import me.shedaniel.rei.impl.widgets.FillRectangleDrawableConsumer;
import me.shedaniel.rei.impl.widgets.LabelWidget;
import me.shedaniel.rei.impl.widgets.PanelWidget;
import me.shedaniel.rei.impl.widgets.TexturedDrawableConsumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Widgets {
    private Widgets() {
    }

    @NotNull
    public static Widget createDrawableWidget(@NotNull DrawableConsumer drawable) {
        return new DrawableWidget(drawable);
    }

    @NotNull
    public static Widget wrapVanillaWidget(@NotNull class_364 element) {
        return new VanillaWrappedWidget(element);
    }

    @NotNull
    public static Widget createTexturedWidget(@NotNull class_2960 identifier, @NotNull Rectangle bounds) {
        return Widgets.createTexturedWidget(identifier, bounds, 0.0f, 0.0f);
    }

    @NotNull
    public static Widget createTexturedWidget(@NotNull class_2960 identifier, int x, int y, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, 0.0f, 0.0f, width, height);
    }

    @NotNull
    public static Widget createTexturedWidget(@NotNull class_2960 identifier, @NotNull Rectangle bounds, float u, float v) {
        return Widgets.createTexturedWidget(identifier, bounds, u, v, 256, 256);
    }

    @NotNull
    public static Widget createTexturedWidget(@NotNull class_2960 identifier, int x, int y, float u, float v, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, 256, 256);
    }

    @NotNull
    public static Widget createTexturedWidget(@NotNull class_2960 identifier, @NotNull Rectangle bounds, float u, float v, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, bounds.width, bounds.height, textureWidth, textureHeight);
    }

    @NotNull
    public static Widget createTexturedWidget(@NotNull class_2960 identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, width, height, textureWidth, textureHeight);
    }

    @NotNull
    public static Widget createTexturedWidget(@NotNull class_2960 identifier, @NotNull Rectangle bounds, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, uWidth, vHeight, textureWidth, textureHeight);
    }

    @NotNull
    public static Widget createTexturedWidget(@NotNull class_2960 identifier, int x, int y, float u, float v, int width, int height, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createDrawableWidget(new TexturedDrawableConsumer(identifier, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight));
    }

    @NotNull
    public static Widget createFilledRectangle(@NotNull Rectangle rectangle, int color) {
        return Widgets.createDrawableWidget(new FillRectangleDrawableConsumer(rectangle, color));
    }

    @NotNull
    public static Label createLabel(@NotNull Point point, @NotNull String text) {
        return new LabelWidget(point, text);
    }

    @NotNull
    public static Label createClickableLabel(@NotNull Point point, @NotNull String text, @Nullable Consumer<Label> onClick) {
        return new LabelWidget(point, text).clickable().onClick(onClick);
    }

    @NotNull
    public static Arrow createArrow(@NotNull Point point) {
        return new ArrowWidget(new Rectangle(point, new Dimension(24, 17)));
    }

    @NotNull
    public static BurningFire createBurningFire(@NotNull Point point) {
        return new BurningFireWidget(new Rectangle(point, new Dimension(14, 14)));
    }

    @NotNull
    public static Widget createSlotBackground(@NotNull Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 1, point.y - 1, 18, 18));
    }

    @NotNull
    public static Widget createResultSlotBackground(@NotNull Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 5, point.y - 5, 26, 26));
    }

    @NotNull
    public static Panel createRecipeBase(@NotNull Rectangle rectangle) {
        return new PanelWidget(rectangle).yTextureOffset(ConfigObject.getInstance().getRecipeBorderType().getYOffset()).rendering(Widgets::shouldRecipeBaseRender);
    }

    @NotNull
    public static Panel createCategoryBase(@NotNull Rectangle rectangle) {
        return new PanelWidget(rectangle).yTextureOffset(ConfigObject.getInstance().getRecipeBorderType().getYOffset()).rendering(Widgets::shouldSlotBaseRender);
    }

    private static boolean shouldRecipeBaseRender(@NotNull Panel panel) {
        return ConfigObject.getInstance().getRecipeBorderType().isRendering() && PanelWidget.isRendering(panel);
    }

    @NotNull
    public static Panel createRecipeBase(@NotNull Rectangle rectangle, int color) {
        return Widgets.createRecipeBase(rectangle).color(color);
    }

    @NotNull
    public static Panel createCategoryBase(@NotNull Rectangle rectangle, int color) {
        return Widgets.createCategoryBase(rectangle).color(color);
    }

    @NotNull
    public static Panel createSlotBase(@NotNull Rectangle rectangle) {
        return new PanelWidget(rectangle).yTextureOffset(-66).rendering(Widgets::shouldSlotBaseRender);
    }

    private static boolean shouldSlotBaseRender(@NotNull Panel panel) {
        return true;
    }

    @NotNull
    public static Panel createSlotBase(@NotNull Rectangle rectangle, int color) {
        return Widgets.createSlotBase(rectangle).color(color);
    }

    @NotNull
    public static Slot createSlot(@NotNull Point point) {
        return EntryWidget.create(point.x, point.y);
    }

    @NotNull
    public static Button createButton(@NotNull Rectangle bounds, @NotNull String text) {
        return new ButtonWidget(bounds, text);
    }

    @NotNull
    public static Button createButton(@NotNull Rectangle bounds, @NotNull class_2561 text) {
        return new ButtonWidget(bounds, text);
    }

    public static void produceClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
    }

    private static class VanillaWrappedWidget
    extends Widget {
        private class_364 element;

        public VanillaWrappedWidget(class_364 element) {
            this.element = Objects.requireNonNull(element);
        }

        public void method_25394(int mouseX, int mouseY, float delta) {
            if (this.element instanceof class_332) {
                ((class_332)this.element).method_25304(this.getZ());
            }
            if (this.element instanceof class_4068) {
                ((class_4068)this.element).method_25394(mouseX, mouseY, delta);
            }
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.element);
        }
    }
}

